
/* include the library headers */
#include <lcrzo.h>
#if defined _POSIX_SOURCE
 #undef _POSIX_SOURCE
#endif
#define _POSIX_SOURCE 1
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>

/*-------------------------------------------------------------*/
/* set information about this example */
lcrzoex_infos lcrzoex_000177=
{ /*reference*/     "lcrzoex", 177,
  /*version*/       1, 0,
  /*title*/         "virtual tcp computer (answer arp, rarp, ping, udpecho, ftp, smtp)",
  /*french title*/  "machine tcp virtuelle (repond a arp, rarp, ping, udpecho, ftp, smtp)",
  /*description*/   "Note: protocol are not really implemented",
  /*french desc.*/  "Note: les protocoles ne sont pas rellement implementes",
  /*usage*/         "device serveth servname",
  /*french usage*/  "device ethserv nomserv",
  /*usage example*/ "eth0 aa:bb:cc:dd:ee:ff 1.2.3.4",
  /*fr. usage ex.*/ "eth0 aa:bb:cc:dd:ee:ff 1.2.3.4",
  /*author*/        "Laurent"
};

/*-------------------------------------------------------------*/
/* function declarations */
int lcrzoex_000177_main(int argc, char *argv[]);
void lcrzoex_000177_sig_received(int i);
int lcrzoex_000177_computer(lcrzo_device device,
			    lcrzo_etha servereth,
			    lcrzo_ipl serveripl);
void ferr(int ret, lcrzo_conststring errortext);
int lcrzoex_000177_echo(lcrzo_sock *psock,
			lcrzo_bool printbanner);

/*-------------------------------------------------------------*/
/* main function : you can rename it to "main", and then this file
   can be compiled alone. */
int lcrzoex_000177_main(int argc, char *argv[])
{ lcrzo_device device;
  lcrzo_etha servereth;
  lcrzo_ipl serveripl;

  if ( argc<4 )
  { /* print usage */
    lcrzo_epr(lcrzoex_infos_print(lcrzoex_000177, argv[0]));
    return(LCRZO_ERR_BULCRZOEXBADUSAGE);
  }

  /* initialize the device */
  lcrzo_epr(lcrzo_device_init(argv[1], device));

  /* initialize Ethernet address */
  lcrzo_epr(lcrzo_etha_init_eths(argv[2], servereth));

  /* initialize IP address */
  lcrzo_epr(lcrzo_ipl_init_hs(argv[3], &serveripl));

  /* create a virtual computer using these adresses */
  lcrzo_epr(lcrzoex_000177_computer(device, servereth, serveripl));

  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
/* global variables */
int lcrzoex_000177_pid_udp07;
int lcrzoex_000177_pid_tcp21;
int lcrzoex_000177_pid_tcp25;

/*-------------------------------------------------------------*/
int lcrzoex_000177_computer(lcrzo_device device,
			    lcrzo_etha servereth,
			    lcrzo_ipl serveripl)
{ lcrzo_sock sock;
  lcrzo_ips ips;
  int status, language;

  /* create the FTP server */
  lcrzoex_000177_pid_tcp21=fork();
  if (lcrzoex_000177_pid_tcp21<0) return(LCRZO_ERR_FUFORK);
  if (lcrzoex_000177_pid_tcp21==0)
  { while(1) /* actually, virtual tcp servers of lcrzo does not support
                multiclient servers. So we can only have a client at
		a given time */
    { /* initialize the socket */
      ferr(lcrzo_sock_tcpser_virt(device, servereth, serveripl, 21, &sock),
	   "openning ftp server");
      /* echo every data */
      ferr(lcrzoex_000177_echo(&sock, LCRZO_TRUE), "using ftp server");
      /* close the socket */
      ferr(lcrzo_sock_close(sock), "closing ftp server");
    }
  }

  /* from now on, only the ftp server answers to icmp, arp and rarp */
  lcrzo_global_set_cliser_virt_answeralive(LCRZO_FALSE);

  /* create the SMTP server */
  lcrzoex_000177_pid_tcp25=fork();
  if (lcrzoex_000177_pid_tcp25<0) return(LCRZO_ERR_FUFORK);
  if (lcrzoex_000177_pid_tcp25==0)
  { while(1) /* actually, virtual tcp servers of lcrzo does not support
                multiclient servers. So we can only have a client at
		a given time */
    { /* initialize the socket */
      ferr(lcrzo_sock_tcpser_virt(device, servereth, serveripl, 25, &sock),
	   "openning smtp server");
      /* echo every data */
      ferr(lcrzoex_000177_echo(&sock, LCRZO_TRUE), "using smtp server");
      /* close the socket */
      ferr(lcrzo_sock_close(sock), "closing smtp server");
    }
  }

  /* create the udp echo server */
  lcrzoex_000177_pid_udp07=fork();
  if (lcrzoex_000177_pid_udp07<0) return(LCRZO_ERR_FUFORK);
  if (lcrzoex_000177_pid_udp07==0)
  { while(1)
    { /* initialize the socket */
      /* we could use lcrzo_sock_udpmulser_virt, but it is not possible
         to write using an udp multiclient server. So we only loop
         through every client request. */
      ferr(lcrzo_sock_udpser_virt(device, servereth, serveripl, 7, &sock),
	   "openning udp echo server");
      /* echo every data */
      ferr(lcrzoex_000177_echo(&sock, LCRZO_FALSE), "using echo server");
      /* close the socket */
      ferr(lcrzo_sock_close(sock), "closing udp echo server");
    }
  }

  /* print what user can do */
  lcrzo_global_get_language(&language);
  lcrzo_epr(lcrzo_ips_init_ipl(serveripl, ips));
  if ( language==LCRZO_GLOBAL_FRLANG )
    printf("Vous pouvez maintenant entrer, depuis une autre machine :\n");
  else
    printf("You can now enter, from another computer :\n");
  printf(" ping %s\n", ips);
  printf(" telnet %s 21\n", ips);
  printf(" telnet %s 25\n", ips);
  printf(" lcrzoex 168 %s 7\n", ips);

  /* wait for processus end */
  signal(SIGINT, lcrzoex_000177_sig_received);
  waitpid(lcrzoex_000177_pid_tcp21, &status, 0);
  waitpid(lcrzoex_000177_pid_tcp25, &status, 0);
  waitpid(lcrzoex_000177_pid_udp07, &status, 0);

  return(LCRZO_ERR_OK);
}

/*-------------------------------------------------------------*/
void lcrzoex_000177_sig_received(int i)
{ int status, language;

  lcrzo_global_get_language(&language);
  if ( language==LCRZO_GLOBAL_FRLANG )
    printf("Fermeture (recu : SIG%d)\n", i);
  else
    printf("Closing (received : SIG%d)\n", i);
  kill(lcrzoex_000177_pid_tcp21, SIGINT);
  waitpid(lcrzoex_000177_pid_tcp21, &status, 0);
  kill(lcrzoex_000177_pid_tcp25, SIGINT);
  waitpid(lcrzoex_000177_pid_tcp25, &status, 0);
  kill(lcrzoex_000177_pid_udp07, SIGINT);
  waitpid(lcrzoex_000177_pid_udp07, &status, 0);
  raise(SIGTERM);
}

/*-------------------------------------------------------------*/
void ferr(int ret, lcrzo_conststring errortext)
{ if (ret!=LCRZO_ERR_OK) 
  { printf("Error in %s\n", errortext);
    lcrzo_err_print(ret);
    _exit(ret);
  }
}

/*-------------------------------------------------------------*/
int lcrzoex_000177_echo(lcrzo_sock *psock,
			lcrzo_bool printbanner)
{ lcrzo_data data;
  lcrzo_int32 datasize;
  lcrzo_bool leave;
  int language, ret;

  /* we eventually print a banner */
  lcrzo_er(lcrzo_global_get_language(&language));
  if (printbanner)
  { if ( language==LCRZO_GLOBAL_FRLANG )
    { lcrzo_er(lcrzo_data_initm_text(
	       "Bonjour, ce serveur n'implemente pas le protocole.\r\n"
	       "Les donnees entrees sont simplement retournees.\r\n"
	       "Entrez 'QUIT' pour quitter.\r\n", &data, &datasize));
    }
    else
    { lcrzo_er(lcrzo_data_initm_text(
	       "Hello, this server doesn't really implement the protocol.\r\n"
	       "Received data is simply echoed back.\r\n"
	       "Enter 'QUIT' to leave.\r\n", &data, &datasize));
    }
    lcrzo_er(lcrzo_sock_write(*psock, data, datasize));
    lcrzo_er(lcrzo_data_free(data));
  }

  /* read data and simply echo it back */
  leave=LCRZO_FALSE;
  while(!leave)
  { lcrzo_er(lcrzo_sock_readm(psock, LCRZO_TRUE, &data, &datasize));
    if ( datasize!=0 )
    { /* display data on stdout */
      puts("");
      lcrzo_er(lcrzo_sock_print_infos(*psock));
      if ( language==LCRZO_GLOBAL_FRLANG )
        puts("On vient de lire :");
      else
        puts("We read :");
      lcrzo_er(lcrzo_data_print(data, datasize, LCRZO_PRINTTYPE_DUMP));
      /* write data back */
      lcrzo_er(lcrzo_sock_write(*psock, data, datasize));
      /* check for a 'QUIT' */
      ret=lcrzo_data_search_re(data, datasize, LCRZO_FALSE, +1, -1,
			       "^ *[Qq][Uu][Ii][Tt]",
			       NULL, NULL, NULL, NULL);
      if (ret==LCRZO_ERR_OK) leave=LCRZO_TRUE;
    }
    lcrzo_er(lcrzo_data_free(data));
  }

  return(LCRZO_ERR_OK);
}



