/***************************************************************************
 *   Copyright (C) 2005 Meni Livne <livne@kde.org>                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <phish.h>

#define BUF_SIZE 1024

#define USER_AGENT "FakeUA/1.0"
#define CLIENT_VER "FakeUA Anti-Phishing Toolbar 0.1.0"

int main(int argc, char *argv[])
{
  phish_result_t r;

  phish_init(USER_AGENT, CLIENT_VER);
  
  phish_mode_t mode;
  const char *query_url;
  const char *country_url;
  const char *report_url;
  const char *xml_url;
  const char *xml_file;
  const char *safelist_file;
/*  const char *etag;*/

  phish_runningMode(&mode);
  phish_siteQueryURL(&query_url);
  phish_countryQueryURL(&country_url);
  phish_reportSiteURL(&report_url);
  phish_localXMLFile(&xml_file);
  phish_remoteXMLURL(&xml_url);
  phish_safeListFile(&safelist_file);
/*  phish_remoteXMLETag(&etag);*/

  printf("Settings:\n");
  printf("mode = %d\n", mode);
  printf("site_query_url = %s\n", query_url);
  printf("country_checking_url = %s\n", country_url);
  printf("report_site_url = %s\n", report_url);
  printf("local_xml_location = %s\n", xml_file);
  printf("remote_xml_url = %s\n", xml_url);
  printf("safelist_file_location = %s\n", safelist_file);
/*  printf("remote_xml_etag = %s\n", etag);*/

  while (1)
  {
    char url[BUF_SIZE];
    phish_url_data_t results;
    int safe;
    int res;

    printf("\n%s\n", "Enter a URL to check.");

    if (scanf("%s", url) == EOF)
      break;

    if ((res = phish_checkURL(url, &results)) == PHISH_SUCCESS)
      printf("Results:\n"
             "Server: %d\n"
             "IP: %d\n"
             "Path: %d\n"
             "Country: %s\n\n"
             "Risk Level: %d\n\n", results.server, results.ip,
             results.path, results.country, results.risk_level);
    else
    {
      printf("Error with phish_checkURL. Error code is %d.\n", res);
      phish_shutdown();
      return 0;
    }

    if (results.comments_length == 0)
      printf("No comments\n");
    else
    {
      printf("Comments:\n"
             "%s\n", results.comments);
    }

    phish_deleteURLData(&results);
    
    phish_checkSafeList(url, &safe);
    printf("%s\n", (safe) ? "URL is in safe list" : "URL is not in safe list");
    
    r = phish_downloadDBAsXML();
    if (r == PHISH_XML_NOT_MODIFIED)
      printf("XML file on server not modified.\n");
    else if (r != PHISH_SUCCESS)
      fprintf(stderr, "Error downloading XML file on server: %d\n", r);
    else
      printf("XML file on server downloaded.\n");
  }
  
  phish_shutdown();
  
  return 0;
}

