/***************************************************************************
 *   Copyright (C) 2006 Meni Livne <livne@kde.org>                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include "../phish_util_url.h"
#include "../phish.h"

int main(int argc, char *argv[])
{
  phish_result_t result;
  phish_util_url_t url;
  
  if (argc != 2)
  {
    printf("Usage: %s url\n", argv[0]);
    exit(1);
  }

  phish_util_initURL(&url);

  result = phish_util_strToURL(argv[1], &url);
  
  if (result != PHISH_SUCCESS)
  {
    switch(result)
    {
      case PHISH_ERR_MALFORMED_URL:
        fprintf(stderr, "Malformed URL\n");
        break;
      case PHISH_ERR_MEMORY:
        fprintf(stderr, "Memory allocation error\n");
        break;
    }
  }
  else
  {
    phish_url_data_t results;

    phish_util_checkURLScheme(&url, &results);
    
    printf("Protocol: %s\n"
           "User: %s\n"
           "Password: %s\n"
           "Host: %s\n"
           "Port: %d\n"
           "Path: %s\n"
           "Anchor: %s\n"
           "User scheme: %d\n"
           "Suspicious host: %d\n", url.protocol, url.user, url.password,
                                    url.host, url.port, url.path, url.anchor,
                                    results.user_scheme,
                                    results.suspicious_host);

    phish_util_deleteURL(&url);
  }
  
  return 0;
}


