/*

 [=-- LIBVG --=]  DEMO SUITE  [=------------------------------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE AT YOUR OWN RISK

*/
#include <libvg.h>
#include "demo.h"


/*
 *	[ OBJECT INFO DUMPER ]
 *      (--------------------)----------------------------------------------- 
 */

int	verbose = 0;

void	help(char *progname)
{	
	printf("%s\n", BANNER);
	printf("%s <pid> <obj_name>\n\n", progname);
	exit(0);
}

int	print_hdr(vg_object *obj)
{
	if (!vg_obj_get_hdr(obj))
		return (-1);

	printf("\n\t[ EHDR ]\n");

	printf(": vaddr		= 0x%08lx\n", vg_obj_hdr_get_vaddr(obj));
	printf(": size		= 0x%08x\n", vg_obj_hdr_get_size(obj));
	printf(": offset	= 0x%08lx\n", vg_obj_hdr_get_offset(obj));

	if (verbose) {
	printf(" e_type       %d\n",      vg_obj_hdr_get_type(obj));
	printf(" e_machine    %d\n",      vg_obj_hdr_get_machine(obj));
	printf(" e_version    %d\n",      vg_obj_hdr_get_version(obj));
	printf(" e_phentsize  0x%x\n",    vg_obj_hdr_get_phentsize(obj));
	printf(" e_shentsize  0x%x\n",    vg_obj_hdr_get_shentsize(obj));
	printf(" e_ehzie      0x%x\n",    vg_obj_hdr_get_ehsize(obj));
	printf(" e_entry      0x%08x\n",  vg_obj_hdr_get_entry(obj));
	printf(" e_shnum      %d\n",      vg_obj_hdr_get_shnum(obj));
	printf(" e_phnum      %d\n",      vg_obj_hdr_get_phnum(obj));
	printf(" e_shoff      0x%x\n",    vg_obj_hdr_get_shoff(obj));
	printf(" e_phoff      0x%x\n",    vg_obj_hdr_get_phoff(obj));
	}

	return (0);
}

int	print_phdr(vg_object *obj)
{
	Elf32_Phdr	*p;
	int		idx;

	if (!vg_obj_get_phdr(obj,0))
		return (-1);

	printf("\n\t[ PHDR ]\n");

	printf(": vaddr		= 0x%08lx\n", vg_obj_phdr_get_vaddr(obj));
	printf(": offset	= 0x%08lx\n", vg_obj_phdr_get_offset(obj));
	printf(": size	 	= 0x%08x\n",  vg_obj_phdr_get_size(obj));
	printf(": entsize	= 0x%08x\n",  vg_obj_phdr_get_entsize(obj));
	printf(": entnum	= 0x%08x\n",  vg_obj_phdr_get_entnum(obj));

	if (verbose) {
	for (idx = 0; idx < vg_obj_phdr_get_entnum(obj); idx++) {
		if ((p = vg_obj_phentry_by_idx(obj, idx))) {
			printf("[%d]  p_type       %d\n", idx, vg_obj_phentry_get_type(obj, p));
			printf("     p_offset     0x%x\n", vg_obj_phentry_get_offset(obj, p));
			printf("     p_vaddr      0x%x\n", vg_obj_phentry_get_vaddr(obj, p));
			printf("     p_paddr      0x%x\n", vg_obj_phentry_get_paddr(obj, p));
			printf("     p_memsz      0x%x\n", vg_obj_phentry_get_memsz(obj, p));
			printf("     p_filesz     0x%x\n", vg_obj_phentry_get_filesz(obj, p));
		}
	}
	}

	return (0);
}

int	print_dynamic(vg_object *obj)
{
	Elf32_Dyn	*d;
	int		idx;

	if (!(d = vg_obj_get_dyn(obj,0)))
		return (-1);

	printf("\n\t[ DYNAMIC ]\n");

	printf(": vaddr 	= 0x%08lx\n", vg_obj_dyn_get_vaddr(obj));
	printf(": offset 	= 0x%08lx\n", vg_obj_dyn_get_offset(obj));
	printf(": size 		= 0x%08x\n",  vg_obj_dyn_get_size(obj));
	printf(": entnum	= 0x%08x\n",  vg_obj_dyn_get_entnum(obj));
	printf(": entsize	= 0x%08x\n",  vg_obj_dyn_get_entsize(obj));

	if (verbose) {
	for (idx = 0; idx < vg_obj_dyn_get_entnum(obj); idx++, d++) {
		printf("#%02d d_val 0x%08lx d_tag %02d %s\n", 
				idx,
				vg_obj_dentry_get_ptr(obj, d),
				vg_obj_dentry_get_tag(obj, d),
				vg_obj_dentry_get_str(obj, d));
	}
	}

	return (0);
}

int	print_dynsym(vg_object *obj)
{
	Elf32_Sym	*s;
	int		idx;
	
	if (!(s = vg_obj_get_dynsym(obj,0)))	
		return (-1);

	printf("\n\t[ DYNSYM ]\n");

	printf(": vaddr		= 0x%08lx\n", vg_obj_dynsym_get_vaddr(obj));
	printf(": offset	= 0x%08lx\n", vg_obj_dynsym_get_offset(obj));
	printf(": size		= 0x%08x\n",  vg_obj_dynsym_get_size(obj));
	printf(": entnum	= 0x%08x\n",  vg_obj_dynsym_get_entnum(obj));
	printf(": entsize	= 0x%08x\n",  vg_obj_dynsym_get_entsize(obj));

	if (verbose) { 
	for (idx = 0; idx < vg_obj_dynsym_get_entnum(obj); idx++) {	
		if (!(s = vg_obj_dsym_by_idx(obj, idx)))
			continue;

		printf("#%02d value 0x%08x size 0x%08x name %s\n", 
			idx,
			vg_obj_dsym_get_value(obj,s),
			vg_obj_dsym_get_size(obj,s),
			vg_obj_dsym_get_strname(obj,s));
	}
	}

	return (0);
}

int	print_dynstr(vg_object *obj)
{
	if (!vg_obj_get_dynstr(obj))
		return (-1);

	printf("\n\t[ DYNSTR ]\n");

	printf(": vaddr         = 0x%08lx\n", vg_obj_dynstr_get_vaddr(obj));
	printf(": offset        = 0x%08lx\n", vg_obj_dynstr_get_offset(obj));
	printf(": size          = 0x%08x\n",  vg_obj_dynstr_get_size(obj));

	return (0);
}

int	print_relplt(vg_object *obj)
{
	Elf32_Rel	*r;
	int		idx;

	if (!(r = vg_obj_get_relplt(obj,0)))
		return (-1);

	printf("\n\t[ RELPLT ]\n");

	printf(": vaddr         = 0x%08lx\n", vg_obj_relplt_get_vaddr(obj));
	printf(": offset        = 0x%08lx\n", vg_obj_relplt_get_offset(obj));
	printf(": size          = 0x%08x\n",  vg_obj_relplt_get_size(obj));
	printf(": entnum        = 0x%08x\n",  vg_obj_relplt_get_entnum(obj));
	printf(": entsize       = 0x%08x\n",  vg_obj_relplt_get_entsize(obj));

	if (verbose) {
	for (idx = 0; idx < vg_obj_relplt_get_entnum(obj); idx++) {
		if (!(r = vg_obj_relplt_rentry_by_idx(obj, idx)))
			continue;

		printf("#%02d offset 0x%08x type %03d symidx %03d\n",
			idx,
			vg_obj_rentry_get_offset(obj,r),
			vg_obj_rentry_get_info_type(obj,r),
			vg_obj_rentry_get_info_symidx(obj,r));
	}
	}

	return (0);
}

int	print_reldyn(vg_object *obj)
{
	Elf32_Rel	*r;
	int		idx;

	if (!(r = vg_obj_get_reldyn(obj,0)))
		return (-1);

	printf("\n\t[ RELDYN ]\n");

	printf(": vaddr         = 0x%08lx\n", vg_obj_reldyn_get_vaddr(obj));
	printf(": offset        = 0x%08lx\n", vg_obj_reldyn_get_offset(obj));
	printf(": size          = 0x%08x\n",  vg_obj_reldyn_get_size(obj));
	printf(": entnum        = 0x%08x\n",  vg_obj_reldyn_get_entnum(obj));
	printf(": entsize       = 0x%08x\n",  vg_obj_reldyn_get_entsize(obj));

	if (verbose) {
	for (idx = 0; idx < vg_obj_reldyn_get_entnum(obj); idx++) {
		if (!(r = vg_obj_reldyn_rentry_by_idx(obj, idx)))
			continue;

		printf("#%02d offset 0x%08x type %03d symidx %03d\n",
			idx,
			vg_obj_rentry_get_offset(obj,r),
			vg_obj_rentry_get_info_type(obj,r),
			vg_obj_rentry_get_info_symidx(obj,r));
	}
	}

	return (0);
}

int	print_init(vg_object *obj)
{
	if (!vg_obj_get_init(obj))
		return (-1);

	printf("\n\t[ INIT ]\n");

	printf(": vaddr		= 0x%08lx\n", vg_obj_init_get_vaddr(obj));
	printf(": offset	= 0x%08lx\n", vg_obj_init_get_offset(obj));
	
	return (0);
}

int	print_fini(vg_object *obj)
{
	if (!vg_obj_get_fini(obj))
		return (-1);

	printf("\n\t[ FINI ]\n");

	printf(": vaddr		= 0x%08lx\n", vg_obj_fini_get_vaddr(obj));
	printf(": offset	= 0x%08lx\n", vg_obj_fini_get_offset(obj));

	return (0);
}

int	print_got(vg_object *obj)
{
	vg_gotentry	gent;
	int		idx;

	if (!vg_obj_get_got(obj,0))
		return (-1);

	printf("\n\t[ GOT ]\n");

        printf(": vaddr		= 0x%08lx\n", vg_obj_got_get_vaddr(obj));
        printf(": offset	= 0x%08lx\n", vg_obj_got_get_offset(obj));
        printf(": size		= 0x%08x\n",  vg_obj_got_get_size(obj));
        printf(": entnum	= 0x%08x\n",  vg_obj_got_get_entnum(obj));
        printf(": entsize	= 0x%08x\n",  vg_obj_got_get_entsize(obj));

	if (verbose) {
	for (idx = 0; idx < vg_obj_got_get_entnum(obj); idx++) {
		if (vg_obj_gentry_by_idx(obj, idx, &gent)<0)
			continue;

		printf("#%3d [0x%08lx] => ( 0x%08lx )\n",
			idx, 
			gent.vaddr,	
			gent.value);
	}
	}

	return (0);
}

int	print_plt(vg_object *obj)
{
	if (!vg_obj_get_plt(obj,0))
		return (-1);

	printf("\n\t[ PLT ]\n");

	printf(": vaddr		= 0x%08lx\n", vg_obj_plt_get_vaddr(obj));
	printf(": offset	= 0x%08lx\n", vg_obj_plt_get_offset(obj));
	printf(": size		= 0x%08x\n",  vg_obj_plt_get_size(obj));
	printf(": entnum	= 0x%08x\n",  vg_obj_plt_get_entnum(obj));
	printf(": entsize	= 0x%08x\n",  vg_obj_plt_get_entsize(obj));

	if (verbose) { }

	return (0);
}

int	print_interp(vg_object *obj)
{
	if (!vg_obj_get_interp(obj))
		return (-1);

	printf("\n\t[ INTERP ]\n");

	printf(": vaddr		= 0x%08lx\n", vg_obj_interp_get_vaddr(obj));
	printf(": offset	= 0x%08lx\n", vg_obj_interp_get_offset(obj));
	printf(": size		= 0x%08x\n",  vg_obj_interp_get_size(obj));
	printf("[%s]\n", vg_obj_get_interp(obj));

	return (0);
}

int	print_bss(vg_object *obj)
{
	if (!vg_obj_get_bss(obj))
		return (-1);

	printf("\n\t[ BSS ]\n");

	printf(": vaddr		= 0x%08lx\n", vg_obj_bss_get_vaddr(obj));
	printf(": offset	= 0x%08lx\n", vg_obj_bss_get_offset(obj));
	printf(": size		= 0x%08x\n",  vg_obj_bss_get_size(obj));

	return (0);
}

int	print_note(vg_object *obj)
{
	if (!vg_obj_get_note(obj))
		return (-1);

	printf("\n\t[ NOTE ]\n");

	printf(": vaddr		= 0x%08lx\n", vg_obj_note_get_vaddr(obj));
	printf(": offset	= 0x%08lx\n", vg_obj_note_get_offset(obj));
	printf(": size		= 0x%08x\n",  vg_obj_note_get_size(obj));

	return (0);
}

int	print_object_info(vg_proc *p, vg_object *o)
{
	
	printf("Object [%s]\n", vg_obj_get_name(o));
	
	print_hdr(o);
	print_phdr(o);
	print_dynamic(o);
	print_dynsym(o);
	print_dynstr(o);
	print_relplt(o);
	print_reldyn(o);
	print_got(o);
	print_plt(o);
	print_init(o);
	print_fini(o);
	print_interp(o);
	print_bss(o);
	print_note(o);

	return (0);
}

int	main(int argc, char **argv)
{
	vg_proc		*p;
	vg_object	*obj;

	if (argc<2)
		help(argv[0]);

	if (argc==4 && strstr(argv[3], "-v"))	
		verbose += 1;

	GET_BASE;

	if (!(p = vg_init_pctx(atoi(argv[1]), 0))) {
		printf("error: %s\n", vg_err_msg);
		vg_fini_pctx(p);
		exit(0);
	}

	if (!(obj = vg_obj_by_name(argv[2]))) {
		printf("error: %s\n", vg_err_msg);
		vg_fini_pctx(p);
		exit(0);
	}

	print_object_info(p, obj);

	vg_fini_pctx(p);

	return (0);
}

