/*

 [=-- LIBVG --=]  DEMO SUITE  [=------------------------------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE AT YOUR OWN RISK

*/
#include <libvg.h>
#include <vg_digest.h>
#include "demo.h"

/*
 *	[ COMPUTE ALL TEXT SEGMENTS DIGEST ]
 *	(----------------------------------)---------------------------------
 *
 */

void	help(char *progname)
{
	printf("%s\n", BANNER);
	printf("%s <pid>\n\n", progname);
	exit(0);
}

int	main(int argc, char **argv)
{
	int		idx;
	vg_proc		*p;
	vg_object	*obj;
	unsigned char	digest[40+1];

	GET_BASE;

	if (argc<2)
		help(argv[0]);

	if (!(p = vg_init_pctx(atoi(argv[1]),0))) {
		printf("%s\n", vg_err_msg);
		vg_fini_pctx(p);
		exit(0);
	}

	printf("\n\t[ Object Idx | Text Start - Text End | Digest | Object Name ]\n\n");

	for (idx = 0; idx < vg_proc_get_objnum(p); idx++) {
		if ((obj = vg_obj_by_idx(idx))) {

			memset(digest, 0, 40+1);
			vg_map_object(obj);
			vg_digest_obj(SHA1, obj, VG_OBJ_TEXT_SEG, digest, 0);

			printf("#%03d  [0x%08lx-0x%08lx] [%s] [%s]\n", 
				idx,
				vg_obj_get_text_start(obj),
				vg_obj_get_text_end(obj),
				digest,
				vg_obj_get_name(obj));

			vg_unmap_object(obj);
		}
	}

	vg_fini_pctx(p);

	return (0);
}

