/*

 [=-- LIBVG --=]  DEMO SUITE  [=------------------------------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE AT YOUR OWN RISK

*/
#include <libvg.h>
#include "demo.h"

/*
 *	[ PROCESS DISASSEMBLER ]
 *	(----------------------)--------------------------------------------
 * 	
 */

#define	OPEN(a,b)	do { a = open(b, O_RDWR|O_CREAT|O_TRUNC, 0644); } while(0)
#define	CLOSE(a)	do { close(a); } while(0)

void	help(char *progname)
{
	printf("%s\n", BANNER);
	printf("%s <pid>\n\n", progname);
	exit(1);
}

char	*mstrsep(char *path, char tok)
{
	char *p = 0;
	while(*path++) {
		if (*path == tok)
			p = path+1;
	}
	return (p);
}

void	dump_symbols_vars(vg_object *obj)
{
	char *cwd;
	int fd, idx;
	vg_sym s;

	mkdir("vars", 0755);
	cwd = getcwd(0,0);
	chdir("vars");

	for (idx = 0; idx<vg_obj_dynsym_get_entnum(obj)-2; idx++) {
		if (vg_sym_var_local_by_idx(obj, &s, idx) != -1) {
			printf("  var: [%s]\n", s.syname);
			OPEN(fd, s.syname);
			vg_dump_sym(fd, 0, &s, 0);
			CLOSE(fd);
		}
	}

	chdir(cwd);
}
void	dump_symbols_funcs(vg_object *obj)
{
	char *cwd;
	int fd, idx;
	vg_sym s;

	mkdir("funcs", 0755);
	cwd = getcwd(0,0);
	chdir("funcs");

	for (idx = 0; idx<vg_obj_dynsym_get_entnum(obj)-2; idx++) {
		if (vg_sym_func_local_by_idx(obj, &s, idx) != -1) {
			printf("  func: [%s]\n", s.syname);
			OPEN(fd, s.syname);
			vg_dump_sym(fd, 0, &s, 0);
			CLOSE(fd);
		}
	}

	chdir(cwd);
}

void	dump_sections(vg_object *obj)
{
	int fd;

	OPEN(fd, "hdr");
        vg_dump_obj_hdr(obj,fd,0);
        CLOSE(fd);

        OPEN(fd, "phdr");
        vg_dump_obj_phdr(obj,fd,0);
        CLOSE(fd);

        OPEN(fd, "dynamic");
        vg_dump_obj_dyn(obj,fd,0);
        CLOSE(fd);

        OPEN(fd, "dynsym");
        vg_dump_obj_dynsym(obj,fd,0);
        CLOSE(fd);

        OPEN(fd, "dynstr");
        vg_dump_obj_dynstr(obj,fd,0);
        CLOSE(fd);

        OPEN(fd, "reldyn");
        vg_dump_obj_reldyn(obj,fd,0);
        CLOSE(fd);

        OPEN(fd, "relplt");
        vg_dump_obj_relplt(obj,fd,0);
        CLOSE(fd);

        OPEN(fd, "hash");
        vg_dump_obj_hash(obj,fd,0);
        CLOSE(fd);

        OPEN(fd, "interp");
        vg_dump_obj_interp(obj,fd,0);
        CLOSE(fd);

        OPEN(fd, "bss");
        vg_dump_obj_bss(obj,fd,0);
        CLOSE(fd);

	OPEN(fd, "note");
	vg_dump_obj_note(obj,fd,0);
	CLOSE(fd);

	OPEN(fd, "got");
	vg_dump_obj_got(obj,fd,0);
	CLOSE(fd);
}

void	dump_segments(vg_object *obj)
{
	int fd;

        OPEN(fd, "text_seg");
        vg_dump_obj_seg(obj,fd,0,VG_TEXT_SEG);
        CLOSE(fd);

        OPEN(fd, "data_seg");
        vg_dump_obj_seg(obj,fd,0,VG_DATA_SEG);
        CLOSE(fd);
}

void	dump_stack()
{
	int fd;

	OPEN(fd, "stack");
	vg_dump_stack(fd,0);
	CLOSE(fd);
}

int	disassemble_object(int idx)
{
	vg_object	*obj;
	char		*file;
	char		*cwd;

	if (!(obj = vg_obj_by_idx(idx))) {
		printf("error: %s\n", vg_err_msg);
		return (-1);
	}

	file = mstrsep(vg_obj_get_name(obj), '/');
	if (!file) file = strdup("main");

	mkdir(file, 0755);
	cwd = getcwd(0,0);
	chdir(file);
	
	printf("<%s>\n", vg_obj_get_name(obj));

	dump_segments(obj);
	dump_sections(obj);
	dump_symbols_vars(obj);
	dump_symbols_funcs(obj);

	chdir(cwd);
	return (0);
}

int	main(int argc, char **argv)
{
	vg_proc		*p;
	int		i;

	if (argc<2)
		help(argv[0]);

	GET_BASE;

	if (!(p = vg_init_pctx(atoi(argv[1]), 0))) {
		printf("error: %s\n", vg_err_msg);
		vg_fini_pctx(p);
		exit(0);
	}

	for (i = 0; i < vg_proc_get_objnum(p); i++) {
		disassemble_object(i);
	}

	dump_stack();

	vg_fini_pctx(p);

	return (0);
}


