/*

 [=-- LIBVG --=]  DEMO SUITE  [=------------------------------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE AT YOUR OWN RISK

*/
#include <libvg.h>
#include "demo.h"

/*
 *	[ PROCESS READER ]
 *	(----------------)---------------------------------------------------
 */

#define	BLOCK_SIZE	512

void	help(char *progname)
{
	printf("%s\n", BANNER);
	printf("%s <pid> <start> <end> <file|print>\n\n", progname);
	exit(1);
}

int	print(unsigned long start, int size)
{
	char	*data, *formated;
	int	read;

	if (!(data = malloc(BLOCK_SIZE))) {
		perror("malloc");
		return (-1);
	}

	if (!(formated = malloc(VGFMT_OUTPUT_SZ(BLOCK_SIZE)))) {
		printf("error: %s\n", vg_err_msg);
		return (-1);
	}

	while (size) {
		read = (size<BLOCK_SIZE? size: BLOCK_SIZE);

		memset(data, 0, BLOCK_SIZE);
		memset(formated, 0, VGFMT_OUTPUT_SZ(BLOCK_SIZE));
		
		/* here we use vg_read() */
		vg_read(data, start, read);
		vg_format_data(read, data, formated);

		printf("%s\n", formated);

		size -= read;
		start += read;
	}

	free(data);
	free(formated);
	return (0);
}

int	dump_to_disk(unsigned long start, int size, char *file)
{
	char	*data;
	int	fd, read;

	if (!(data = malloc(BLOCK_SIZE))) {
		perror("malloc");
		return (-1);
	}
	
	if ((fd = open(file, O_RDWR|O_CREAT|O_TRUNC, 0644))<0) {
		perror("open");
		return (-1);
	}
	
	while (size) {
		read = (size<BLOCK_SIZE? size: BLOCK_SIZE);
		memset(data, 0, BLOCK_SIZE);
		/* but here we use vg_dump_data :), 
		 * both, vg_read() and vg_dump_data() can be used
		 */
		vg_dump_data(start, start+read, fd, 0);
		size -= read;
		start += read;
	}

	free(data);
	return (0);
}		

int	main(int argc, char **argv)
{
	unsigned long	start, end;
	vg_proc		*p;

	GET_BASE;

	if (argc<2)
		help(argv[0]);
	
	start 	= strtoul(argv[2], 0, 16);
	end 	= strtoul(argv[3], 0, 16);

	if (!(p = vg_init_pctx(atoi(argv[1]),0))) {
		printf("error: %s\n", vg_err_msg);
		vg_fini_pctx(p);
		exit(0);
	}

	if (!strcmp(argv[4], "print"))
		print(start, end - start);
	else 
		dump_to_disk(start, end - start, argv[4]);

	vg_fini_pctx(p);
	
	return (0);
}

