/*

 [=-- LIBVG --=]  DEMO SUITE  [=------------------------------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE AT YOUR OWN RISK

*/
#include <libvg.h>
#include "demo.h"

/*
 *	[ PROCESS INFO DUMPER ]
 *	(---------------------)---------------------------------------------
 *
 */

void	help(char *progname)
{
	printf("%s", BANNER);
	printf("\n%s <pid>\n\n", progname);
	exit(0);
}

void	print_object_info(vg_object *obj)
{
	printf("\t[%04d]:\033[1;32m [%s]\033[0m\n", vg_obj_get_idx(obj), 
				                    vg_obj_get_name(obj));
	printf("\t[TEXT]: 0x%08lX-0x%08lX\n", vg_obj_get_text_start(obj), 
					      vg_obj_get_text_end(obj));
	printf("\t[DATA]: 0x%08lX-0x%08lX\n\n", vg_obj_get_data_start(obj), 
					        vg_obj_get_data_end(obj));
}	
				
void	print_objects(vg_proc *p)
{
	vg_object	*obj;
	int		idx;

	printf("\nObjects:\n");
	for (idx = 0; idx < vg_proc_get_objnum(p); idx++) {
		if (!(obj = vg_obj_by_idx(idx)))
			printf("error: %s\n", vg_err_msg);
		else
			print_object_info(obj);
	}
}

void	print_info(vg_proc *p)
{
        printf("\nPROCESS INFO:\n");
	printf("Id       	= %d\n", vg_proc_get_id(p));
	printf("Pid      	= %d\n", vg_proc_get_pid(p));
	printf("Objects  	= %d\n", vg_proc_get_objnum(p));
	printf("Exec     	= %s\n", vg_proc_get_execpath(p));

	printf("Stack Top	= 0x%08lx\n", vg_stack_get_end());
	printf("Stack Bottom	= 0x%08lx\n", vg_stack_get_start());
	printf("Stack Size	= %d\n", vg_stack_get_cur_size());

	print_objects(p);
}

int	main(int argc, char **argv)
{
	vg_proc 	*p;

	GET_BASE;

	if (argc<2)
		help(argv[0]);

	if (!(p = vg_init_pctx(atoi(argv[1]),0))) {
		printf("error: %s\n", vg_err_msg);
		vg_fini_pctx(p);
		exit(0);
	}
	
	print_info(p);

	vg_fini_pctx(p);

	return (0);
}
	
