/*

 [=-- LIBVG --=]  DEMO SUITE  [=------------------------------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE AT YOUR OWN RISK

*/
#include <libvg.h>
#include "demo.h"

/*
 *	[ PROCESS WRITER ]
 * 	(----------------)--------------------------------------------------
 *
 */

void	help(char *progname)
{
	printf("%s\n", BANNER);
	printf("%s <pid> <start> <end> <file>\n\n", progname);
	exit(0);
}

int	main(int argc, char **argv)
{
	unsigned long	start, end;
	int		fd;
	vg_proc		*p;
	
	GET_BASE;

	if (argc<2)
		help(argv[0]);
	
	start 	= strtoul(argv[2], 0, 16);
	end 	= strtoul(argv[3], 0, 16);
	
	if ((fd = open(argv[4], O_RDONLY))<0) {
		perror("open");
		exit(0);
	}

	if (!(p = vg_init_pctx(atoi(argv[1]),0))) {
		printf("error: %s\n", vg_err_msg);
		vg_fini_pctx(p);
		exit(0);
	}		

	if (vg_replace_data(start, end, fd, 0)<0) {
		printf("error: %s\n", vg_err_msg);
		vg_fini_pctx(p);
		exit(0);
	}

	close(fd);

	/* save changes */
	vg_save_pctx(p);

	vg_fini_pctx(p);

	return (0);
}

