/*

 [=-- LIBVG --=]  DEMO SUITE  [=------------------------------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE AT YOUR OWN RISK

*/
#include <libvg.h>
#include "demo.h"

/*
 *	[ SIMPLE SYMBOL RESOLVER ]
 *	(------------------------)------------------------------------------
 *
 */

void	help(char *progname)
{
	printf("%s\n", BANNER);
	printf("%s <pid> <func|var> <name>\n\n", progname);
	exit(1);
}

void	print_sym(vg_sym *s)
{
	printf("soname      = %s\n",      vg_symbol_get_soname(s));
	printf("name        = %s\n",      vg_symbol_get_name(s));
	printf("vaddr       = 0x%08lx\n", vg_symbol_get_vaddr(s));
	printf("offset      = 0x%08lx\n", vg_symbol_get_offset(s));
	printf("size        = %d\n",      vg_symbol_get_size(s));
	printf("dynstr_idx  = %d\n",      vg_symbol_get_stridx(s));
	printf("dynsym_idx  = %d\n\n",    vg_symbol_get_symtabidx(s));
}

int	resolve_function(char *name)
{
	vg_sym		func;

	if (vg_sym_func_local_by_name(0, &func, name)<0) {
		printf("\nFuncion %s not found\n", name);
		return (-1);
	}

	printf("\nFunction %s found:\n\n", name);
	print_sym(&func);

	return (0);
}

int	resolve_variable(char *name)
{
	vg_sym		var;

	if (vg_sym_var_local_by_name(0, &var, name)<0) {
		printf("\nVariable %s not found\n", name); 
		return (-1);
	}

	printf("\nVariable %s found:\n\n", name);
	print_sym(&var);

	return (0);
}

int	main(int argc, char **argv)
{
	vg_proc		*p;

	GET_BASE;

	if (argc<2)
		help(argv[0]);

	if (!(p = vg_init_pctx(atoi(argv[1]),0))) {
		printf("error: %s\n", vg_err_msg);
		vg_fini_pctx(p);
		exit(0);
	}

	if (!strcmp(argv[2], "func")) 
		resolve_function(argv[3]);

	if (!strcmp(argv[2], "var"))
		resolve_variable(argv[3]);

	vg_fini_pctx(p);
	
	return (0);
}

