/*

 [=-- LIBVG --=] Runtime Process Manipulation Library [=------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE AT YOUR OWN RISK

*/
#include "libvg.h"

/*
 * vg_obj_get_bss = load bss section 
 */
vg_char	*vg_obj_get_bss(vg_object *obj)
{
	Elf32_Phdr	*phdr;

	if (!obj) 
		VGERR(VG_OBJ_GET_BSS, NULL, E_INVAL, NULL);

	if (obj->elf.bss.data)
		goto end;

	if (!vg_obj_get_phdr(obj, 0))
		return (NULL);

	if (!(phdr = vg_obj_phentry_by_type(obj, PT_LOAD, 2))) 
		VGERR(VG_OBJ_GET_BSS, 0, 0, NULL);
	
	if (phdr->p_filesz == phdr->p_memsz)
		VGERR(VG_OBJ_GET_BSS, "BSS section not found", 0, NULL);

	obj->elf.bss.vaddr = ROUND_UP(phdr->p_vaddr+phdr->p_filesz, 32);
	obj->elf.bss.size = phdr->p_memsz-phdr->p_filesz;
	obj->elf.bss.offset = phdr->p_offset;

	SET_OBJECT_VADDR(obj->elf.bss.vaddr, obj);

	if (OBJ_IS_MAPPED(obj)) {
		obj->elf.bss.data = (char*)RTOL(obj->elf.bss.vaddr, obj);
	}
	else {
		S_ALLOC(obj->elf.bss.data, obj->elf.bss.size, NULL, VG_OBJ_GET_BSS, CLEAN);
		if (vg_dread(obj->elf.bss.data, obj->elf.bss.vaddr, 
					obj->elf.bss.size) != obj->elf.bss.size)
			VGERR2(VG_OBJ_GET_BSS, 0, 0, NULL, obj->elf.bss.data);
	}
end:
	return (obj->elf.bss.data);
}

/*
 * vg_obj_bss_get_vaddr = get/set the starting addres of the bss
 * section
 */
vg_vaddr vg_obj_bss_get_vaddr(vg_object *obj)
{
	if (!obj || !obj->elf.bss.data)
		VGERR(VG_OBJ_BSS_GET_VADDR, NULL, E_INVAL, ERR);
	return (obj->elf.bss.vaddr);	
}

vg_vaddr vg_obj_bss_set_vaddr(vg_object *obj, vg_vaddr vaddr)
{
	if (!obj || !obj->elf.bss.data)
		VGERR(VG_OBJ_BSS_SET_VADDR, NULL, E_INVAL, ERR);
	obj->elf.bss.vaddr = vaddr;
	return (obj->elf.bss.vaddr);
}

/*
 * vg_obj_bss_get_size = get/set the bss section size
 */
vg_size	vg_obj_bss_get_size(vg_object *obj)
{
	if (!obj || !obj->elf.bss.data)
		VGERR(VG_OBJ_BSS_GET_SIZE, NULL, E_INVAL, ERR);
	return (obj->elf.bss.size);
}		

vg_size	vg_obj_bss_set_size(vg_object *obj, vg_size size)
{
	if (!obj || !obj->elf.bss.data)
		VGERR(VG_OBJ_BSS_SET_SIZE, NULL, E_INVAL, ERR);
	obj->elf.bss.size = size;
	return (obj->elf.bss.size);
}

/*
 * vg_obj_bss_get_offset = get/set the offset of the bss section
 * into the object
 */
vg_off	vg_obj_bss_get_offset(vg_object *obj)
{
	if (!obj || !obj->elf.bss.data)
		VGERR(VG_OBJ_BSS_GET_OFFSET, NULL, E_INVAL, ERR);
	return (obj->elf.bss.offset);
}

vg_off	vg_obj_bss_set_offset(vg_object *obj, vg_off offset)
{
	if (!obj || !obj->elf.bss.data)
		VGERR(VG_OBJ_BSS_SET_OFFSET, NULL, E_INVAL, ERR);
	obj->elf.bss.offset = offset;
	return (obj->elf.bss.offset);
}

