/*

 [=-- LIBVG --=] Runtime Process Manipulation Library [=------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE AT YOUR OWN RISK

*/
#include "include/libvg.h"

/*
 * vg_create_ehdr = 
 */
vg_int vg_create_ehdr(vg_vaddr vaddr, vg_uchar ident[16], vg_uint16 type, 
		vg_uint16 machine, vg_uint32 version, vg_vaddr entry, 
		vg_off phoff, vg_off shoff, vg_uint32 flags, vg_uint16 ehsize, 
		vg_uint16 phentsize, vg_uint16 phnum, vg_uint16 shentsize, 
		vg_uint16 shnum, vg_uint16 shstrndx)
{
	Elf32_Ehdr	ehdr;
	
	if (!vaddr)
		VGERR(VG_CREATE_EHDR, NULL, E_INVAL, ERR);
	
	memset(&ehdr, 0, sizeof(Elf32_Ehdr));
	ehdr.e_type = type;
	ehdr.e_machine = machine;
	ehdr.e_version = version;
	ehdr.e_entry = entry;
	ehdr.e_phoff = phoff;
	ehdr.e_shoff = shoff;
	ehdr.e_flags = flags;
	ehdr.e_ehsize = ehsize;
	ehdr.e_phentsize = phentsize;
	ehdr.e_phnum = phnum;
	ehdr.e_shentsize = shentsize;
	ehdr.e_shnum = shnum;
	ehdr.e_shstrndx = shstrndx;

	if (vg_write(&ehdr, vaddr, sizeof(Elf32_Ehdr))!=
			           sizeof(Elf32_Ehdr)) 
		return (ERR);

	return (OK);
}

/*
 * vg_create_phdr = CREATE A PROGRAM HEADER ENTRY
 */
vg_int	vg_create_phdr(vg_vaddr vaddr, vg_uint32 type, vg_off offset, 
		vg_vaddr vvaddr, vg_vaddr paddr, vg_uint32 filesz, 
		vg_uint32 memsz, vg_uint32 flags, vg_uint32 align)
{
	Elf32_Phdr ph_entry;

	if (!vaddr)
		VGERR(VG_CREATE_PHDR, NULL, E_INVAL, ERR);

	memset(&ph_entry, 0, sizeof(Elf32_Phdr));
	ph_entry.p_type = type;
	ph_entry.p_offset = offset;
	ph_entry.p_vaddr = vvaddr;
	ph_entry.p_paddr = paddr;
	ph_entry.p_filesz = filesz;
	ph_entry.p_memsz = memsz;
	ph_entry.p_flags = flags;
	ph_entry.p_align = align;

	if (vg_write(&ph_entry, vaddr, sizeof(Elf32_Phdr))!= 
				       sizeof(Elf32_Phdr))
		return (ERR);

	return (OK);
}

vg_int	vg_create_shentry(vg_vaddr vaddr, vg_uint name, vg_uint type,
			vg_uint flags, vg_vaddr vvaddr, vg_off offset, 
			vg_size size, vg_uint link, vg_uint info, 
			vg_uint addralign, vg_uint entsize)
{
	Elf32_Shdr sh_entry;

	if (!vaddr)
		VGERR(VG_CREATE_SHENTRY, NULL, E_INVAL, ERR);

	memset(&sh_entry, 0, sizeof(Elf32_Shdr));
	sh_entry.sh_name = name;
	sh_entry.sh_type = type;
	sh_entry.sh_flags = flags;
	sh_entry.sh_addr = vvaddr;
	sh_entry.sh_offset = offset;
	sh_entry.sh_size = size;
	sh_entry.sh_link = link;
	sh_entry.sh_info = info;
	sh_entry.sh_addralign = addralign;
	sh_entry.sh_entsize = entsize;
	
	if (vg_write(&sh_entry, vaddr, sizeof(Elf32_Shdr)) !=
				       sizeof(Elf32_Shdr))
		return (ERR);

	return (OK);
}

/*
 * vg_create_dentry = CREATE A DYNAMIC ENTRY
 */
vg_int	vg_create_dentry(vg_vaddr vaddr, vg_int tag, vg_uint32 val,
		vg_vaddr ptr)
{
	Elf32_Dyn dentry;

	if (!vaddr)
		VGERR(VG_CREATE_DENTRY, NULL, E_INVAL, ERR);

	memset(&dentry, 0, sizeof(Elf32_Dyn));
	dentry.d_tag = tag;
	dentry.d_un.d_val = val;	/* union */
	dentry.d_un.d_ptr = ptr;
	
	if (vg_write(&dentry, vaddr, sizeof(Elf32_Dyn)) !=
				     sizeof(Elf32_Dyn))
		return (ERR);

	return (OK);
}

/*
 * vg_create_sentry = CREATE A DYNAMIC SYMBOL ENTRY
 */
vg_int	vg_create_sentry(vg_vaddr vaddr, vg_uint32 name, vg_vaddr value, 
			vg_size size, vg_uchar info, vg_uchar other,
			vg_uint16 shndx)
{
	Elf32_Sym	sentry;
		
	if (!vaddr) 
		VGERR(VG_CREATE_SENTRY, NULL, E_INVAL, ERR);
	
	memset(&sentry, 0, sizeof(Elf32_Sym));
	sentry.st_name = name;
	sentry.st_value = value;
	sentry.st_size = size;
	sentry.st_info = info;
	sentry.st_other = other;
	sentry.st_shndx = shndx;

	if (vg_write(&sentry, vaddr, sizeof(Elf32_Sym)) !=
				     sizeof(Elf32_Sym)) 
		return (ERR);

	return (OK);
}

/*
 * vg_create_rentry = CREATE A RELOCATION ENTRY
 */
vg_int	vg_create_rentry(vg_vaddr vaddr, vg_off offset, vg_idx symidx, 
			vg_uchar type)
{
	Elf32_Rel	rentry;

	if (!vaddr)
		VGERR(VG_CREATE_RENTRY, NULL, E_INVAL, ERR);
	
	memset(&rentry, 0, sizeof(Elf32_Rel));
	rentry.r_offset = offset;
	rentry.r_info = ELF32_R_INFO(symidx, type);

	if (vg_write(&rentry, vaddr, sizeof(Elf32_Rel)) !=
				     sizeof(Elf32_Rel)) 
		return (ERR);

	return (OK);
}

