/*

 [=-- LIBVG --=] Runtime Process Manipulation Library [=------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE AT YOUR OWN RISK

*/
#include "libvg.h"

extern	vg_proc *cur_proc;
extern	vg_pid	cur_pid;

/* TODO TODO TODO TODO 
 *
 * this code is not finished, use carefully 
 */
		
/*
 * vg_bkpt_set_by_name = SET BREAKPOINT AT FUNCTION
 */
vg_int	vg_bkpt_set_by_name(vg_char *sname)
{
	vg_sym		sym;

	if (!sname)
		VGERR(VG_BKPT_SET_BY_NAME, "Incorrect args", 0, ERR);
	/* first get sym */
	if (!vg_sym_func_local_by_name(0, &sym, sname))
		return (ERR);
	/* then enable bkpt */
	return (vg_bkpt_set_by_vaddr(sym.vaddr));
}

/*
 * SET BREAKPOINT AT VADDR
 */
vg_int	vg_bkpt_set_by_vaddr(vg_vaddr vaddr)
{
	vg_bkpt		*bkpt;

	/* check args */
	if (!vaddr)
		VGERR(VG_BKPT_SET_BY_VADDR, "Incorrect args", 0,ERR);

	/* init bkpt linked list */
	if (cur_proc->init_bkpt == NULL) {
		if (!(cur_proc->init_bkpt = (vg_bkpt*)malloc(sizeof(vg_bkpt))))
			VGERR(VG_BKPT_SET_BY_VADDR,INTERNAL_ERR, 0,ERR);
		bkpt = cur_proc->init_bkpt;
	}
	else {
		for_each_bkpt(bkpt, cur_proc->init_bkpt);
		if (!(bkpt->next = (vg_bkpt*)malloc(sizeof(vg_bkpt)))) 
			VGERR(VG_BKPT_SET_BY_VADDR,INTERNAL_ERR, 0,ERR);
		bkpt = bkpt->next;
	}

	/* fill entry */
	memset(bkpt, 0, sizeof(vg_bkpt));		
	bkpt->vaddr = vaddr;

	/* enable */
	if (vg_bkpt_enable(bkpt)<0)
		return (ERR);
	cur_proc->flags |= PROC_BKPT;
	return (OK);
}

/*
 * vg_bkpt_enable = Enable breakpoint (this inject bkpt code at bkpt.vaddr)
 */
vg_int	vg_bkpt_enable(vg_bkpt *bkpt)
{
	char	a = BKPT_CODE;

	if (!bkpt)
		VGERR(VG_BKPT_ENABLE, "Incorrect args", 0,ERR);
	if (bkpt->stat & BKPT_ENABLE)
		VGERR(VG_BKPT_ENABLE, "Breakpoint is already enable", 0,OK);

        /* we need stop process after set any breakpoint */
        if (cur_proc->pstate.status == PS_RUNNING) {
		cur_proc->pstate.handler = DISABLED;
                kill(cur_proc->pid, SIGSTOP);
		waitpid(cur_pid, &cur_proc->pstate.wstatus, cur_proc->pstate.wopts);
		cur_proc->pstate.status = PS_STOPPED;
		cur_proc->pstate.handler = ENABLED;
	}

	/* save orig code */
	if (vg_dread(&bkpt->orig_code, bkpt->vaddr, 4) != 4)
		return (ERR);
	/* inject bkpt code at vaddr (remote mode) */
	if (vg_dwrite(&a, bkpt->vaddr, BKPT_SIZE) != BKPT_SIZE)
		return (ERR);

	bkpt->stat = BKPT_ENABLE;

	return (OK);
}

/*
 * vg_bkpt_disable = Disable breakpoint (restore original code at bkpt.vaddr)
 */
vg_int	vg_bkpt_disable(vg_bkpt *bkpt)
{
	if (!bkpt)
		VGERR(VG_BKPT_DISABLE, "Incorrect arg", 0,ERR);
	if (bkpt->stat & BKPT_DISABLE)
		VGERR(VG_BKPT_DISABLE, "Breakpoint is already disable", 0,OK);

	if (cur_proc->pstate.status & PS_RUNNING) {
                cur_proc->pstate.handler = DISABLED;
                kill(cur_proc->pid, SIGSTOP);
                waitpid(cur_pid, &cur_proc->pstate.wstatus, cur_proc->pstate.wopts);
                cur_proc->pstate.status = PS_STOPPED;
                cur_proc->pstate.handler = ENABLED;
	}

	/* restore orig code */
	if (vg_dwrite(&bkpt->orig_code, bkpt->vaddr, 4) != 4)
		return (ERR);
	bkpt->stat = BKPT_DISABLE;
	return (OK);
}

/*
 * 	[I]	This internal func check if process was stopped
 *		by a breakpoint
 */
vg_int	vg_bkpt_check(void)
{
	vg_regs		r;
	vg_bkpt		*bkpt;

/* TODO: for sun registers */
#if defined(__i386__)
	/* get regs */
	vg_gregs(cur_proc);
	/* get eip and sub bkpt size */
	r.eip -= BKPT_SIZE;
	/* check this eip vaddr */
	bkpt = vg_bkpt_find_by_vaddr(r.eip);
#elif defined(sun)

#endif
	if (!bkpt)
		return (ERR);
	 /* valid bkpt */
	if (vg_bkpt_disable(bkpt)<0)
		return (ERR);
//	vg_proc_sregs(&r);		TODO

	return (OK);
}

/*
 * vg_bkpt_del_by_idx = DEL BREAKPOINT GIVEN ITS IDX 
 */
vg_int	vg_bkpt_del_by_idx(vg_idx idx)
{
	vg_bkpt *a, *b;

	if (idx<0)
		VGERR(VG_BKPT_DEL_BY_IDX, "Incorrect args", 0,ERR);
	if (!cur_proc->init_bkpt)
		VGERR(VG_BKPT_DEL_BY_IDX, "No breakpoint list", 0,ERR);

	for (a = cur_proc->init_bkpt, b = a; a && idx > 0; 
				--idx, b = a, a = a->next);

	if (!a)
		VGERR(VG_BKPT_DEL_BY_IDX, "idx too big", 0,ERR);

	/* disable & remove */
	if (vg_bkpt_disable(a)<0)
		return (ERR);
	if (a == cur_proc->init_bkpt) 
		cur_proc->init_bkpt = a->next;
	else if (!a->next)
		b->next = 0x0;
	else
		b->next = a->next;
	free(a);

	return (OK);
}

/*	
 * DEL BREAKPOINT GIVEN ITS VADDR
 */ 
vg_int	vg_bkpt_del_by_vaddr(vg_vaddr vaddr)
{
	vg_bkpt *a, *b = 0;

	if (!vaddr)
		VGERR(VG_BKPT_DEL_BY_VADDR, "Incorrect args", 0,ERR);
	if (!cur_proc->init_bkpt)
		VGERR(VG_BKPT_DEL_BY_VADDR, "No breakpoint list", 0,ERR);

	for (a = cur_proc->init_bkpt, b = a; a && a->vaddr != vaddr;
						 b = a, a = a->next);

	if (!a)
		VGERR(VG_BKPT_DEL_BY_VADDR, "idx is too big", 0,ERR);

	if (vg_bkpt_disable(a)<0)
		return (ERR);
	if (a == cur_proc->init_bkpt)
		cur_proc->init_bkpt = a->next;
	else if (!a->next) 
		b->next = 0x0;
	else
		b->next = a->next;
	free(a);

	return (OK);
}

/*
 * Delete last breakpoint of list
 */
vg_int	vg_bkpt_del_last(void)
{
	vg_bkpt *a, *b = 0;

	if (!cur_proc->init_bkpt)
		VGERR(VG_BKPT_DEL_LAST, "No breakpoint list", 0,ERR);

	for (a = cur_proc->init_bkpt, b = a; a->next; b = a, a = a->next);

	if (vg_bkpt_disable(a)<0)
		return (ERR);
	b->next = 0x0;
	free(a);
	return (OK);
}

/*
 * vg_bkpt_clear = Clear breakpoint list
 */
vg_int	vg_bkpt_clear(void)
{
	if (!cur_proc->init_bkpt) 
		VGERR(VG_BKPT_CLEAR, "No breakpoint list", 0,ERR);
	return (OK);
}

/*
 * vg_bkpt_find_by_idx = Find breakpoint given an idx
 */
vg_bkpt	*vg_bkpt_find_by_idx(vg_idx idx)
{
	vg_bkpt	*bkpt;
	
	if (idx<0)
		VGERR(VG_BKPT_FIND_BY_IDX, "Incorrect args", 0,NULL);
	if (!cur_proc->init_bkpt)
		VGERR(VG_BKPT_FIND_BY_IDX, "No breakpoint list", 0,NULL);

	bkpt = cur_proc->init_bkpt;
	while(bkpt) {
		if (idx-- == 0) 
			return (bkpt);
		bkpt = bkpt->next;
	}
	return (NULL);
}

/*
 * vg_bkpt_find_by_vaddr = Find breakpoint given its vaddr
 */
vg_bkpt	*vg_bkpt_find_by_vaddr(vg_vaddr vaddr)
{
	vg_bkpt *bkpt;

	if (!vaddr) 
		VGERR(VG_BKPT_FIND_BY_VADDR, "Incorrect args", 0,NULL);
	if (!cur_proc->init_bkpt)
		VGERR(VG_BKPT_FIND_BY_VADDR, "No breakpoint list", 0,NULL);

	bkpt = cur_proc->init_bkpt;
	while(bkpt) {
		if (bkpt->vaddr == vaddr)
			return (bkpt);
		bkpt = bkpt->next;
	}			
	return (NULL);
}

/* 
 * 	STEPPING
 */
int	vg_step_on(void)
{
	cur_proc->pstate.step = 1;
	return (0);
}

int	vg_step_off(void)
{
	cur_proc->pstate.step = 0;
	return (0);
}

int	vg_next_step(pid_t pid)
{
	/* set stepping mode */
	if (!cur_proc->pstate.step) 
		vg_step_on();
	/* process should be stopped */
	if (cur_proc->pstate.status & PS_STOPPED) {
		vg_proc_step(cur_proc); 
		return (0);
	}	
	VGERR(0, ":stepping mode need a stopped process", 0,-1);
}


