/*

 [=-- LIBVG --=] Runtime Process Manipulation Library [=------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE AT YOUR OWN RISK

*/
#include "libvg.h"

/*
 * vg_obj_get_dynstr = 
 */
vg_char	*vg_obj_get_dynstr(vg_object *obj)
{
	Elf32_Dyn	*dynstr, *strsz;

	CHECKDYN(VG_OBJ_GET_DYNSTR, NULL);
	/* check args */
	if (!obj)
		VGERR(VG_OBJ_GET_DYNSTR, NULL, E_INVAL, NULL);

	/* check if exist */
	if (obj->elf.dynstr.data)
		goto end;

	/* get dynamic if not set */
	if (!vg_obj_get_dyn(obj, NULL))
		return (NULL);

	/* get dynstr & size */
	if (!(dynstr = vg_obj_dentry_by_type(obj, DT_STRTAB, 0)))
		VGERR(VG_OBJ_GET_DYNSTR, "Dynamic string table not found", 0, NULL);
	if (!(strsz = vg_obj_dentry_by_type(obj, DT_STRSZ, 0)))
		VGERR(VG_OBJ_GET_DYNSTR, "Dynamic string table size not found", 0, NULL);

	/* xeck if offset: dynstr is in text segment */
	SET_OBJECT_VADDR(dynstr->d_un.d_ptr, obj);

	/* xequear segmento */
	if (OBJ_IS_MAPPED(obj)) {
		obj->elf.dynstr.data = RTOL((u_long)dynstr->d_un.d_ptr, obj);
	}
	else {				/* remoto */
		S_ALLOC(obj->elf.dynstr.data, strsz->d_un.d_ptr, NULL, 
						VG_OBJ_GET_DYNSTR, CLEAN);
		if (vg_dread(obj->elf.dynstr.data, dynstr->d_un.d_ptr,
				 strsz->d_un.d_ptr) != strsz->d_un.d_ptr)
			VGERR2(VG_OBJ_GET_DYNSTR, "", 0, NULL, obj->elf.dynstr.data);
	}	
	obj->elf.dynstr.size = strsz->d_un.d_ptr;
	obj->elf.dynstr.vaddr = dynstr->d_un.d_ptr;
	obj->elf.dynstr.offset = obj->elf.dynstr.vaddr - obj->text.start;
end:
	return (obj->elf.dynstr.data);
}

/*
 * vg_obj_dynstr_get/set_vaddr = 
 */
vg_vaddr vg_obj_dynstr_get_vaddr(vg_object *obj)
{
	CHECKDYN(VG_OBJ_DYNSTR_GET_VADDR, ERR);
	if (!obj || !obj->elf.dynstr.data)
		VGERR(VG_OBJ_DYNSTR_GET_VADDR, NULL, E_INVAL, ERR);
	return (obj->elf.dynstr.vaddr);
}

vg_vaddr vg_obj_dynstr_set_vaddr(vg_object *obj, vg_vaddr vaddr)
{
	CHECKDYN(VG_OBJ_DYNSTR_SET_VADDR, ERR);
	if (!obj || !obj->elf.dynstr.data)
		VGERR(VG_OBJ_DYNSTR_SET_VADDR, NULL, E_INVAL, ERR);
	obj->elf.dynstr.vaddr = vaddr;
	return (obj->elf.dynstr.vaddr);
}

/*
 * vg_obj_dynstr_get/set_size = 
 */
vg_size	vg_obj_dynstr_get_size(vg_object *obj)
{
	CHECKDYN(VG_OBJ_DYNSTR_GET_SIZE, ERR);
	if (!obj || !obj->elf.dynstr.data)
		VGERR(VG_OBJ_DYNSTR_GET_SIZE, NULL, E_INVAL, ERR);
	return (obj->elf.dynstr.size);
}

vg_size	vg_obj_dynstr_set_size(vg_object *obj, vg_size size)
{
	CHECKDYN(VG_OBJ_DYNSTR_SET_SIZE, ERR);
	if (!obj || !obj->elf.dynstr.data)
		VGERR(VG_OBJ_DYNSTR_SET_SIZE, NULL, E_INVAL, ERR);
	obj->elf.dynstr.size = size;
	return (obj->elf.dynstr.size);
}

/*
 * vg_obj_dynstr_get/set_offset = 
 */
vg_off	vg_obj_dynstr_get_offset(vg_object *obj)
{
	CHECKDYN(VG_OBJ_DYNSTR_GET_OFFSET, ERR);
	if (!obj || !obj->elf.dynstr.data)
		VGERR(VG_OBJ_DYNSTR_GET_OFFSET, NULL, E_INVAL, ERR);
	return (obj->elf.dynstr.offset);
}

vg_off	vg_obj_dynstr_set_offset(vg_object *obj, vg_off offset)
{	
	CHECKDYN(VG_OBJ_DYNSTR_SET_OFFSET, ERR);
	if (!obj || !obj->elf.dynstr.data)
		VGERR(VG_OBJ_DYNSTR_SET_OFFSET, NULL, E_INVAL, ERR);
	obj->elf.dynstr.offset = offset;
	return (obj->elf.dynstr.offset);
}

