/*

 [=-- LIBVG --=] Runtime Process Manipulation Library [=------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE AT YOUR OWN RISK

*/
#include "libvg.h"

extern	vg_fud	*vg_fud_table[];

struct gen_errors {
	vg_ushort	id;
	vg_char		*err_msg;
} vg_gen_errors[] = {
	{E_INVAL,	"Incorrect args"},
	{0x0,		NULL}
};

vg_int	set_error_msg(vg_ushort idf, vg_char *msg, vg_flags flags)
{	
	vg_fud	*grp, *ent;
	
	/* decodificar id para pillar nombre correcto */
	grp = vg_fud_table[GET_FUD_GROUP(idf)];
	ent = (grp+GET_FUD_ENTRY(idf));

	if (!(flags & KEEP_LAST)) {
		memset(vg_err_msg, 0, 256);

		strncat(vg_err_msg, "[", 
				sizeof(vg_err_msg)-strlen(vg_err_msg)+1);
		strncat(vg_err_msg+strlen(vg_err_msg), ent->name, 
				sizeof(vg_err_msg)-strlen(vg_err_msg));
		strncat(vg_err_msg+strlen(vg_err_msg), "]: ",  
				sizeof(vg_err_msg)-strlen(vg_err_msg)+3);

		/* usar mensaje error generico */
		if (!msg && flags > 0xff)
			strncat(vg_err_msg+strlen(vg_err_msg), 
					vg_gen_errors[flags&0x00ff].err_msg,
					sizeof(vg_err_msg)-strlen(vg_err_msg));
		else
			strncat(vg_err_msg+strlen(vg_err_msg), msg, 
				sizeof(vg_err_msg)-strlen(vg_err_msg));

		vg_err_msg[sizeof(vg_err_msg)-1] = '\0';
	}

	return (OK);
}

