/*

 [=-- LIBVG --=] Runtime Process Manipulation Library [=------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE AT YOUR OWN RISK

*/
#include "libvg.h"

vg_fud	vg_pal_functions[] =
{
{VG_READ, "VG_READ"}, 
{VG_DREAD, "VG_DREAD"},
{VG_WRITE, "VG_WRITE"},
{VG_DWRITE, "VG_DWRITE"},
{VG_PROC_STOP, "VG_PROC_STOP"},
{VG_PROC_CONT, "VG_PROC_CONT"},
{VG_PROC_STEP, "VG_PROC_STEP"},
{VG_GREGS, "VG_GREGS"},
{VG_SREGS, "VG_SREGS"}
};

vg_fud	vg_proc_functions[] = 
{
{VG_INIT_PCTX, "VG_INIT_PCTX"},
{VG_FINI_PCTX, "VG_FINI_PCTX"}, 
{VG_SAVE_PCTX, "VG_SAVE_PCTX"},
{VG_PROC_GET_ID, "VG_PROC_GET_ID"},
{VG_PROC_GET_PID, "VG_PROC_GET_PID"},
{VG_PROC_GET_OBJNUM, "VG_PROC_GET_OBJNUM"},
{VG_PROC_GET_FLAGS, "VG_PROC_GET_FLAGS"},
{VG_PROC_GET_EXECPATH, "VG_PROC_GET_EXECPATH"},
{VG_PROC_GET_NEXT, "VG_PROC_GET_NEXT"},
{VG_PROC_GET_PREV, "VG_PROC_GET_PREV"}
};

vg_fud	vg_obj_functions[] = 
{
{VG_MAP_OBJECT, "VG_MAP_OBJECT"},
{VG_UNMAP_OBJECT, "VG_UNMAP_OBJECT"},
{VG_OBJ_BY_NAME, "VG_OBJ_BY_NAME"},
{VG_OBJ_BY_BASE, "VG_OBJ_BY_BASE"},
{VG_OBJ_BY_DYN, "VG_OBJ_BY_DYN"},	
{VG_OBJ_BY_IDX, "VG_OBJ_BY_IDX"},	
{VG_OBJ_BY_VADDR, "VG_OBJ_BY_VADDR"},	
{VG_OBJ_GET_TEXT_START, "VG_OBJ_GET_TEXT_START"},
{VG_OBJ_SET_TEXT_START, "VG_OBJ_SET_TEXT_START"},
{VG_OBJ_GET_TEXT_END, "VG_OBJ_GET_TEXT_END"},
{VG_OBJ_SET_TEXT_END, "VG_OBJ_SET_TEXT_END"},	
{VG_OBJ_GET_TEXT_SIZE, "VG_OBJ_GET_TEXT_SIZE"},	
{VG_OBJ_SET_TEXT_SIZE, "VG_OBJ_SET_TEXT_SIZE"},	
{VG_OBJ_GET_DATA_START, "VG_OBJ_GET_DATA_START"},
{VG_OBJ_SET_DATA_START, "VG_OBJ_SET_DATA_START"},
{VG_OBJ_GET_DATA_END, "VG_OBJ_GET_DATA_END"},	
{VG_OBJ_SET_DATA_END, "VG_OBJ_SET_DATA_END"},	
{VG_OBJ_GET_DATA_SIZE, "VG_OBJ_GET_DATA_SIZE"},	
{VG_OBJ_SET_DATA_SIZE, "VG_OBJ_SET_DATA_SIZE"},	
{VG_OBJ_GET_HEAP_START, "VG_OBJ_GET_HEAP_START"},
{VG_OBJ_SET_HEAP_START, "VG_OBJ_SET_HEAP_START"},
{VG_OBJ_GET_HEAP_END, "VG_OBJ_GET_HEAP_END"},
{VG_OBJ_SET_HEAP_END, "VG_OBJ_SET_HEAP_END"},	
{VG_OBJ_GET_HEAP_SIZE, "VG_OBJ_GET_HEAP_SIZE"},
{VG_OBJ_SET_HEAP_SIZE, "VG_OBJ_SET_HEAP_SIZE"},	
{VG_OBJ_GET_NAME, "VG_OBJ_GET_NAME"},
{VG_OBJ_SET_NAME, "VG_OBJ_SET_NAME"},
{VG_OBJ_GET_IDX, "VG_OBJ_GET_IDX"}
};

vg_fud	vg_dump_functions[] = 
{
{VG_DUMP_OBJ_HDR, "VG_DUMP_OBJ_HDR"},
{VG_DUMP_OBJ_PHDR, "VG_DUMP_OBJ_PHDR"},
{VG_DUMP_OBJ_DYN, "VG_DUMP_OBJ_DYN"},
{VG_DUMP_OBJ_DYNSYM,"VG_DUMP_OBJ_DYNSYM"},
{VG_DUMP_OBJ_DYNSTR, "VG_DUMP_OBJ_DYNSTR"},
{VG_DUMP_OBJ_RELDYN, "VG_DUMP_OBJ_RELDYN"},
{VG_DUMP_OBJ_RELPLT, "VG_DUMP_OBJ_RELPLT"},
{VG_DUMP_OBJ_HASH, "VG_DUMP_OBJ_HASH"},
{VG_DUMP_OBJ_PLT, "VG_DUMP_OBJ_PLT"},
{VG_DUMP_OBJ_SEG, "VG_DUMP_OBJ_SEG"},
{VG_DUMP_OBJ, "VG_DUMP_OBJ"},	
{VG_DUMP_STACK, "VG_DUMP_STACK"},
{VG_DUMP_DATA, "VG_DUMP_DATA"},	
{VG_DUMP_SYM, "VG_DUMP_SYM"},	
{VG_DUMP_OBJ_GOT, "VG_DUMP_OBJ_GOT"},
{VG_DUMP_OBJ_INTERP, "VG_DUMP_OBJ_INTERP"},
{VG_DUMP_OBJ_BSS, "VG_DUMP_OBJ_BSS"},
{VG_DUMP_OBJ_NOTE, "VG_DUMP_OBJ_NOTE"}
};

vg_fud	vg_replace_functions[] = 
{			
{VG_REPLACE_OBJ_HDR, "VG_REPLACE_OBJ_HDR"},
{VG_REPLACE_OBJ_PHDR, "VG_REPLACE_OBJ_PHDR"},
{VG_REPLACE_OBJ_DYN, "VG_REPLACE_OBJ_DYN"},	
{VG_REPLACE_OBJ_DYNSYM, "VG_REPLACE_OBJ_DYNSYM"},
{VG_REPLACE_OBJ_DYNSTR, "VG_REPLACE_OBJ_DYNSTR"},
{VG_REPLACE_OBJ_RELDYN, "VG_REPLACE_OBJ_RELDYN"},
{VG_REPLACE_OBJ_RELPLT, "VG_REPLACE_OBJ_RELPLT"},
{VG_REPLACE_OBJ_HASH, "VG_REPLACE_OBJ_HASH"},
{VG_REPLACE_OBJ_PLT, "VG_REPLACE_OBJ_PLT"},
{VG_REPLACE_OBJ_GOT, "VG_REPLACE_OBJ_GOT"},
{VG_REPLACE_OBJ_SEG, "VG_REPLACE_OBJ_SEG"},	
{VG_REPLACE_STACK, "VG_REPLACE_STACK"},	
{VG_REPLACE_OBJ, "VG_REPLACE_OBJ"},
{VG_REPLACE_DATA, "VG_REPLACE_DATA"},	
{VG_REPLACE_SYM, "VG_REPLACE_SYM"},
{VG_REPLACE_OBJ_INTERP,	"VG_REPLACE_OBJ_INTERP"},
{VG_REPLACE_OBJ_BSS, "VG_REPLACE_OBJ_BSS"},
{VG_REPLACE_OBJ_NOTE,"VG_REPLACE_OBJ_NOTE"}
};

vg_fud	vg_hdr_functions[] = 
{
{VG_OBJ_GET_HDR, "VG_OBJ_GET_HDR"},
{VG_OBJ_HDR_GET_VADDR, "VG_OBJ_HDR_GET_VADDR"},	
{VG_OBJ_HDR_SET_VADDR, "VG_OBJ_HDR_SET_VADDR"},	
{VG_OBJ_HDR_GET_SIZE, "VG_OBJ_HDR_GET_SIZE"},	
{VG_OBJ_HDR_SET_SIZE, "VG_OBJ_HDR_SET_SIZE"},
{VG_OBJ_HDR_GET_OFFSET, "VG_OBJ_HDR_GET_OFFSET"},
{VG_OBJ_HDR_SET_OFFSET, "VG_OBJ_HDR_SET_OFFSET"},
{VG_OBJ_HDR_GET_TYPE, "VG_OBJ_HDR_GET_TYPE"},	
{VG_OBJ_HDR_SET_TYPE, "VG_OBJ_HDR_SET_TYPE"},	
{VG_OBJ_HDR_GET_MACHINE, "VG_OBJ_HDR_GET_MACHINE"},
{VG_OBJ_HDR_SET_MACHINE, "VG_OBJ_HDR_SET_MACHINE"},
{VG_OBJ_HDR_GET_VERSION, "VG_OBJ_HDR_GET_VERSION"},
{VG_OBJ_HDR_SET_VERSION, "VG_OBJ_HDR_SET_VERSION"},
{VG_OBJ_HDR_GET_PHENTSIZE, "VG_OBJ_HDR_GET_PHENTSIZE"},
{VG_OBJ_HDR_SET_PHENTSIZE, "VG_OBJ_HDR_SET_PHENTSIZE"},
{VG_OBJ_HDR_GET_SHENTSIZE, "VG_OBJ_HDR_GET_SHENTSIZE"},
{VG_OBJ_HDR_SET_SHENTSIZE, "VG_OBJ_HDR_SET_SHENTSIZE"},
{VG_OBJ_HDR_GET_EHSIZE, "VG_OBJ_HDR_GET_EHSIZE"},
{VG_OBJ_HDR_SET_EHSIZE, "VG_OBJ_HDR_SET_EHSIZE"},
{VG_OBJ_HDR_GET_SHNUM, "VG_OBJ_HDR_GET_SHNUM"},	
{VG_OBJ_HDR_SET_SHNUM, "VG_OBJ_HDR_SET_SHNUM"},
{VG_OBJ_HDR_GET_SHOFF, "VG_OBJ_HDR_GET_SHOFF"},	
{VG_OBJ_HDR_SET_SHOFF, "VG_OBJ_HDR_SET_SHOFF"},	
{VG_OBJ_HDR_GET_PHNUM, "VG_OBJ_HDR_GET_PHNUM"},	
{VG_OBJ_HDR_SET_PHNUM, "VG_OBJ_HDR_SET_PHNUM"},	
{VG_OBJ_HDR_GET_PHOFF, "VG_OBJ_HDR_GET_PHOFF"},
{VG_OBJ_HDR_SET_PHOFF, "VG_OBJ_HDR_SET_PHOFF"},	
{VG_OBJ_HDR_GET_ENTRY, "VG_OBJ_HDR_GET_ENTRY"},	
{VG_OBJ_HDR_SET_ENTRY, "VG_OBJ_HDR_SET_ENTRY"}	
};

vg_fud	vg_phdr_functions[] = 
{	
{VG_OBJ_GET_PHDR, "VG_OBJ_GET_PHDR"},
{VG_OBJ_PHDR_GET_VADDR, "VG_OBJ_PHDR_GET_VADDR"},
{VG_OBJ_PHDR_SET_VADDR, "VG_OBJ_PHDR_SET_VADDR"},
{VG_OBJ_PHDR_GET_SIZE, "VG_OBJ_PHDR_GET_SIZE"},	
{VG_OBJ_PHDR_SET_SIZE, "VG_OBJ_PHDR_SET_SIZE"},
{VG_OBJ_PHDR_GET_OFFSET, "VG_OBJ_PHDR_GET_OFFSET"},
{VG_OBJ_PHDR_SET_OFFSET, "VG_OBJ_PHDR_SET_OFFSET"},
{VG_OBJ_PHDR_GET_ENTSIZE, "VG_OBJ_PHDR_GET_ENTSIZE"},
{VG_OBJ_PHDR_SET_ENTSIZE, "VG_OBJ_PHDR_SET_ENTSIZE"},
{VG_OBJ_PHDR_GET_ENTNUM, "VG_OBJ_PHDR_GET_ENTNUM"},
{VG_OBJ_PHDR_SET_ENTNUM, "VG_OBJ_PHDR_SET_ENTNUM"},
{VG_OBJ_PHENTRY_BY_IDX, "VG_OBJ_PHENTRY_BY_IDX"},
{VG_OBJ_PHENTRY_BY_TYPE, "VG_OBJ_PHENTRY_BY_TYPE"},
{VG_OBJ_PHENTRY_BY_OFFSET, "VG_OBJ_PHENTRY_BY_OFFSET"},
{VG_OBJ_PHENTRY_BY_VADDR, "VG_OBJ_PHENTRY_BY_VADDR"},
{VG_OBJ_PHENTRY_BY_MEMSZ, "VG_OBJ_PHENTRY_BY_MEMSZ"},
{VG_OBJ_PHENTRY_BY_FILESZ, "VG_OBJ_PHENTRY_BY_FILESZ"},
{VG_OBJ_PHENTRY_GET_TYPE, "VG_OBJ_PHENTRY_GET_TYPE"},
{VG_OBJ_PHENTRY_SET_TYPE, "VG_OBJ_PHENTRY_SET_TYPE"},
{VG_OBJ_PHENTRY_GET_OFFSET, "VG_OBJ_PHENTRY_GET_OFFSET"},
{VG_OBJ_PHENTRY_SET_OFFSET, "VG_OBJ_PHENTRY_SET_OFFSET"},
{VG_OBJ_PHENTRY_GET_VADDR, "VG_OBJ_PHENTRY_GET_VADDR"},
{VG_OBJ_PHENTRY_SET_VADDR, "VG_OBJ_PHENTRY_SET_VADDR"},
{VG_OBJ_PHENTRY_GET_PADDR, "VG_OBJ_PHENTRY_GET_PADDR"},
{VG_OBJ_PHENTRY_SET_PADDR, "VG_OBJ_PHENTRY_SET_PADDR"},
{VG_OBJ_PHENTRY_GET_FILESZ, "VG_OBJ_PHENTRY_GET_FILESZ"},
{VG_OBJ_PHENTRY_SET_FILESZ, "VG_OBJ_PHENTRY_SET_FILESZ"},
{VG_OBJ_PHENTRY_GET_MEMSZ, "VG_OBJ_PHENTRY_GET_MEMSZ"},
{VG_OBJ_PHENTRY_SET_MEMSZ, "VG_OBJ_PHENTRY_SET_MEMSZ"},
{VG_OBJ_PHENTRY_GET_FLAGS, "VG_OBJ_PHENTRY_GET_FLAGS"},
{VG_OBJ_PHENTRY_SET_FLAGS, "VG_OBJ_PHENTRY_SET_FLAGS"},
{VG_OBJ_PHENTRY_GET_ALIGN, "VG_OBJ_PHENTRY_GET_ALIGN"},
{VG_OBJ_PHENTRY_SET_ALIGN, "VG_OBJ_PHENTRY_SET_ALIGN"}
};

vg_fud	vg_init_section_functions[] = 
{
{VG_OBJ_GET_INIT, "VG_OBJ_GET_INIT"},	
{VG_OBJ_INIT_GET_VADDR, "VG_OBJ_INIT_GET_VADDR"},
{VG_OBJ_INIT_SET_VADDR, "VG_OBJ_INIT_SET_VADDR"},
{VG_OBJ_INIT_GET_OFFSET, "VG_OBJ_INIT_GET_OFFSET"},
{VG_OBJ_INIT_SET_OFFSET, "VG_OBJ_INIT_SET_OFFSET"}
};

vg_fud	vg_fini_section_functions[] = 
{	
{VG_OBJ_GET_FINI, "VG_OBJ_GET_FINI"},
{VG_OBJ_FINI_GET_VADDR, "VG_OBJ_FINI_GET_VADDR"},
{VG_OBJ_FINI_SET_VADDR, "VG_OBJ_FINI_SET_VADD"},	
{VG_OBJ_FINI_GET_OFFSET, "VG_OBJ_FINI_GET_OFFSET"},
{VG_OBJ_FINI_SET_OFFSET, "VG_OBJ_FINI_SET_OFFSET"}
};

vg_fud	vg_interp_section_functions[] = 
{
{VG_OBJ_GET_INTERP, "VG_OBJ_GET_INTERP"},
{VG_OBJ_INTERP_GET_VADDR, "VG_OBJ_INTERP_GET_VADDR"},
{VG_OBJ_INTERP_SET_VADDR, "VG_OBJ_INTERP_SET_VADDR"},
{VG_OBJ_INTERP_GET_OFFSET, "VG_OBJ_INTERP_GET_OFFSET"},
{VG_OBJ_INTERP_SET_OFFSET, "VG_OBJ_INTERP_SET_OFFSET"},
{VG_OBJ_INTERP_GET_SIZE, "VG_OBJ_INTERP_GET_SIZE"},
{VG_OBJ_INTERP_SET_SIZE, "VG_OBJ_INTERP_SET_SIZE"}
};

vg_fud	vg_note_section_functions[] =
{
{VG_OBJ_GET_NOTE, "VG_OBJ_GET_NOTE"},
{VG_OBJ_NOTE_GET_VADDR, "VG_OBJ_NOTE_GET_VADDR"},
{VG_OBJ_NOTE_SET_VADDR,	"VG_OBJ_NOTE_SET_VADDR"},
{VG_OBJ_NOTE_GET_OFFSET, "VG_OBJ_NOTE_GET_OFFSET"},
{VG_OBJ_NOTE_SET_OFFSET, "VG_OBJ_NOTE_SET_OFFSET"},
{VG_OBJ_NOTE_GET_SIZE, "VG_OBJ_NOTE_GET_SIZE"},
{VG_OBJ_NOTE_SET_SIZE, "VG_OBJ_NOTE_SET_SIZE"}
};

vg_fud	vg_dynamic_section_functions[] = 
{	
{VG_OBJ_GET_DYN, "VG_OBJ_GET_DYN"},
{VG_OBJ_DYN_GET_VADDR, "VG_OBJ_DYN_GET_VADDR"},	
{VG_OBJ_DYN_SET_VADDR, "VG_OBJ_DYN_SET_VADDR"},	
{VG_OBJ_DYN_GET_SIZE, "VG_OBJ_DYN_GET_SIZE"},
{VG_OBJ_DYN_SET_SIZE, "VG_OBJ_DYN_SET_SIZE"},	
{VG_OBJ_DYN_GET_OFFSET, "VG_OBJ_DYN_GET_OFFSET"},
{VG_OBJ_DYN_SET_OFFSET, "VG_OBJ_DYN_SET_OFFSET"},
{VG_OBJ_DYN_GET_ENTSIZE,"VG_OBJ_DYN_GET_ENTSIZE"},
{VG_OBJ_DYN_SET_ENTSIZE,"VG_OBJ_DYN_SET_ENTSIZE"},
{VG_OBJ_DYN_GET_ENTNUM, "VG_OBJ_DYN_GET_ENTNUM"},
{VG_OBJ_DYN_SET_ENTNUM, "VG_OBJ_DYN_SET_ENTNUM"},
{VG_OBJ_DENTRY_BY_TYPE,	"VG_OBJ_DENTRY_BY_TYPE"},
{VG_OBJ_DENTRY_BY_VAL, "VG_OBJ_DENTRY_BY_VAL"},	
{VG_OBJ_DENTRY_BY_IDX, "VG_OBJ_DENTRY_BY_IDX"},
{VG_OBJ_DENTRY_GET_TAG, "VG_OBJ_DENTRY_GET_TAG"},
{VG_OBJ_DENTRY_SET_TAG, "VG_OBJ_DENTRY_SET_TAG"},
{VG_OBJ_DENTRY_GET_PTR, "VG_OBJ_DENTRY_GET_PTR"},
{VG_OBJ_DENTRY_SET_PTR, "VG_OBJ_DENTRY_SET_PTR"},
{VG_OBJ_DENTRY_GET_STR, "VG_OBJ_DENTRY_GET_STR"},
{VG_OBJ_DENTRY_SET_STR,	"VG_OBJ_DENTRY_SET_STR"}
};

vg_fud	vg_dynsym_section_functions[] = 
{
{VG_OBJ_GET_DYNSYM, "VG_OBJ_GET_DYNSYM"},
{VG_OBJ_DYNSYM_GET_VADDR, "VG_OBJ_DYNSYM_GET_VADDR"},	
{VG_OBJ_DYNSYM_SET_VADDR, "VG_OBJ_DYNSYM_SET_VADDR"},
{VG_OBJ_DYNSYM_GET_SIZE, "VG_OBJ_DYNSYM_GET_SIZE"},
{VG_OBJ_DYNSYM_SET_SIZE, "VG_OBJ_DYNSYM_SET_SIZE"},
{VG_OBJ_DYNSYM_GET_OFFSET,"VG_OBJ_DYNSYM_GET_OFFSET"},
{VG_OBJ_DYNSYM_SET_OFFSET, "VG_OBJ_DYNSYM_SET_OFFSET"},
{VG_OBJ_DYNSYM_GET_ENTSIZE, "VG_OBJ_DYNSYM_GET_ENTSIZE"},
{VG_OBJ_DYNSYM_SET_ENTSIZE, "VG_OBJ_DYNSYM_SET_ENTSIZE"},
{VG_OBJ_DYNSYM_GET_ENTNUM, "VG_OBJ_DYNSYM_GET_ENTNUM"},
{VG_OBJ_DYNSYM_SET_ENTNUM, "VG_OBJ_DYNSYM_SET_ENTNUM"},
{VG_OBJ_DSYM_BY_IDX, "VG_OBJ_DSYM_BY_IDX"},
{VG_OBJ_DSYM_BY_IDXNAME, "VG_OBJ_DSYM_BY_IDXNAME"},
{VG_OBJ_DSYM_BY_NAME, "VG_OBJ_DSYM_BY_NAME"},
{VG_OBJ_DSYM_BY_VALUE, "VG_OBJ_DSYM_BY_VALUE"},	
{VG_OBJ_DSYM_GET_IDXNAME, "VG_OBJ_DSYM_GET_IDXNAME"},
{VG_OBJ_DSYM_SET_IDXNAME, "VG_OBJ_DSYM_SET_IDXNAME"},
{VG_OBJ_DSYM_GET_STRNAME, "VG_OBJ_DSYM_GET_STRNAME"},
{VG_OBJ_DSYM_SET_STRNAME, "VG_OBJ_DSYM_SET_STRNAME"},
{VG_OBJ_DSYM_GET_VALUE, "VG_OBJ_DSYM_GET_VALUE"},
{VG_OBJ_DSYM_SET_VALUE, "VG_OBJ_DSYM_SET_VALUE"},
{VG_OBJ_DSYM_GET_SIZE, "VG_OBJ_DSYM_GET_SIZE"},	
{VG_OBJ_DSYM_SET_SIZE, "VG_OBJ_DSYM_SET_SIZE"},	
{VG_OBJ_DSYM_GET_INFO, "VG_OBJ_DSYM_GET_INFO"},	
{VG_OBJ_DSYM_SET_INFO, "VG_OBJ_DSYM_SET_INFO"},
{VG_OBJ_DSYM_GET_INFO_BIND, "VG_OBJ_DSYM_GET_INFO_BIND"},
{VG_OBJ_DSYM_SET_INFO_BIND, "VG_OBJ_DSYM_SET_INFO_BIND"},
{VG_OBJ_DSYM_GET_INFO_TYPE, "VG_OBJ_DSYM_GET_INFO_TYPE"},
{VG_OBJ_DSYM_SET_INFO_TYPE, "VG_OBJ_DSYM_SET_INFO_TYPE"},
{VG_OBJ_DSYM_GET_OTHER, "VG_OBJ_DSYM_GET_OTHER"},
{VG_OBJ_DSYM_SET_OTHER, "VG_OBJ_DSYM_SET_OTHER"},
{VG_OBJ_DSYM_GET_SHNDX, "VG_OBJ_DSYM_GET_SHNDX"},
{VG_OBJ_DSYM_SET_SHNDX, "VG_OBJ_DSYM_SET_SHNDX"}
};

vg_fud	vg_dynstr_section_functions[] = 
{	
{VG_OBJ_GET_DYNSTR, "VG_OBJ_GET_DYNSTR"},	
{VG_OBJ_DYNSTR_GET_VADDR, "VG_OBJ_DYNSTR_GET_VADDR"},
{VG_OBJ_DYNSTR_SET_VADDR, "VG_OBJ_DYNSTR_SET_VADDR"},
{VG_OBJ_DYNSTR_GET_SIZE, "VG_OBJ_DYNSTR_GET_SIZE"},
{VG_OBJ_DYNSTR_SET_SIZE, "VG_OBJ_DYNSTR_SET_SIZE"},
{VG_OBJ_DYNSTR_GET_OFFSET,"VG_OBJ_DYNSTR_GET_OFFSET"},
{VG_OBJ_DYNSTR_SET_OFFSET, "VG_OBJ_DYNSTR_SET_OFFSET"}
};

vg_fud	vg_reldyn_section_functions[] = 
{
{VG_OBJ_GET_RELDYN, "VG_OBJ_GET_RELDYN"},
{VG_OBJ_RELDYN_GET_VADDR, "VG_OBJ_RELDYN_GET_VADDR"},
{VG_OBJ_RELDYN_SET_VADDR, "VG_OBJ_RELDYN_SET_VADDR"},
{VG_OBJ_RELDYN_GET_SIZE, "VG_OBJ_RELDYN_GET_SIZE"},
{VG_OBJ_RELDYN_SET_SIZE, "VG_OBJ_RELDYN_SET_SIZE"},
{VG_OBJ_RELDYN_GET_OFFSET, "VG_OBJ_RELDYN_GET_OFFSET"},	
{VG_OBJ_RELDYN_SET_OFFSET, "VG_OBJ_RELDYN_SET_OFFSET"},
{VG_OBJ_RELDYN_GET_ENTSIZE, "VG_OBJ_RELDYN_GET_ENTSIZE"},	
{VG_OBJ_RELDYN_SET_ENTSIZE, "VG_OBJ_RELDYN_SET_ENTSIZE"},	
{VG_OBJ_RELDYN_GET_ENTNUM, "VG_OBJ_RELDYN_GET_ENTNUM"},	
{VG_OBJ_RELDYN_SET_ENTNUM, "VG_OBJ_RELDYN_SET_ENTNUM"},	
{VG_OBJ_RELDYN_RENTRY_BY_IDX, "VG_OBJ_RELDYN_RENTRY_BY_IDX"},	
{VG_OBJ_RELDYN_RENTRY_BY_SYM, "VG_OBJ_RELDYN_RENTRY_BY_SYM"},
{VG_OBJ_RELDYN_RENTRY_BY_SYMIDX, "VG_OBJ_RELDYN_RENTRY_BY_SYMIDX"},
{VG_OBJ_RELDYN_RENTRY_BY_OFFSET, "VG_OBJ_RELDYN_RENTRY_BY_OFFSET"}
};

vg_fud	vg_relplt_section_functions[] = 
{	
{VG_OBJ_GET_RELPLT, "VG_OBJ_GET_RELPLT"},
{VG_OBJ_RELPLT_GET_VADDR, "VG_OBJ_RELPLT_GET_VADDR"},
{VG_OBJ_RELPLT_SET_VADDR, "VG_OBJ_RELPLT_SET_VADDR"},
{VG_OBJ_RELPLT_GET_SIZE, "VG_OBJ_RELPLT_GET_SIZE"},	
{VG_OBJ_RELPLT_SET_SIZE, "VG_OBJ_RELPLT_SET_SIZE"},
{VG_OBJ_RELPLT_GET_OFFSET, "VG_OBJ_RELPLT_GET_OFFSET"},
{VG_OBJ_RELPLT_SET_OFFSET, "VG_OBJ_RELPLT_SET_OFFSET"},
{VG_OBJ_RELPLT_GET_ENTSIZE, "VG_OBJ_RELPLT_GET_ENTSIZE"},	
{VG_OBJ_RELPLT_SET_ENTSIZE, "VG_OBJ_RELPLT_SET_ENTSIZE"},
{VG_OBJ_RELPLT_GET_ENTNUM, "VG_OBJ_RELPLT_GET_ENTNUM"},
{VG_OBJ_RELPLT_SET_ENTNUM, "VG_OBJ_RELPLT_SET_ENTNUM"},
{VG_OBJ_RELPLT_RENTRY_BY_IDX, "VG_OBJ_RELPLT_RENTRY_BY_SYMIDX"},
{VG_OBJ_RELPLT_RENTRY_BY_SYM, "VG_OBJ_RELPLT_RENTRY_BY_SYM"},
{VG_OBJ_RELPLT_RENTRY_BY_SYMIDX, "VG_OBJ_RELPLT_RENTRY_BY_SYMIDX"},
{VG_OBJ_RELPLT_RENTRY_BY_OFFSET, "VG_OBJ_RELPLT_RENTRY_BY_OFFSET"},
{VG_OBJ_RENTRY_GET_OFFSET, "VG_OBJ_RENTRY_GET_OFFSET"},
{VG_OBJ_RENTRY_SET_OFFSET, "VG_OBJ_RENTRY_SET_OFFSET"},
{VG_OBJ_RENTRY_GET_INFO, "VG_OBJ_RENTRY_GET_INFO"},
{VG_OBJ_RENTRY_SET_INFO, "VG_OBJ_RENTRY_SET_INFO"},	
{VG_OBJ_RENTRY_GET_INFO_SYMIDX, "VG_OBJ_RENTRY_GET_INFO_SYMIDX"},
{VG_OBJ_RENTRY_SET_INFO_SYMIDX, "VG_OBJ_RENTRY_SET_INFO_SYMIDX"},
{VG_OBJ_RENTRY_GET_INFO_TYPE, "VG_OBJ_RENTRY_GET_INFO_TYPE"},	
{VG_OBJ_RENTRY_SET_INFO_TYPE, "VG_OBJ_RENTRY_SET_INFO_TYPE"}
};

vg_fud	vg_hash_section_functions[] =
{
{VG_OBJ_GET_HASH, "VG_OBJ_GET_HASH"},
{VG_OBJ_HASH_GET_VADDR, "VG_OBJ_HASH_GET_VADDR"},
{VG_OBJ_HASH_SET_VADDR, "VG_OBJ_HASH_SET_VADDR"},
{VG_OBJ_HASH_GET_OFFSET, "VG_OBJ_HASH_GET_OFFSET"},
{VG_OBJ_HASH_SET_OFFSET, "VG_OBJ_HASH_SET_OFFSET"},
{VG_OBJ_HASH_GET_SIZE, "VG_OBJ_HASH_GET_SIZE"},
{VG_OBJ_HASH_SET_SIZE, "VG_OBJ_HASH_SET_SIZE"}
};

vg_fud	vg_got_section_functions[] = 
{
{VG_OBJ_GET_GOT, "VG_OBJ_GET_GOT"},
{VG_OBJ_GOT_GET_VADDR, "VG_OBJ_GOT_GET_VADDR"},	
{VG_OBJ_GOT_SET_VADDR, "VG_OBJ_GOT_SET_VADDR"},	
{VG_OBJ_GOT_GET_OFFSET, "VG_OBJ_GOT_GET_OFFSET"},
{VG_OBJ_GOT_SET_OFFSET, "VG_OBJ_GOT_SET_OFFSET"},
{VG_OBJ_GOT_GET_SIZE, "VG_OBJ_GOT_GET_SIZE"},	
{VG_OBJ_GOT_SET_SIZE, "VG_OBJ_GOT_SET_SIZE"},
{VG_OBJ_GOT_GET_ENTSIZE, "VG_OBJ_GOT_GET_ENTSIZE"},
{VG_OBJ_GOT_SET_ENTSIZE, "VG_OBJ_GOT_SET_ENTSIZE"},
{VG_OBJ_GOT_GET_ENTNUM,	"VG_OBJ_GOT_GET_ENTNUM"},
{VG_OBJ_GOT_SET_ENTNUM,	"VG_OBJ_GOT_SET_ENTNUM"},
{VG_OBJ_GENTRY_BY_IDX, "VG_OBJ_GENTRY_BY_IDX"},	
{VG_OBJ_GENTRY_BY_REL, "VG_OBJ_GENTRY_BY_REL"},	
{VG_OBJ_GENTRY_BY_SYM, "VG_OBJ_GENTRY_BY_SYM"}	
};

vg_fud	vg_plt_section_functions[] = {
{VG_OBJ_GET_PLT, "VG_OBJ_GET_PLT"},		
{VG_OBJ_PLT_GET_VADDR, "VG_OBJ_PLT_GET_VADDR"},		
{VG_OBJ_PLT_SET_VADDR, "VG_OBJ_PLT_SET_VADDR"},		
{VG_OBJ_PLT_GET_OFFSET, "VG_OBJ_PLT_GET_OFFSET"},
{VG_OBJ_PLT_SET_OFFSET, "VG_OBJ_PLT_SET_OFFSET"},	
{VG_OBJ_PLT_GET_SIZE, "VG_OBJ_PLT_GET_SIZE"},		
{VG_OBJ_PLT_SET_SIZE, "VG_OBJ_PLT_SET_SIZE"},	
{VG_OBJ_PLT_GET_ENTSIZE, "VG_OBJ_PLT_GET_ENTSIZE"},	
{VG_OBJ_PLT_SET_ENTSIZE, "VG_OBJ_PLT_SET_ENTSIZE"},	
{VG_OBJ_PLT_GET_ENTNUM,	"VG_OBJ_PLT_GET_ENTNUM"},
{VG_OBJ_PLT_SET_ENTNUM, "VG_OBJ_PLT_SET_ENTNUM"},
{VG_OBJ_PLTENTRY_BY_IDX, "VG_OBJ_PLTENTRY_BY_IDX"},
{VG_OBJ_PLTENTRY_BY_SYM, "VG_OBJ_PLTENTRY_BY_SYM"},	
{VG_OBJ_PLTENTRY_GET_TYPE, "VG_OBJ_PLTENTRY_GET_TYPE"},
{VG_OBJ_PLTENTRY_GET_IDX, "VG_OBJ_PLTENTRY_GET_IDX"},	
{VG_OBJ_PLTENTRY_GET_VADDR, "VG_OBJ_PLTENTRY_GET_VADDR"},	
{VG_OBJ_PLTENTRY_GET_OFFSET, "VG_OBJ_PLTENTRY_GET_OFFSET"},
{VG_OBJ_PLTENTRY_GET_CODE, "VG_OBJ_PLTENTRY_GET_CODE"},
{VG_OBJ_PLTENTRY_GET_GOTVADDR, "VG_OBJ_PLTENTRY_GET_GOTVADDR"},	
{VG_OBJ_PLTENTRY_SET_GOTVADDR, "VG_OBJ_PLTENTRY_SET_GOTVADDR"},	
{VG_OBJ_PLTENTRY_GET_GOTIDX, "VG_OBJ_PLTENTRY_GET_GOTIDX"},	
{VG_OBJ_PLTENTRY_SET_GOTIDX, "VG_OBJ_PLTENTRY_SET_GOTIDX"}
};	

vg_fud	vg_bss_section_functions[] = {
{VG_OBJ_GET_BSS, "VG_OBJ_GET_BSS"},
{VG_OBJ_BSS_GET_VADDR, "VG_OBJ_BSS_GET_VADDR"},	
{VG_OBJ_BSS_SET_VADDR, "VG_OBJ_BSS_SET_VADDR"},	
{VG_OBJ_BSS_GET_SIZE, "VG_OBJ_BSS_GET_SIZE"},	
{VG_OBJ_BSS_SET_SIZE, "VG_OBJ_BSS_SET_SIZE"},	
{VG_OBJ_BSS_GET_OFFSET, "VG_OBJ_BSS_GET_OFFSET"},
{VG_OBJ_BSS_SET_OFFSET,	"VG_OBJ_BSS_SET_OFFSET"}
};

vg_fud	vg_digest_functions[] = 
{
{VG_DIGEST_DATA, "VG_DIGEST_DATA"},
{VG_DIGEST_OBJ, "VG_DIGEST_OBJ"}
};

vg_fud	vg_format_functions[] = 
{
{VG_FORMAT_DATA, "VG_FORMAT_DATA"}
};

vg_fud	vg_symbol_functions[] =
{
{VG_SYM_FUNC_LOCAL_BY_IDX, "VG_SYM_FUNC_LOCAL_BY_IDX"},
{VG_SYM_FUNC_LOCAL_BY_NAME, "VG_SYM_FUNC_LOCAL_BY_NAME"},
{VG_SYM_FUNC_LOCAL_BY_VADDR, "VG_SYM_FUNC_LOCAL_BY_VADDR,"},
{VG_SYM_FUNC_GLOBAL_BY_IDX, "VG_SYM_FUNC_GLOBAL_BY_IDX"},
{VG_SYM_FUNC_GLOBAL_BY_NAME, "VG_SYM_FUNC_GLOBAL_BY_NAME"},
{VG_SYM_FUNC_GLOBAL_BY_VADDR, "VG_SYM_FUNC_GLOBAL_BY_VADDR"},
{VG_SYM_VAR_LOCAL_BY_IDX, "VG_SYM_VAR_LOCAL_BY_IDX,"},
{VG_SYM_VAR_LOCAL_BY_NAME, "VG_SYM_VAR_LOCAL_BY_NAME"},
{VG_SYM_VAR_LOCAL_BY_VADDR, "VG_SYM_VAR_LOCAL_BY_VADDR"},
{VG_SYM_VAR_GLOBAL_BY_IDX, "VG_SYM_VAR_GLOBAL_BY_IDX"},
{VG_SYM_VAR_GLOBAL_BY_NAME, "VG_SYM_VAR_GLOBAL_BY_NAME"},
{VG_SYM_VAR_GLOBAL_BY_VADDR, "VG_SYM_VAR_GLOBAL_BY_VADDR"},
{VG_SYM_SECTION_BY_NAME, "VG_SYM_SECTION_BY_NAME"},
{VG_SYM_FILE_BY_NAME, "VG_SYM_FILE_BY_NAME"},
{VG_SYM_GET_NAME, "VG_SYM_GET_NAME"},
{VG_SYM_GET_SONAME, "VG_SYM_GET_SONAME"},
{VG_SYM_GET_VADDR, "VG_SYM_GET_VADDR"},
{VG_SYM_GET_SIZE, "VG_SYM_GET_SIZE"},
{VG_SYM_GET_OFFSET, "VG_SYM_GET_OFFSET"},
{VG_SYM_GET_STRIDX, "VG_SYM_GET_STRIDX"},
{VG_SYM_GET_SYMTABIDX, "VG_SYM_GET_SYMTABIDX"},
{VG_SYM_GET_INFO, "VG_SYM_GET_INFO"}
};

vg_fud	vg_redirect_functions[] = 
{
{VG_SET_HOOK, "VG_SET_HOOK"},
{VG_REDIR_S2S_BY_HOOK, "VG_REDIR_S2S_BY_HOOK"},
{VG_REDIR_S2V_BY_HOOK, "VG_REDIR_S2V_BY_HOOK"},
{VG_REDIR_S2S_BY_RELPLT, "VG_REDIR_S2V_BY_RELPLT"},
{VG_REDIR_S2V_BY_RELPLT, "VG_REDIR_S2V_BY_RELPLT"}
};

vg_fud	vg_inject_functions[] = 
{
{VG_INJECT, "VG_INJECT"}
};

vg_fud	vg_create_functions[] =
{
{VG_CREATE_EHDR, "VG_CREATE_EHDR"},
{VG_CREATE_PHDR, "VG_CREATE_PHDR"},
{VG_CREATE_SHENTRY, "VG_CREATE_SHENTRY"},
{VG_CREATE_DENTRY, "VG_CREATE_DENTRY"},
{VG_CREATE_SENTRY, "VG_CREATE_SENTRY"},
{VG_CREATE_RENTRY, "VG_CREATE_RENTRY"}
};

vg_fud	vg_debug_functions[] =
{
{VG_BKPT_SET_BY_NAME, "VG_BKPT_SET_BY_NAME"},
{VG_BKPT_SET_BY_VADDR, "VG_BKPT_SET_BY_VADDR"},	
{VG_BKPT_ENABLE, "VG_BKPT_ENABLE"},
{VG_BKPT_DISABLE, "VG_BKPT_DISABLE"},
{VG_BKPT_CHECK, "VG_BKPT_CHECK"}, 
{VG_BKPT_DEL_BY_IDX, "VG_BKPT_DEL_BY_IDX"},
{VG_BKPT_DEL_BY_VADDR, "VG_BKPT_DEL_BY_VADDR"},	
{VG_BKPT_DEL_LAST, "VG_BKPT_DEL_LAST"},	
{VG_BKPT_CLEAR, "VG_BKPT_CLEAR"}, 
{VG_BKPT_FIND_BY_IDX, "VG_BKPT_FIND_BY_IDX"},
{VG_BKPT_FIND_BY_VADDR, "VG_BKPT_FIND_BY_VADDR"}
};

vg_fud	vg_stack_functions[] = 
{
{VG_GET_STACK, "VG_GET_STACK"},
{VG_STACK_PUSH, "VG_STACK_PUSH"},
{VG_STACK_POP, "VG_STACK_POP"}
};

vg_fud	vg_internal_functions[] = 
{
{__PROC_ATTACH, "__PROC_ATTACH"},
{__PROC_DETACH, "__PROC_DETACH"},
{__LOAD_ODT, "__LOAD_ODT"},
{__UNLOAD_ODT, "__UNLOAD_ODT"},	
{__LOAD_OT, "__LOAD_OT"},
{__UNLOAD_OT, "__UNLOAD_OT"}
};

vg_fud	*vg_fud_table[] = 
{
	vg_pal_functions,
	vg_proc_functions,
	vg_obj_functions,
	vg_dump_functions,
	vg_replace_functions,
	vg_hdr_functions,
	vg_phdr_functions,
	vg_init_section_functions,
	vg_fini_section_functions,
	vg_interp_section_functions,
	vg_dynamic_section_functions,
	vg_dynsym_section_functions,
	vg_dynstr_section_functions,
	vg_reldyn_section_functions,
	vg_relplt_section_functions,
	vg_hash_section_functions,
	vg_got_section_functions,
	vg_plt_section_functions,
	vg_bss_section_functions,
	vg_digest_functions,
	vg_format_functions,
	vg_redirect_functions,
	vg_inject_functions,
	vg_create_functions,
	vg_debug_functions,
	vg_stack_functions,
	vg_internal_functions,
	vg_note_section_functions,
	vg_symbol_functions
};

