/*

 [=-- LIBVG --=] Runtime Process Manipulation Library [=------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE AT YOUR OWN RISK

*/
#include "libvg.h"

/*
 * vg_obj_get_fini = load fini section
 */
vg_vaddr *vg_obj_get_fini(vg_object *obj)
{
	Elf32_Dyn	*fini;

	if (!obj) 
		VGERR(VG_OBJ_GET_FINI, NULL, E_INVAL, NULL);

	if (obj->elf.fini.vaddr)
		goto end;

	if (!vg_obj_get_dyn(obj, 0))
		return (NULL);

	if (!(fini = vg_obj_dentry_by_type(obj, DT_FINI, 0)))
		VGERR(VG_OBJ_GET_FINI, "FINI section not found", 0, NULL);

	SET_OBJECT_VADDR(fini->d_un.d_ptr, obj);

	obj->elf.fini.vaddr = fini->d_un.d_ptr;
	obj->elf.fini.offset = obj->elf.fini.vaddr - obj->text.start;
end:
	return ((vg_vaddr*)obj->elf.fini.vaddr);
}

/*
 * vg_obj_fini_get/set_vaddr = get the starting address of the
 * fini section
 */
vg_vaddr vg_obj_fini_get_vaddr(vg_object *obj)
{
	if (!obj)
		VGERR(VG_OBJ_FINI_GET_VADDR, NULL, E_INVAL, ERR);
	return (obj->elf.fini.vaddr);
}

vg_vaddr vg_obj_fini_set_vaddr(vg_object *obj, vg_vaddr vaddr)
{
	if (!obj)
		VGERR(VG_OBJ_FINI_SET_VADDR, NULL, E_INVAL, ERR);
	obj->elf.fini.vaddr = vaddr;
	return (obj->elf.fini.vaddr);
}

/*
 * vg_obj_fini_get/set_offset = get/set the offset of the fini section
 * into the object
 */
vg_off	vg_obj_fini_get_offset(vg_object *obj)
{
	if (!obj)
		VGERR(VG_OBJ_FINI_GET_OFFSET, NULL, E_INVAL, ERR);
	return (obj->elf.fini.offset);
}

vg_off	vg_obj_fini_set_offset(vg_object *obj, vg_off offset)
{
	if (!obj)
		VGERR(VG_OBJ_FINI_SET_OFFSET, NULL, E_INVAL, ERR);
	obj->elf.fini.offset = offset;
	return (obj->elf.fini.offset);
}

