/*

 [=-- LIBVG --=] Runtime Process Manipulation Library [=------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE AT YOUR OWN RISK

*/
#include "libvg.h"

/* PASAR DATOS A HEXA+ASCII */

/*
 * vg_format_data = 
 */
vg_int	vg_format_data(vg_size size, vg_uchar *data, vg_uchar *fdata)
{
	u_char hex[4], ch[2];
	vg_int a = 1, b;

	if (size<=0 || !data || !fdata)
		VGERR(VG_FORMAT_DATA, NULL, E_INVAL, ERR);
        while(a <= size) {
		memset(hex,0,4);
		snprintf(hex, 4, "%02X ", data[a-1]);
		if (fdata)
			strncat(fdata,hex,3);
		if ((a % HEX_ROW_SZ) == 0) {
			b = (a - HEX_ROW_SZ);
			while(b++ < a) {
				snprintf(ch,2,"%c",ASCII(data[b]));
				if (fdata)
					strncat(fdata,ch,1);
                        }
			if (fdata)
				strncat(fdata,"\n",1);
                }
                ++a;
        }
	if ( (a=(size % HEX_ROW_SZ)) != 0) {
		b = a;
		while (a++ < HEX_ROW_SZ)
			if (fdata)
				strncat(fdata, "   ", 3);
		a = 0;
		while(a++ < b) {
                        snprintf(ch, 2, "%c", ASCII(data[(size - b) + a]));
			if (fdata)
				strncat(fdata,ch,1);
		}
        }
	return (OK);
}

