/*

 [=-- LIBVG --=] Runtime Process Manipulation Library [=------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE AT YOUR OWN RISK

*/
#include "libvg.h"

/*
 * vg_obj_get_hdr = load elf header
 *
 * @obj: a valid object structure 
 * ret: pointer to the elf header
 *
 */
Elf32_Ehdr 	*vg_obj_get_hdr(vg_object *obj)
{
	if (!obj)
		VGERR(VG_OBJ_GET_HDR, NULL, E_INVAL, NULL);

	if (obj->elf.hdr.data)
		goto end;

	if (OBJ_IS_MAPPED(obj)) {
		obj->elf.hdr.data = (Elf32_Ehdr*)obj->text.ptr;
	} 
	else {
		S_ALLOC(obj->elf.hdr.data, sizeof(Elf32_Ehdr), NULL, 
						VG_OBJ_GET_HDR, CLEAN);
		if (vg_dread(obj->elf.hdr.data, obj->text.start, 
					sizeof(Elf32_Ehdr)) != sizeof(Elf32_Ehdr))
			VGERR2(VG_OBJ_GET_HDR, 0, 0, NULL, obj->elf.hdr.data);
	}
	obj->elf.hdr.offset = 0x0;
	obj->elf.hdr.vaddr = obj->text.start;
	obj->elf.hdr.size = sizeof(Elf32_Ehdr);
end:
	return (obj->elf.hdr.data);
}

/*
 * vg_obj_hdr_get_vaddr = return the vaddr where the elf header
 * in located on memory 
 *
 * @obj: a valid object structure
 * #ret: the ehdr vaddr
 *
 * vg_obj_hdr_set_vaddr = change the elf header vaddr 
 * 
 * @obj: a valid object structure
 * @vaddr: the new vaddr
 * #ret: the ehdr vaddr, already changed
 *
 */
vg_vaddr vg_obj_hdr_get_vaddr(vg_object *obj)
{
	if (!obj || !obj->elf.hdr.data)
		VGERR(VG_OBJ_HDR_GET_VADDR, NULL, E_INVAL, ERR);
	return (obj->elf.hdr.vaddr);
}

vg_vaddr vg_obj_hdr_set_vaddr(vg_object *obj, vg_vaddr vaddr)
{
	if (!obj || !obj->elf.hdr.data)
		VGERR(VG_OBJ_HDR_SET_VADDR, NULL, E_INVAL, ERR);
	obj->elf.hdr.vaddr = vaddr;
	return (obj->elf.hdr.vaddr);
}

/*
 * vg_obj_hdr_get_size = return the elf header size
 * 
 * @obj: a valid object structure
 * #ret: the ehdr size
 *
 * vg_obj_hdr_set_size: change the current elf header size
 *
 * @obj: a valid object structure
 * @size: the new size
 * #ret: the new ehdr size
 *
 */
vg_size	vg_obj_hdr_get_size(vg_object *obj)
{
	if (!obj || !obj->elf.hdr.data)
		VGERR(VG_OBJ_HDR_GET_SIZE, NULL, E_INVAL, ERR);
	return (obj->elf.hdr.size);
}

vg_size	vg_obj_hdr_set_size(vg_object *obj, vg_size size)
{
	if (!obj || !obj->elf.hdr.data)
		VGERR(VG_OBJ_HDR_SET_SIZE, NULL, E_INVAL, ERR);
	obj->elf.hdr.size = size;
	return (obj->elf.hdr.size);
}

/*
 * vg_obj_hdr_get_offset = return the correct offset of the elf header
 * in text segment
 *
 * @obj: a valid object structure
 * #ret: the ehdr offset
 *
 * vg_obj_hdr_set_offset = change the current elf header offset to 
 * a new one
 *
 * @obj: a valid object structure
 * @offset: new offset
 * #ret: the new ehdr offset
 * 
 */
vg_off	vg_obj_hdr_get_offset(vg_object *obj)
{
	if (!obj || !obj->elf.hdr.data)
		VGERR(VG_OBJ_HDR_GET_OFFSET, NULL, E_INVAL, ERR);
	return (obj->elf.hdr.offset);
}

vg_off	vg_obj_hdr_set_offset(vg_object *obj, vg_off offset)
{
	if (!obj || !obj->elf.hdr.data)
		VGERR(VG_OBJ_HDR_SET_OFFSET, NULL, E_INVAL, ERR);
	obj->elf.hdr.offset = offset;
	return (obj->elf.hdr.offset);
}


/*
 * vg_obj_hdr_get/set_type = 
 */
Elf32_Half vg_obj_hdr_get_type(vg_object *obj)
{
	if (!obj || !obj->elf.hdr.data)
		VGERR(VG_OBJ_HDR_GET_TYPE, NULL, E_INVAL, ERR);
	return (obj->elf.hdr.data->e_type);
}

Elf32_Half vg_obj_hdr_set_type(vg_object *obj, Elf32_Half type)
{
	if (!obj || !obj->elf.hdr.data)
		VGERR(VG_OBJ_HDR_SET_TYPE, NULL, E_INVAL, ERR);
	obj->elf.hdr.data->e_type = type;
	SETOBJCH(obj);
	return (obj->elf.hdr.data->e_type);
}

/*
 * vg_obj_hdr_get/set_machine = 
 */
Elf32_Half vg_obj_hdr_get_machine(vg_object *obj)
{
	if (!obj || !obj->elf.hdr.data)
		VGERR(VG_OBJ_HDR_GET_MACHINE, NULL, E_INVAL, ERR);
	return (obj->elf.hdr.data->e_machine);
}

Elf32_Half vg_obj_hdr_set_machine(vg_object *obj, Elf32_Half machine)
{
	if (!obj || !obj->elf.hdr.data)
		VGERR(VG_OBJ_HDR_SET_MACHINE, NULL, E_INVAL, ERR);
	obj->elf.hdr.data->e_machine = machine;
	SETOBJCH(obj);
	return (obj->elf.hdr.data->e_machine);
}

/*
 * vg_obj_hdr_get/set_version = 
 */
Elf32_Word vg_obj_hdr_get_version(vg_object *obj)
{
	if (!obj || !obj->elf.hdr.data)
		VGERR(VG_OBJ_HDR_GET_VERSION, NULL, E_INVAL, ERR);
	return (obj->elf.hdr.data->e_version);
}

Elf32_Word vg_obj_hdr_set_version(vg_object *obj, Elf32_Word version)
{
	if (!obj || !obj->elf.hdr.data)
		VGERR(VG_OBJ_HDR_SET_VERSION, NULL, E_INVAL, ERR);
	obj->elf.hdr.data->e_version = version;
	SETOBJCH(obj);
	return (obj->elf.hdr.data->e_version);
}

/*
 * vg_obj_hdr_get/set_phentsize = 
 */
Elf32_Half vg_obj_hdr_get_phentsize(vg_object *obj)
{
	if (!obj || !obj->elf.hdr.data)
		VGERR(VG_OBJ_HDR_GET_PHENTSIZE, NULL, E_INVAL, ERR);
	return (obj->elf.hdr.data->e_phentsize);
}

Elf32_Half vg_obj_hdr_set_phentsize(vg_object *obj, Elf32_Half phentsize)
{
	if (!obj || !obj->elf.hdr.data)
		VGERR(VG_OBJ_HDR_SET_PHENTSIZE, NULL, E_INVAL, ERR);
	obj->elf.hdr.data->e_phentsize = phentsize;
	SETOBJCH(obj);
	return (obj->elf.hdr.data->e_phentsize);
}

/*
 * vg_obj_hdr_get/set_shentsize = 
 */
Elf32_Half vg_obj_hdr_get_shentsize(vg_object *obj)
{
	if (!obj || !obj->elf.hdr.data)
		VGERR(VG_OBJ_HDR_GET_SHENTSIZE, NULL, E_INVAL, ERR);
	return (obj->elf.hdr.data->e_shentsize);
}

Elf32_Half vg_obj_hdr_set_shentsize(vg_object *obj, Elf32_Half shentsize)
{
	if (!obj || !obj->elf.hdr.data)
		VGERR(VG_OBJ_HDR_SET_SHENTSIZE, NULL, E_INVAL, ERR);
	obj->elf.hdr.data->e_shentsize = shentsize;
	SETOBJCH(obj);
	return (obj->elf.hdr.data->e_shentsize);
}

/*
 * vg_obj_hdr_get/set_ehsize = 
 */
Elf32_Half vg_obj_hdr_get_ehsize(vg_object *obj)
{
	if (!obj || !obj->elf.hdr.data)
		VGERR(VG_OBJ_HDR_GET_EHSIZE, NULL, E_INVAL, ERR);
	return (obj->elf.hdr.data->e_ehsize);
}

Elf32_Half vg_obj_hdr_set_ehsize(vg_object *obj, Elf32_Half ehsize)
{
	if (!obj || !obj->elf.hdr.data)
		VGERR(VG_OBJ_HDR_SET_EHSIZE, NULL, E_INVAL, ERR);
	obj->elf.hdr.data->e_ehsize = ehsize;
	SETOBJCH(obj);
	return (obj->elf.hdr.data->e_ehsize);
}

/*
 * vg_obj_hdr_get/set_shnum = 
 */
Elf32_Half vg_obj_hdr_get_shnum(vg_object *obj)
{
	if (!obj || !obj->elf.hdr.data) 
		VGERR(VG_OBJ_HDR_GET_SHNUM, NULL, E_INVAL, ERR);
	return (obj->elf.hdr.data->e_shnum);
}

Elf32_Half vg_obj_hdr_set_shnum(vg_object *obj, Elf32_Half shnum)
{
	if (!obj || !obj->elf.hdr.data)
		VGERR(VG_OBJ_HDR_SET_SHNUM, NULL, E_INVAL, ERR);
	obj->elf.hdr.data->e_shnum = shnum;
	SETOBJCH(obj);
	return (obj->elf.hdr.data->e_shnum);
}

/*
 * vg_obj_hdr_get/set_shoff = 
 */
Elf32_Off vg_obj_hdr_get_shoff(vg_object *obj)
{
	if (!obj || !obj->elf.hdr.data)
		VGERR(VG_OBJ_HDR_GET_SHOFF, NULL, E_INVAL, ERR);
	return (obj->elf.hdr.data->e_shoff);
}

Elf32_Off vg_obj_hdr_set_shoff(vg_object *obj, Elf32_Off shoff)
{
	if (!obj || !obj->elf.hdr.data)
		VGERR(VG_OBJ_HDR_SET_SHOFF, NULL, E_INVAL, ERR);
	obj->elf.hdr.data->e_shoff = shoff;
	SETOBJCH(obj);
	return (obj->elf.hdr.data->e_shoff);
}

/*
 * vg_obj_hdr_get/set_phnum = 
 */
Elf32_Half vg_obj_hdr_get_phnum(vg_object *obj)
{
	if (!obj || !obj->elf.hdr.data) 
		VGERR(VG_OBJ_HDR_GET_PHNUM, NULL, E_INVAL, ERR);
	return (obj->elf.hdr.data->e_phnum);
}

Elf32_Half vg_obj_hdr_set_phnum(vg_object *obj, Elf32_Half phnum)
{
	if (!obj || !obj->elf.hdr.data)
		VGERR(VG_OBJ_HDR_SET_PHNUM, NULL, E_INVAL, ERR);
	obj->elf.hdr.data->e_phnum = phnum;
	SETOBJCH(obj);
	return (obj->elf.hdr.data->e_phnum);
}

/*
 * vg_obj_hdr_get/set_phoff = 
 */
Elf32_Off vg_obj_hdr_get_phoff(vg_object *obj)
{
	if (!obj || !obj->elf.hdr.data)
		VGERR(VG_OBJ_HDR_GET_PHOFF, NULL, E_INVAL, ERR);
	return (obj->elf.hdr.data->e_phoff);
}

Elf32_Off vg_obj_hdr_set_phoff(vg_object *obj, Elf32_Off phoff)
{
	if (!obj || !obj->elf.hdr.data)
		VGERR(VG_OBJ_HDR_SET_PHOFF, NULL, E_INVAL, ERR);
	obj->elf.hdr.data->e_phoff = phoff;
	SETOBJCH(obj);
	return (obj->elf.hdr.data->e_phoff);
}

/*
 * vg_obj_hdr_get/set_entry = 
 */
Elf32_Addr vg_obj_hdr_get_entry(vg_object *obj)
{
	if (!obj || !obj->elf.hdr.data) 
		VGERR(VG_OBJ_HDR_GET_ENTRY, NULL, E_INVAL, ERR);
	return (obj->elf.hdr.data->e_entry);
}

Elf32_Addr vg_obj_hdr_set_entry(vg_object *obj, Elf32_Addr entry)
{
	if (!obj || !obj->elf.hdr.data)
		VGERR(VG_OBJ_HDR_SET_ENTRY, NULL, E_INVAL, ERR);
	obj->elf.hdr.data->e_entry = entry;
	SETOBJCH(obj);
	return (obj->elf.hdr.data->e_entry);
}

