/*

 [=-- LIBVG --=] Runtime Process Manipulation Library [=------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE ON YOUR OWN RISK

*/
#ifndef	__LIBVG_HASH_H
#define	__LIBVG_HASH_H

#define	MAX_DIGEST_SZ	20

#define	MD5		0x1
#define	SHA1		0x2
#define	RMD160		0x3

/*
  ################
  ###   MD5    ###
  ################
*/

#define MD5_BLOCK_LENGTH	64
#define MD5_DIGEST_LENGTH	16

typedef struct md5_context {
	u_int	state[4];
	u_int64_t count;
	u_char	buf[MD5_BLOCK_LENGTH];
} VG_MD5_CTX;

vg_void		VG_MD5_Init(VG_MD5_CTX *);
vg_void		VG_MD5_Update(VG_MD5_CTX *, const u_char *, u_int);
vg_void		VG_MD5_Final(u_char [16], VG_MD5_CTX *);
vg_void		VG_MD5_Transform(u_int [4], const u_char [MD5_BLOCK_LENGTH]);

/*
  ################
  ###   SHA1   ###
  ################
*/

#define	SHA1_BLOCK_LENGTH	64
#define	SHA1_DIGEST_LENGTH	20

typedef struct sha1_context {
	u_int	state[5];
	u_int64_t count;
	u_char	buf[SHA1_BLOCK_LENGTH];
} VG_SHA1_CTX;

vg_void		VG_SHA1_Init(VG_SHA1_CTX *);
vg_void		VG_SHA1_Update(VG_SHA1_CTX *, u_char *, u_int);
vg_void		VG_SHA1_Final(u_char [20], VG_SHA1_CTX *);
vg_void		VG_SHA1_Transform(u_int [5], u_char [SHA1_BLOCK_LENGTH]);

/*
  ################
  ###  RMD160  ###
  ################

#define	RMD160_BLOCK_LENGTH	64
#define	RMD160_DIGEST_LENGTH	20

typedef struct rmd160_context {
} RMD160_CTX;

void	RMD160_Init(RMD160_CTX *);
void	RMD160_Update(RMD160_CTX *, const u_char *, u_int);
void	RMD160_Final(u_char *, RMD160_CTX *);

*/
/*
   ########################
   ###  HASH OPERATIONS  ##
   ########################
*/

struct hash_operations {
	vg_uint		hash_type;
	void		(*init)(void *);
	void		(*update)(void *, const u_char *, u_int);
	void		(*final)(u_char *, void *);
};

struct hash_operations hop_tbl[]=
{
	{
	MD5, 
	(void (*)(void *))VG_MD5_Init,
	(void (*)(void *, const u_char *, u_int))VG_MD5_Update,
	(void (*)(u_char *, void *))VG_MD5_Final
	},
	{
	SHA1,
	(void (*)(void *))VG_SHA1_Init,
	(void (*)(void *, const u_char *, u_int))VG_SHA1_Update,
	(void (*)(u_char *, void *))VG_SHA1_Final
	},
/*	{
	RMD160,
	(void (*)(void *))RMD160_Init,
	(void (*)(void *, const u_char *, u_int))RMD160_Update,
	(void (*)(u_char *, void *))RMD160_Final
	},
*/	{
	0, 0, 0, 0
	}	
};

union all_ctx {
	VG_MD5_CTX md5;
	VG_SHA1_CTX sha1;
};

#endif	/* __LIBVG_HASH_H */

