/*

 [=-- LIBVG --=] Runtime Process Manipulation Library [=------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE AT YOUR OWN RISK

*/

	/* decodificar func ids */
#define	GET_FUD_GROUP(x)		(((x) & 0xff00) >> 8)
#define	GET_FUD_ENTRY(x)		((x) & 0x00ff)

/* generic errors strings */
#define	E_INVAL					0x1000	/* incorrect arguments */
#define	E_FOO					0x1001

/* funcs id */			       		/*____*/

#define	VG_READ					0x0000
#define	VG_DREAD				0x0001
#define	VG_WRITE				0x0002
#define	VG_DWRITE				0x0003
#define VG_PROC_STOP				0x0004
#define VG_PROC_CONT				0x0005	
#define	VG_PROC_STEP				0x0006
#define	VG_GREGS				0x0007
#define	VG_SREGS				0x0008


#define	VG_INIT_PCTX				0x0100
#define	VG_FINI_PCTX				0x0101
#define	VG_SAVE_PCTX				0x0102
#define	VG_PROC_GET_ID				0x0103
#define	VG_PROC_GET_PID				0x0104
#define	VG_PROC_GET_OBJNUM			0x0105
#define	VG_PROC_GET_FLAGS			0x0106
#define	VG_PROC_GET_EXECPATH			0x0107
#define	VG_PROC_GET_NEXT			0x0108
#define	VG_PROC_GET_PREV			0x0109


#define VG_MAP_OBJECT				0x0200
#define VG_UNMAP_OBJECT				0x0201
#define VG_OBJ_BY_NAME				0x0202
#define VG_OBJ_BY_BASE				0x0203
#define VG_OBJ_BY_DYN				0x0204
#define VG_OBJ_BY_IDX				0x0205
#define VG_OBJ_BY_VADDR				0x0206
#define VG_OBJ_GET_TEXT_START			0x0207
#define VG_OBJ_SET_TEXT_START			0x0208
#define VG_OBJ_GET_TEXT_END			0x0209
#define VG_OBJ_SET_TEXT_END			0x020a
#define VG_OBJ_GET_TEXT_SIZE			0x020b
#define VG_OBJ_SET_TEXT_SIZE			0x020c
#define VG_OBJ_GET_DATA_START			0x020d
#define VG_OBJ_SET_DATA_START			0x020e
#define VG_OBJ_GET_DATA_END			0x020f
#define VG_OBJ_SET_DATA_END			0x0210
#define VG_OBJ_GET_DATA_SIZE			0x0211
#define VG_OBJ_SET_DATA_SIZE			0x0212
#define VG_OBJ_GET_HEAP_START			0x0213
#define VG_OBJ_SET_HEAP_START			0x0214
#define VG_OBJ_GET_HEAP_END			0x0215
#define VG_OBJ_SET_HEAP_END			0x0216
#define VG_OBJ_GET_HEAP_SIZE			0x0217
#define VG_OBJ_SET_HEAP_SIZE			0x0218
#define VG_OBJ_GET_NAME				0x0219
#define VG_OBJ_SET_NAME				0x021a
#define	VG_OBJ_GET_IDX				0x021b


#define	VG_DUMP_OBJ_HDR				0x0300
#define VG_DUMP_OBJ_PHDR			0x0301
#define VG_DUMP_OBJ_DYN				0x0302
#define VG_DUMP_OBJ_DYNSYM			0x0303
#define VG_DUMP_OBJ_DYNSTR			0x0304
#define VG_DUMP_OBJ_RELDYN			0x0305
#define VG_DUMP_OBJ_RELPLT			0x0306
#define VG_DUMP_OBJ_HASH			0x0307
#define VG_DUMP_OBJ_PLT				0x0308	
#define VG_DUMP_OBJ_SEG				0x0309
#define VG_DUMP_OBJ				0x030a
#define	VG_DUMP_STACK				0x030b
#define	VG_DUMP_DATA				0x030c
#define	VG_DUMP_SYM				0x030d
#define	VG_DUMP_OBJ_GOT				0x030e
#define	VG_DUMP_OBJ_INTERP			0x030f
#define	VG_DUMP_OBJ_BSS				0x0310
#define	VG_DUMP_OBJ_NOTE			0x0311


#define	VG_REPLACE_OBJ_HDR			0x0400
#define VG_REPLACE_OBJ_PHDR			0x0401
#define VG_REPLACE_OBJ_DYN			0x0402
#define VG_REPLACE_OBJ_DYNSYM			0x0403
#define VG_REPLACE_OBJ_DYNSTR			0x0404
#define VG_REPLACE_OBJ_RELDYN			0x0405
#define VG_REPLACE_OBJ_RELPLT			0x0406
#define VG_REPLACE_OBJ_HASH			0x0407
#define VG_REPLACE_OBJ_PLT			0x0408	
#define	VG_REPLACE_OBJ_GOT			0x0409
#define VG_REPLACE_OBJ_SEG			0x040a
#define	VG_REPLACE_STACK			0x040b
#define	VG_REPLACE_OBJ				0x040c
#define	VG_REPLACE_DATA				0x040d
#define	VG_REPLACE_SYM				0x040e
#define	VG_REPLACE_OBJ_INTERP			0x040f
#define	VG_REPLACE_OBJ_BSS			0x0410
#define	VG_REPLACE_OBJ_NOTE			0x0411


#define	VG_OBJ_GET_HDR				0x0500
#define	VG_OBJ_HDR_GET_VADDR			0x0501
#define VG_OBJ_HDR_SET_VADDR			0x0502
#define VG_OBJ_HDR_GET_SIZE			0x0503
#define VG_OBJ_HDR_SET_SIZE			0x0504
#define VG_OBJ_HDR_GET_OFFSET			0x0505
#define VG_OBJ_HDR_SET_OFFSET			0x0506
#define VG_OBJ_HDR_GET_TYPE			0x0507
#define VG_OBJ_HDR_SET_TYPE			0x0508
#define VG_OBJ_HDR_GET_MACHINE			0x0509
#define VG_OBJ_HDR_SET_MACHINE			0x050a
#define VG_OBJ_HDR_GET_VERSION			0x050b
#define VG_OBJ_HDR_SET_VERSION			0x050c
#define VG_OBJ_HDR_GET_PHENTSIZE		0x050d
#define VG_OBJ_HDR_SET_PHENTSIZE		0x050e
#define VG_OBJ_HDR_GET_SHENTSIZE		0x050f
#define VG_OBJ_HDR_SET_SHENTSIZE		0x0510
#define VG_OBJ_HDR_GET_EHSIZE			0x0511
#define VG_OBJ_HDR_SET_EHSIZE			0x0512
#define VG_OBJ_HDR_GET_SHNUM			0x0513
#define VG_OBJ_HDR_SET_SHNUM			0x0514
#define VG_OBJ_HDR_GET_SHOFF			0x0515
#define VG_OBJ_HDR_SET_SHOFF			0x0516
#define VG_OBJ_HDR_GET_PHNUM			0x0517
#define VG_OBJ_HDR_SET_PHNUM			0x0518
#define VG_OBJ_HDR_GET_PHOFF			0x0519
#define VG_OBJ_HDR_SET_PHOFF			0x051a
#define VG_OBJ_HDR_GET_ENTRY			0x051b
#define VG_OBJ_HDR_SET_ENTRY			0x051c


#define VG_OBJ_GET_PHDR				0x0600		
#define	VG_OBJ_PHDR_GET_VADDR			0x0601
#define VG_OBJ_PHDR_SET_VADDR			0x0602
#define VG_OBJ_PHDR_GET_SIZE			0x0603
#define VG_OBJ_PHDR_SET_SIZE			0x0604
#define VG_OBJ_PHDR_GET_OFFSET			0x0605
#define VG_OBJ_PHDR_SET_OFFSET			0x0606
#define VG_OBJ_PHDR_GET_ENTSIZE			0x0607
#define VG_OBJ_PHDR_SET_ENTSIZE			0x0608
#define VG_OBJ_PHDR_GET_ENTNUM			0x0609
#define VG_OBJ_PHDR_SET_ENTNUM			0x060a
#define VG_OBJ_PHENTRY_BY_IDX			0x060b
#define VG_OBJ_PHENTRY_BY_TYPE			0x060c
#define VG_OBJ_PHENTRY_BY_OFFSET		0x060d
#define VG_OBJ_PHENTRY_BY_VADDR			0x060e
#define VG_OBJ_PHENTRY_BY_MEMSZ			0x060f
#define VG_OBJ_PHENTRY_BY_FILESZ		0x0610
#define VG_OBJ_PHENTRY_GET_TYPE			0x0611
#define VG_OBJ_PHENTRY_SET_TYPE			0x0612
#define VG_OBJ_PHENTRY_GET_OFFSET		0x0613
#define VG_OBJ_PHENTRY_SET_OFFSET		0x0614
#define VG_OBJ_PHENTRY_GET_VADDR		0x0615
#define VG_OBJ_PHENTRY_SET_VADDR		0x0616
#define VG_OBJ_PHENTRY_GET_PADDR		0x0617
#define VG_OBJ_PHENTRY_SET_PADDR		0x0618
#define VG_OBJ_PHENTRY_GET_FILESZ		0x0619	
#define VG_OBJ_PHENTRY_SET_FILESZ		0x061a
#define VG_OBJ_PHENTRY_GET_MEMSZ		0x061b
#define VG_OBJ_PHENTRY_SET_MEMSZ		0x061c
#define VG_OBJ_PHENTRY_GET_FLAGS		0x061d
#define VG_OBJ_PHENTRY_SET_FLAGS		0x061e
#define VG_OBJ_PHENTRY_GET_ALIGN		0x061f
#define VG_OBJ_PHENTRY_SET_ALIGN		0x0620


#define	VG_OBJ_GET_INIT				0x0700
#define	VG_OBJ_INIT_GET_VADDR			0x0701
#define VG_OBJ_INIT_SET_VADDR			0x0702
#define VG_OBJ_INIT_GET_OFFSET			0x0703
#define VG_OBJ_INIT_SET_OFFSET			0x0704


#define	VG_OBJ_GET_FINI				0x0800
#define	VG_OBJ_FINI_GET_VADDR			0x0801
#define VG_OBJ_FINI_SET_VADDR			0x0802
#define VG_OBJ_FINI_GET_OFFSET			0x0803
#define VG_OBJ_FINI_SET_OFFSET			0x0804


#define	VG_OBJ_GET_INTERP			0x0900
#define VG_OBJ_INTERP_GET_VADDR			0x0901
#define VG_OBJ_INTERP_SET_VADDR			0x0902
#define VG_OBJ_INTERP_GET_OFFSET		0x0903
#define	VG_OBJ_INTERP_SET_OFFSET		0x0904
#define VG_OBJ_INTERP_GET_SIZE			0x0905
#define VG_OBJ_INTERP_SET_SIZE			0x0906


#define	VG_OBJ_GET_DYN				0x0a00
#define VG_OBJ_DYN_GET_VADDR			0x0a01
#define VG_OBJ_DYN_SET_VADDR			0x0a02
#define VG_OBJ_DYN_GET_SIZE			0x0a03
#define VG_OBJ_DYN_SET_SIZE			0x0a04
#define VG_OBJ_DYN_GET_OFFSET			0x0a05
#define VG_OBJ_DYN_SET_OFFSET			0x0a06
#define VG_OBJ_DYN_GET_ENTSIZE			0x0a07
#define VG_OBJ_DYN_SET_ENTSIZE			0x0a08
#define VG_OBJ_DYN_GET_ENTNUM			0x0a09
#define VG_OBJ_DYN_SET_ENTNUM			0x0a0a
#define VG_OBJ_DENTRY_BY_TYPE			0x0a0b
#define VG_OBJ_DENTRY_BY_VAL			0x0a0c
#define VG_OBJ_DENTRY_BY_IDX			0x0a0d
#define VG_OBJ_DENTRY_GET_TAG			0x0a0e
#define VG_OBJ_DENTRY_SET_TAG			0x0a0f
#define VG_OBJ_DENTRY_GET_PTR			0x0a10
#define VG_OBJ_DENTRY_SET_PTR			0x0a11
#define VG_OBJ_DENTRY_GET_STR			0x0a12
#define VG_OBJ_DENTRY_SET_STR			0x0a13


#define	VG_OBJ_GET_DYNSYM			0x0b00
#define	VG_OBJ_DYNSYM_GET_VADDR			0x0b01
#define VG_OBJ_DYNSYM_SET_VADDR			0x0b02
#define VG_OBJ_DYNSYM_GET_SIZE			0x0b03
#define VG_OBJ_DYNSYM_SET_SIZE			0x0b04
#define VG_OBJ_DYNSYM_GET_OFFSET		0x0b05
#define VG_OBJ_DYNSYM_SET_OFFSET		0x0b06
#define VG_OBJ_DYNSYM_GET_ENTSIZE		0x0b07
#define VG_OBJ_DYNSYM_SET_ENTSIZE		0x0b08
#define VG_OBJ_DYNSYM_GET_ENTNUM		0x0b09
#define VG_OBJ_DYNSYM_SET_ENTNUM		0x0b0a
#define VG_OBJ_DSYM_BY_IDX			0x0b0b
#define VG_OBJ_DSYM_BY_IDXNAME			0x0b0c
#define VG_OBJ_DSYM_BY_NAME			0x0b0d
#define VG_OBJ_DSYM_BY_VALUE			0x0b0e
#define VG_OBJ_DSYM_GET_IDXNAME			0x0b0f
#define VG_OBJ_DSYM_SET_IDXNAME			0x0b10
#define VG_OBJ_DSYM_GET_STRNAME			0x0b11
#define VG_OBJ_DSYM_SET_STRNAME			0x0b12
#define VG_OBJ_DSYM_GET_VALUE			0x0b13
#define VG_OBJ_DSYM_SET_VALUE			0x0b14
#define VG_OBJ_DSYM_GET_SIZE			0x0b15
#define VG_OBJ_DSYM_SET_SIZE			0x0b16
#define VG_OBJ_DSYM_GET_INFO			0x0b17
#define VG_OBJ_DSYM_SET_INFO			0x0b18
#define	VG_OBJ_DSYM_GET_INFO_BIND		0x0b19
#define VG_OBJ_DSYM_SET_INFO_BIND		0x0b1a
#define VG_OBJ_DSYM_GET_INFO_TYPE		0x0b1b
#define VG_OBJ_DSYM_SET_INFO_TYPE		0x0b1c
#define VG_OBJ_DSYM_GET_OTHER			0x0b1d
#define VG_OBJ_DSYM_SET_OTHER			0x0b1e
#define VG_OBJ_DSYM_GET_SHNDX			0x0b1f
#define VG_OBJ_DSYM_SET_SHNDX			0x0b20


#define	VG_OBJ_GET_DYNSTR			0x0c00
#define	VG_OBJ_DYNSTR_GET_VADDR			0x0c01
#define VG_OBJ_DYNSTR_SET_VADDR			0x0c02
#define VG_OBJ_DYNSTR_GET_SIZE			0x0c03
#define VG_OBJ_DYNSTR_SET_SIZE			0x0c04		
#define VG_OBJ_DYNSTR_GET_OFFSET		0x0c05
#define VG_OBJ_DYNSTR_SET_OFFSET		0x0c06


#define	VG_OBJ_GET_RELDYN			0x0d00
#define	VG_OBJ_RELDYN_GET_VADDR			0x0d01
#define VG_OBJ_RELDYN_SET_VADDR			0x0d02
#define VG_OBJ_RELDYN_GET_SIZE			0x0d03
#define VG_OBJ_RELDYN_SET_SIZE			0x0d04
#define VG_OBJ_RELDYN_GET_OFFSET		0x0d05
#define VG_OBJ_RELDYN_SET_OFFSET		0x0d06
#define VG_OBJ_RELDYN_GET_ENTSIZE		0x0d07
#define VG_OBJ_RELDYN_SET_ENTSIZE		0x0d08
#define VG_OBJ_RELDYN_GET_ENTNUM		0x0d09
#define VG_OBJ_RELDYN_SET_ENTNUM		0x0d0a
#define VG_OBJ_RELDYN_RENTRY_BY_IDX		0x0d0b
#define	VG_OBJ_RELDYN_RENTRY_BY_SYM		0x0d0c
#define VG_OBJ_RELDYN_RENTRY_BY_SYMIDX		0x0d0d
#define VG_OBJ_RELDYN_RENTRY_BY_OFFSET		0x0d0e


#define	VG_OBJ_GET_RELPLT			0x0e00
#define	VG_OBJ_RELPLT_GET_VADDR			0x0e01
#define VG_OBJ_RELPLT_SET_VADDR			0x0e02
#define VG_OBJ_RELPLT_GET_SIZE			0x0e03
#define VG_OBJ_RELPLT_SET_SIZE			0x0e04
#define VG_OBJ_RELPLT_GET_OFFSET		0x0e05
#define VG_OBJ_RELPLT_SET_OFFSET		0x0e06
#define VG_OBJ_RELPLT_GET_ENTSIZE		0x0e07
#define VG_OBJ_RELPLT_SET_ENTSIZE		0x0e08
#define VG_OBJ_RELPLT_GET_ENTNUM		0x0e09
#define VG_OBJ_RELPLT_SET_ENTNUM		0x0e0a
#define VG_OBJ_RELPLT_RENTRY_BY_IDX		0x0e0b
#define	VG_OBJ_RELPLT_RENTRY_BY_SYM		0x0e0c
#define VG_OBJ_RELPLT_RENTRY_BY_SYMIDX		0x0e0d
#define VG_OBJ_RELPLT_RENTRY_BY_OFFSET		0x0e0e
#define VG_OBJ_RENTRY_GET_OFFSET		0x0e0f
#define VG_OBJ_RENTRY_SET_OFFSET		0x0e10
#define VG_OBJ_RENTRY_GET_INFO			0x0e11
#define VG_OBJ_RENTRY_SET_INFO			0x0e12
#define VG_OBJ_RENTRY_GET_INFO_SYMIDX		0x0e13	
#define VG_OBJ_RENTRY_SET_INFO_SYMIDX		0x0e14
#define VG_OBJ_RENTRY_GET_INFO_TYPE		0x0e15
#define VG_OBJ_RENTRY_SET_INFO_TYPE		0x0e16


#define	VG_OBJ_GET_HASH				0x0f00
#define	VG_OBJ_HASH_GET_VADDR			0x0f01
#define	VG_OBJ_HASH_SET_VADDR			0x0f02
#define	VG_OBJ_HASH_GET_OFFSET			0x0f03
#define	VG_OBJ_HASH_SET_OFFSET			0x0f04
#define	VG_OBJ_HASH_GET_SIZE			0x0f05
#define	VG_OBJ_HASH_SET_SIZE			0x0f06


#define	VG_OBJ_GET_GOT				0x1000
#define	VG_OBJ_GOT_GET_VADDR			0x1001
#define VG_OBJ_GOT_SET_VADDR			0x1002
#define VG_OBJ_GOT_GET_OFFSET			0x1003
#define VG_OBJ_GOT_SET_OFFSET			0x1004
#define VG_OBJ_GOT_GET_SIZE			0x1005
#define VG_OBJ_GOT_SET_SIZE			0x1006
#define	VG_OBJ_GOT_GET_ENTSIZE			0x1007
#define	VG_OBJ_GOT_SET_ENTSIZE			0x1008
#define	VG_OBJ_GOT_GET_ENTNUM			0x1009
#define	VG_OBJ_GOT_SET_ENTNUM			0x100a
#define VG_OBJ_GENTRY_BY_IDX			0x100b
#define VG_OBJ_GENTRY_BY_REL			0x100c
#define VG_OBJ_GENTRY_BY_SYM			0x100d


#define	VG_OBJ_GET_PLT				0x1100
#define	VG_OBJ_PLT_GET_VADDR			0x1101
#define	VG_OBJ_PLT_SET_VADDR			0x1102
#define	VG_OBJ_PLT_GET_OFFSET			0x1103
#define	VG_OBJ_PLT_SET_OFFSET			0x1104
#define	VG_OBJ_PLT_GET_SIZE			0x1105
#define	VG_OBJ_PLT_SET_SIZE			0x1106
#define VG_OBJ_PLT_GET_ENTSIZE			0x1107
#define VG_OBJ_PLT_SET_ENTSIZE			0x1108
#define VG_OBJ_PLT_GET_ENTNUM			0x1109
#define VG_OBJ_PLT_SET_ENTNUM			0x110a
#define VG_OBJ_PLTENTRY_BY_IDX			0x110b
#define VG_OBJ_PLTENTRY_BY_SYM			0x110c	
#define VG_OBJ_PLTENTRY_GET_TYPE		0x110d
#define VG_OBJ_PLTENTRY_GET_IDX			0x110e
#define VG_OBJ_PLTENTRY_GET_VADDR		0x110f
#define	VG_OBJ_PLTENTRY_GET_OFFSET		0x1110
#define	VG_OBJ_PLTENTRY_GET_CODE		0x1111
#define VG_OBJ_PLTENTRY_GET_GOTVADDR		0x1112
#define VG_OBJ_PLTENTRY_SET_GOTVADDR		0x1113	
#define VG_OBJ_PLTENTRY_GET_GOTIDX		0x1114
#define VG_OBJ_PLTENTRY_SET_GOTIDX		0x1115


#define VG_OBJ_GET_BSS				0x1200
#define VG_OBJ_BSS_GET_VADDR			0x1201
#define VG_OBJ_BSS_SET_VADDR			0x1202
#define VG_OBJ_BSS_GET_SIZE			0x1203
#define VG_OBJ_BSS_SET_SIZE			0x1204
#define VG_OBJ_BSS_GET_OFFSET			0x1205
#define VG_OBJ_BSS_SET_OFFSET			0x1206


#define	VG_DIGEST_DATA				0x1300			
#define	VG_DIGEST_OBJ				0x1301


#define	VG_FORMAT_DATA				0x1400


#define	VG_SET_HOOK				0x1500
#define	VG_REDIR_S2S_BY_HOOK			0x1501
#define	VG_REDIR_S2V_BY_HOOK			0x1502
#define	VG_REDIR_S2S_BY_RELPLT			0x1503	
#define	VG_REDIR_S2V_BY_RELPLT			0x1504


#define VG_INJECT				0x1600


#define	VG_CREATE_EHDR				0x1700
#define VG_CREATE_PHDR				0x1701
#define VG_CREATE_SHENTRY			0x1702
#define VG_CREATE_DENTRY			0x1703
#define VG_CREATE_SENTRY			0x1704
#define VG_CREATE_RENTRY			0x1705


#define VG_BKPT_SET_BY_NAME			0x1800
#define	VG_BKPT_SET_BY_VADDR			0x1801
#define VG_BKPT_ENABLE				0x1802
#define VG_BKPT_DISABLE				0x1803
#define VG_BKPT_CHECK				0x1804
#define VG_BKPT_DEL_BY_IDX			0x1805
#define VG_BKPT_DEL_BY_VADDR			0x1806
#define VG_BKPT_DEL_LAST			0x1807
#define VG_BKPT_CLEAR				0x1808
#define VG_BKPT_FIND_BY_IDX			0x1809
#define VG_BKPT_FIND_BY_VADDR			0x180a


#define	VG_GET_STACK				0x1900
#define	VG_STACK_PUSH				0x1901
#define	VG_STACK_POP				0x1902


#define	__PROC_ATTACH				0x1a00
#define	__PROC_DETACH				0x1a01
#define __LOAD_ODT				0x1a02
#define	__UNLOAD_ODT				0x1a03
#define	__LOAD_OT				0x1a04
#define	__UNLOAD_OT				0x1a05


#define VG_OBJ_GET_NOTE				0x1b00
#define VG_OBJ_NOTE_GET_VADDR			0x1b01
#define VG_OBJ_NOTE_SET_VADDR			0x1b02
#define VG_OBJ_NOTE_GET_OFFSET			0x1b03
#define VG_OBJ_NOTE_SET_OFFSET			0x1b04
#define VG_OBJ_NOTE_GET_SIZE			0x1b05
#define VG_OBJ_NOTE_SET_SIZE			0x1b06


#define VG_SYM_FUNC_LOCAL_BY_IDX                0x1c00
#define VG_SYM_FUNC_LOCAL_BY_NAME               0x1c01
#define VG_SYM_FUNC_LOCAL_BY_VADDR              0x1c02
#define VG_SYM_FUNC_GLOBAL_BY_IDX               0x1c03
#define VG_SYM_FUNC_GLOBAL_BY_NAME              0x1c04
#define VG_SYM_FUNC_GLOBAL_BY_VADDR             0x1c05
#define VG_SYM_VAR_LOCAL_BY_IDX                 0x1c06
#define VG_SYM_VAR_LOCAL_BY_NAME                0x1c07
#define VG_SYM_VAR_LOCAL_BY_VADDR               0x1c08
#define VG_SYM_VAR_GLOBAL_BY_IDX                0x1c09
#define VG_SYM_VAR_GLOBAL_BY_NAME               0x1c0a
#define VG_SYM_VAR_GLOBAL_BY_VADDR              0x1c0b
#define VG_SYM_SECTION_BY_NAME                  0x1c0c
#define VG_SYM_FILE_BY_NAME                     0x1c0d
#define VG_SYM_GET_NAME                         0x1c0e
#define VG_SYM_GET_SONAME                       0x1c0f
#define VG_SYM_GET_VADDR                        0x1c10
#define VG_SYM_GET_SIZE                         0x1c11
#define VG_SYM_GET_OFFSET                       0x1c12
#define VG_SYM_GET_STRIDX                       0x1c13
#define VG_SYM_GET_SYMTABIDX                    0x1c14
#define VG_SYM_GET_INFO                        	0x1c15


typedef struct  function_descriptor {
	vg_ushort	id;
	vg_char		*name;
} vg_fud;


