/*

 [=-- LIBVG --=] Runtime Process Manipulation Library [=------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE ON YOUR OWN RISK

*/
#ifndef	__LIBVG_FUNCTIONS_H
#define	__LIBVG_FUNTIONS_H

/* 

                          _______________________
                         |   |               |   |
 <=======================|   |===============|   |===========================>
                         | + |   LIBVG API   | - |
 <=======================|   |===============|   |===========================>
                         |___|_______________|___|


*/


vg_proc		*vg_init_pctx(vg_pid pid, vg_char *path);
vg_int		vg_fini_pctx(vg_proc *proc);
vg_int		vg_save_pctx(vg_proc *proc);

		/* read/write data from/to the process address space */
vg_size		vg_read(void *buf, vg_vaddr vaddr, vg_size size);
vg_size		vg_write(void *buf, vg_vaddr vaddr, vg_size  size);

		/* read/write data on protected mode */
vg_size		vg_dread(void *buf, vg_vaddr vaddr, vg_size size);
vg_size		vg_dwrite(void *buf, vg_vaddr vaddr, vg_size size);

		/* get/set registers of the attached process */
vg_regs		*vg_gregs(vg_proc *p);
vg_regs		*vg_sregs(vg_proc *p, vg_regs *new_regs);

		/* change process status */
vg_int		vg_proc_cont(vg_proc *p);
vg_int		vg_proc_stop(vg_proc *p);
vg_int		vg_proc_step(vg_proc *p);

		/* basic process information */
vg_id		vg_proc_get_id(vg_proc *pctx);
vg_pid		vg_proc_get_pid(vg_proc *pctx);
vg_idx		vg_proc_get_objnum(vg_proc *pctx);
vg_flags	vg_proc_get_flags(vg_proc *pctx);
vg_char		*vg_proc_get_execpath(vg_proc *pctx);

		/* get next/prev process context */
vg_proc		*vg_proc_get_next(vg_proc *pctx);
vg_proc		*vg_proc_get_prev(vg_proc *pctx);


/*
 *		###############################
 *		##	   OBJECTS           ##
 *		###############################
 * 
 */
		/* map/unmap objects */
vg_int		vg_map_object(vg_object *obj);
vg_int		vg_unmap_object(vg_object *obj);

		/* search object structure by X */
vg_object	*vg_obj_by_name(vg_char *name);
vg_object	*vg_obj_by_base(vg_vaddr base);
vg_object	*vg_obj_by_dyn(vg_vaddr dyn);
vg_object	*vg_obj_by_idx(vg_idx idx);
vg_object	*vg_obj_by_vaddr(vg_vaddr vaddr, vg_uint *seg);

		/* get/set text segment range and size */
vg_vaddr	vg_obj_get_text_start(vg_object *obj);
vg_vaddr	vg_obj_set_text_start(vg_object *obj, vg_vaddr start);
vg_vaddr	vg_obj_get_text_end(vg_object *obj);
vg_vaddr	vg_obj_set_text_end(vg_object *obj, vg_vaddr end);
vg_size		vg_obj_get_text_size(vg_object *obj);
vg_size		vg_obj_set_text_size(vg_object *obj, vg_size size);

		/* get/set data segment range and size */
vg_vaddr	vg_obj_get_data_start(vg_object *obj);
vg_vaddr	vg_obj_set_data_start(vg_object *obj, vg_vaddr start);
vg_vaddr	vg_obj_get_data_end(vg_object *obj);
vg_vaddr	vg_obj_set_data_end(vg_object *obj, vg_vaddr end);
vg_size		vg_obj_get_data_size(vg_object *obj);
vg_size		vg_obj_set_data_size(vg_object *obj, vg_size size);

		/* get/set heap segment range and size */
vg_vaddr	vg_obj_get_heap_start(vg_object *obj);
vg_vaddr	vg_obj_set_heap_start(vg_object *obj, vg_vaddr start);
vg_vaddr	vg_obj_get_heap_end(vg_object *obj);
vg_vaddr	vg_obj_set_heap_end(vg_object *obj, vg_vaddr end);
vg_size		vg_obj_get_heap_size(vg_object *obj);
vg_size		vg_obj_set_heap_size(vg_object *obj, vg_size size);

		/* get or change the object name */
vg_char		*vg_obj_get_name(vg_object *obj);
vg_char		*vg_obj_set_name(vg_object *obj, vg_char *name);
vg_idx		vg_obj_get_idx(vg_object *obj);


/*
 *		###############################
 *		##	 STACK		     ##
 *		###############################
 * 
 */
vg_vaddr	vg_get_stack(void);

vg_vaddr	vg_stack_push(vg_void *data, vg_size size);
vg_vaddr	vg_stack_pop(vg_void *data, vg_size size);

vg_vaddr	vg_stack_get_start(void);
vg_vaddr	vg_stack_get_end(void);
vg_size		vg_stack_get_cur_size(void);
vg_size		vg_stack_get_max_size(void);


/*
 *		###############################
 *		##        ELF HEADER	     ##
 *		###############################
 *					     
 */
		/* load elf header */
Elf32_Ehdr	*vg_obj_get_hdr(vg_object *obj);

		/* get/set elf header vaddr and size on remote process */
vg_vaddr	vg_obj_hdr_get_vaddr(vg_object *obj);
vg_vaddr	vg_obj_hdr_set_vaddr(vg_object *obj, vg_vaddr vaddr);
vg_size		vg_obj_hdr_get_size(vg_object *obj);
vg_size		vg_obj_hdr_set_size(vg_object *obj, vg_size size);
vg_off		vg_obj_hdr_get_offset(vg_object *obj);
vg_off		vg_obj_hdr_set_offset(vg_object *obj, vg_off offset);

		/* get/set elf header info */
Elf32_Half	vg_obj_hdr_get_type(vg_object *obj);
Elf32_Half	vg_obj_hdr_set_type(vg_object *obj, Elf32_Half type);
Elf32_Half	vg_obj_hdr_get_machine(vg_object *obj);
Elf32_Half	vg_obj_hdr_set_machine(vg_object *obj, Elf32_Half machine);	
Elf32_Word	vg_obj_hdr_get_version(vg_object *obj);
Elf32_Word	vg_obj_hdr_set_version(vg_object *obj, Elf32_Word version);
Elf32_Half	vg_obj_hdr_get_phentsize(vg_object *obj);
Elf32_Half	vg_obj_hdr_set_phentsize(vg_object *obj, Elf32_Half phentsize);
Elf32_Half	vg_obj_hdr_get_shentsize(vg_object *obj);
Elf32_Half	vg_obj_hdr_set_shentsize(vg_object *obj, Elf32_Half shentsize);
Elf32_Half	vg_obj_hdr_get_ehsize(vg_object *obj);
Elf32_Half	vg_obj_hdr_set_ehsize(vg_object *obj, Elf32_Half ehsize);
Elf32_Half	vg_obj_hdr_get_shnum(vg_object *obj);
Elf32_Half	vg_obj_hdr_set_shnum(vg_object *obj, Elf32_Half shnum);
Elf32_Off	vg_obj_hdr_get_shoff(vg_object *obj);
Elf32_Off	vg_obj_hdr_set_shoff(vg_object *obj, Elf32_Off shoff); 
Elf32_Half	vg_obj_hdr_get_phnum(vg_object *obj);
Elf32_Half	vg_obj_hdr_set_phnum(vg_object *obj, Elf32_Half phnum);
Elf32_Off	vg_obj_hdr_get_phoff(vg_object *obj);
Elf32_Off	vg_obj_hdr_set_phoff(vg_object *obj, Elf32_Off phoff);
Elf32_Addr	vg_obj_hdr_get_entry(vg_object *obj);
Elf32_Addr	vg_obj_hdr_set_entry(vg_object *obj, Elf32_Addr entry);


/*		
 *		###############################
 *		##    PROGRAM HEADER TABLE   ##
 *		###############################
 *
 */
		/* load program header table */
Elf32_Phdr	*vg_obj_get_phdr(vg_object *obj, vg_uint *entnum);

		/* get/set phdr vaddr and size on remote process */
vg_vaddr	vg_obj_phdr_get_vaddr(vg_object *obj);
vg_vaddr	vg_obj_phdr_set_vaddr(vg_object *obj, vg_vaddr vaddr);
vg_size		vg_obj_phdr_get_size(vg_object *obj);
vg_size		vg_obj_phdr_set_size(vg_object *obj, vg_size size);
vg_off		vg_obj_phdr_get_offset(vg_object *obj);
vg_off		vg_obj_phdr_set_offset(vg_object *obj, vg_off offset);
vg_size		vg_obj_phdr_get_entsize(vg_object *obj);
vg_size		vg_obj_phdr_set_entsize(vg_object *obj, vg_size entsize);
vg_idx		vg_obj_phdr_get_entnum(vg_object *obj);
vg_idx		vg_obj_phdr_set_entnum(vg_object *obj, vg_idx entnum);

		/* search a program header entry by idx and/or type */
Elf32_Phdr	*vg_obj_phentry_by_idx(vg_object *obj, vg_idx idx);
Elf32_Phdr	*vg_obj_phentry_by_type(vg_object *obj, vg_uint type, vg_idx entidx);
Elf32_Phdr	*vg_obj_phentry_by_offset(vg_object *obj, vg_off offset, vg_idx entidx);
Elf32_Phdr	*vg_obj_phentry_by_vaddr(vg_object *obj, vg_vaddr vaddr, vg_idx entidx);
Elf32_Phdr	*vg_obj_phentry_by_memsz(vg_object *obj, vg_size memsz, vg_idx entidx);
Elf32_Phdr	*vg_obj_phentry_by_filesz(vg_object *obj, vg_size filesz, vg_idx entidx);

		/* get/set info of a program header entry */
Elf32_Word	vg_obj_phentry_get_type(vg_object *obj, Elf32_Phdr *phdr);
Elf32_Word	vg_obj_phentry_set_type(vg_object *obj, Elf32_Phdr *phdr, Elf32_Word type);
Elf32_Off	vg_obj_phentry_get_offset(vg_object *obj, Elf32_Phdr *phdr);
Elf32_Off	vg_obj_phentry_set_offset(vg_object *obj, Elf32_Phdr *phdr, Elf32_Off offset);
Elf32_Addr	vg_obj_phentry_get_vaddr(vg_object *obj, Elf32_Phdr *phdr);
Elf32_Addr	vg_obj_phentry_set_vaddr(vg_object *obj, Elf32_Phdr *phdr, Elf32_Addr vaddr);
Elf32_Addr	vg_obj_phentry_get_paddr(vg_object *obj, Elf32_Phdr *phdr);
Elf32_Addr	vg_obj_phentry_set_paddr(vg_object *obj, Elf32_Phdr *phdr, Elf32_Addr paddr);
Elf32_Word	vg_obj_phentry_get_filesz(vg_object *obj, Elf32_Phdr *phdr);
Elf32_Word	vg_obj_phentry_set_filesz(vg_object *obj, Elf32_Phdr *phdr, Elf32_Word filesz);
Elf32_Word	vg_obj_phentry_get_memsz(vg_object *obj, Elf32_Phdr *phdr);
Elf32_Word	vg_obj_phentry_set_memsz(vg_object *obj, Elf32_Phdr *phdr, Elf32_Word memsz);
Elf32_Word	vg_obj_phentry_get_flags(vg_object *obj, Elf32_Phdr *phdr);
Elf32_Word	vg_obj_phentry_set_flags(vg_object *obj, Elf32_Phdr *phdr, Elf32_Word flags);
Elf32_Word	vg_obj_phentry_get_align(vg_object *obj, Elf32_Phdr *phdr);
Elf32_Word	vg_obj_phentry_set_align(vg_object *obj, Elf32_Phdr *phdr, Elf32_Word align);
	

/*
 *		###############################
 *		##	DYNAMIC SECTION	     ##
 *		###############################
 *
 */
		/* load dynamic section */
Elf32_Dyn	*vg_obj_get_dyn(vg_object *obj, vg_uint *entnum);
			
		/* get/set dynamic section vaddr and size on remote process */
vg_vaddr	vg_obj_dyn_get_vaddr(vg_object *obj);
vg_vaddr	vg_obj_dyn_set_vaddr(vg_object *obj, vg_vaddr vaddr);
vg_size		vg_obj_dyn_get_size(vg_object *obj);
vg_size		vg_obj_dyn_set_size(vg_object *obj, vg_size size);
vg_off          vg_obj_dyn_get_offset(vg_object *obj);
vg_off          vg_obj_dyn_set_offset(vg_object *obj, vg_off offset);
vg_size         vg_obj_dyn_get_entsize(vg_object *obj);
vg_size         vg_obj_dyn_set_entsize(vg_object *obj, vg_size entsize);
vg_idx          vg_obj_dyn_get_entnum(vg_object *obj);
vg_idx          vg_obj_dyn_set_entnum(vg_object *obj, vg_idx entnum);

		/* search an entry by type(tag) and/or idx */
Elf32_Dyn	*vg_obj_dentry_by_type(vg_object *obj, vg_int type, vg_idx entidx);
Elf32_Dyn	*vg_obj_dentry_by_idx(vg_object *obj, vg_idx idx);
Elf32_Dyn	*vg_obj_dentry_by_val(vg_object *obj, vg_vaddr val, vg_idx entidx);

		/* get/change info of a dynamic entry */
vg_int		vg_obj_dentry_get_tag(vg_object *obj, Elf32_Dyn *dentry);
vg_int		vg_obj_dentry_set_tag(vg_object *obj, Elf32_Dyn *dentry, Elf32_Sword tag);
vg_vaddr	vg_obj_dentry_get_ptr(vg_object *obj, Elf32_Dyn *dentry);
vg_int		vg_obj_dentry_set_ptr(vg_object *obj, Elf32_Dyn *dentry, vg_vaddr vaddr);
vg_char		*vg_obj_dentry_get_str(vg_object *obj, Elf32_Dyn *dentry);
vg_char		*vg_obj_dentry_set_str(vg_object *obj, Elf32_Dyn *dentry, vg_char *str);


/*
 *		####################################################
 *		##   DYNAMIC SYMBOL TABLE / DYNAMIC STRING TABLE  ##
 *		####################################################
 *
 */
		/* load dynamic symbol and dynamic string table */
Elf32_Sym	*vg_obj_get_dynsym(vg_object *obj, vg_uint *entnum);
vg_char		*vg_obj_get_dynstr(vg_object *obj);

		/* get/set the dynamic symbol table vaddr and size on remote
		process */
vg_vaddr	vg_obj_dynsym_get_vaddr(vg_object *obj);
vg_vaddr	vg_obj_dynsym_set_vaddr(vg_object *obj, vg_vaddr vaddr);
vg_size		vg_obj_dynsym_get_size(vg_object *obj);
vg_size		vg_obj_dynsym_set_size(vg_object *obj, vg_size size);
vg_off          vg_obj_dynsym_get_offset(vg_object *obj);
vg_off          vg_obj_dynsym_set_offset(vg_object *obj, vg_off offset);
vg_size         vg_obj_dynsym_get_entsize(vg_object *obj);
vg_size         vg_obj_dynsym_set_entsize(vg_object *obj, vg_size entsize);
vg_idx          vg_obj_dynsym_get_entnum(vg_object *obj);
vg_idx          vg_obj_dynsym_set_entnum(vg_object *obj, vg_idx entnum);

		/* get/set the dynamic strint table vaddr and size on remote
		process */
vg_vaddr	vg_obj_dynstr_get_vaddr(vg_object *obj);
vg_vaddr	vg_obj_dynstr_set_vaddr(vg_object *obj, vg_vaddr vaddr);
vg_size		vg_obj_dynstr_get_size(vg_object *obj);
vg_size		vg_obj_dynstr_set_size(vg_object *obj, vg_size size);
vg_off          vg_obj_dynstr_get_offset(vg_object *obj);
vg_off          vg_obj_dynstr_set_offset(vg_object *obj, vg_off offset);

		/* search */
Elf32_Sym	*vg_obj_dsym_by_idx(vg_object *obj, vg_idx idx);
Elf32_Sym	*vg_obj_dsym_by_idxname(vg_object *obj, vg_idx idxname);
Elf32_Sym	*vg_obj_dsym_by_name(vg_object *obj, vg_char *name);
Elf32_Sym	*vg_obj_dsym_by_value(vg_object *obj, vg_vaddr value);

		/* get/change info of a dynamic symbol entry */
Elf32_Word	vg_obj_dsym_get_idxname(vg_object *obj, Elf32_Sym *sym);
Elf32_Word	vg_obj_dsym_set_idxname(vg_object *obj, Elf32_Sym *sym, Elf32_Word idx);
vg_char		*vg_obj_dsym_get_strname(vg_object *obj, Elf32_Sym *sym);
vg_char		*vg_obj_dsym_set_strname(vg_object *obj, Elf32_Sym *sym, vg_char *strname);
Elf32_Addr	vg_obj_dsym_get_value(vg_object *obj, Elf32_Sym *sym);
Elf32_Addr	vg_obj_dsym_set_value(vg_object *obj, Elf32_Sym *sym, Elf32_Addr value);
Elf32_Word	vg_obj_dsym_get_size(vg_object *obj, Elf32_Sym *sym);
Elf32_Word	vg_obj_dsym_set_size(vg_object *obj, Elf32_Sym *sym, Elf32_Word size);
vg_uchar	vg_obj_dsym_get_info(vg_object *obj, Elf32_Sym *sym);
vg_uchar	vg_obj_dsym_set_info(vg_object *obj, Elf32_Sym *sym, vg_uchar info);
vg_uchar	vg_obj_dsym_get_info_bind(vg_object *obj, Elf32_Sym *sym);
vg_uchar	vg_obj_dsym_set_info_bind(vg_object *obj, Elf32_Sym *sym, vg_uchar bind);
vg_uchar	vg_obj_dsym_get_info_type(vg_object *obj, Elf32_Sym *sym);
vg_uchar	vg_obj_dsym_set_info_type(vg_object *obj, Elf32_Sym *sym, vg_uchar type);
vg_uchar	vg_obj_dsym_get_other(vg_object *obj, Elf32_Sym *sym);
vg_uchar	vg_obj_dsym_set_other(vg_object *obj, Elf32_Sym *sym, vg_uchar other);
Elf32_Half	vg_obj_dsym_get_shndx(vg_object *obj, Elf32_Sym *sym);
Elf32_Half	vg_obj_dsym_set_shndx(vg_object *obj, Elf32_Sym *sym, Elf32_Half shndx);
	

/*
 *		###############################
 *		##     RELOCATION TABLES     ##
 *		###############################
 *
 */
		/* load reldyn and relplt tables */
Elf32_Rel       *vg_obj_get_reldyn(vg_object *obj, vg_uint *entnum);
Elf32_Rel       *vg_obj_get_relplt(vg_object *obj, vg_uint *entnum);

vg_vaddr	vg_obj_reldyn_get_vaddr(vg_object *obj);
vg_vaddr	vg_obj_reldyn_set_vaddr(vg_object *obj, vg_vaddr vaddr);
vg_size		vg_obj_reldyn_get_size(vg_object *obj);
vg_size		vg_obj_reldyn_set_size(vg_object *obj, vg_size size);
vg_off          vg_obj_reldyn_get_offset(vg_object *obj);
vg_off          vg_obj_reldyn_set_offset(vg_object *obj, vg_off offset);
vg_size         vg_obj_reldyn_get_entsize(vg_object *obj);
vg_size         vg_obj_reldyn_set_entsize(vg_object *obj, vg_size entsize);
vg_idx          vg_obj_reldyn_get_entnum(vg_object *obj);
vg_idx          vg_obj_reldyn_set_entnum(vg_object *obj, vg_idx entnum);

vg_vaddr	vg_obj_relplt_get_vaddr(vg_object *obj);
vg_vaddr	vg_obj_relplt_set_vaddr(vg_object *obj, vg_vaddr vaddr);
vg_size		vg_obj_relplt_get_size(vg_object *obj);
vg_size		vg_obj_relplt_set_size(vg_object *obj, vg_size size);
vg_off          vg_obj_relplt_get_offset(vg_object *obj);
vg_off          vg_obj_relplt_set_offset(vg_object *obj, vg_off offset);
vg_size         vg_obj_relplt_get_entsize(vg_object *obj);
vg_size         vg_obj_relplt_set_entsize(vg_object *obj, vg_size entsize);
vg_idx          vg_obj_relplt_get_entnum(vg_object *obj);
vg_idx          vg_obj_relplt_set_entnum(vg_object *obj, vg_idx entnum);

		/* search */
Elf32_Rel	*vg_obj_relplt_rentry_by_idx(vg_object *obj, vg_idx idx);
Elf32_Rel	*vg_obj_relplt_rentry_by_sym(vg_object *obj, vg_char *sname);
Elf32_Rel	*vg_obj_relplt_rentry_by_symidx(vg_object *obj, vg_idx symidx);
Elf32_Rel	*vg_obj_relplt_rentry_by_offset(vg_object *obj, vg_off offset);

Elf32_Rel	*vg_obj_reldyn_rentry_by_idx(vg_object *obj, vg_idx idx);
Elf32_Rel	*vg_obj_reldyn_rentry_by_sym(vg_object *obj, vg_char *sname);
Elf32_Rel	*vg_obj_reldyn_rentry_by_symidx(vg_object *obj, vg_idx symidx);
Elf32_Rel	*vg_obj_reldyn_rentry_by_offset(vg_object *obj, vg_off offset);

		/* get/set info of relocation entry */
Elf32_Addr	vg_obj_rentry_get_offset(vg_object *obj, Elf32_Rel *rentry);
Elf32_Addr	vg_obj_rentry_set_offset(vg_object *obj, Elf32_Rel *retnry, Elf32_Addr offset);
Elf32_Word	vg_obj_rentry_get_info(vg_object *obj, Elf32_Rel *rentry);
Elf32_Word	vg_obj_rentry_set_info(vg_object *obj, Elf32_Rel *rentry, Elf32_Word info);
Elf32_Word	vg_obj_rentry_get_info_symidx(vg_object *obj, Elf32_Rel *rentry);
Elf32_Word	vg_obj_rentry_set_info_symidx(vg_object *obj, Elf32_Rel *retnry, vg_idx symidx);
Elf32_Word	vg_obj_rentry_get_info_type(vg_object *obj, Elf32_Rel *rentry);
Elf32_Word	vg_obj_rentry_set_info_type(vg_object *obj, Elf32_Rel *rentry, vg_uchar type);


/*
 *		##############################
 *		##	 INTERP             ##
 *		##############################
 *
 */
vg_char		*vg_obj_get_interp(vg_object *obj);

vg_off		vg_obj_interp_get_offset(vg_object *obj);
vg_off		vg_obj_interp_set_offset(vg_object *obj, vg_off offset);
vg_vaddr	vg_obj_interp_get_vaddr(vg_object *obj);
vg_vaddr	vg_obj_interp_set_vaddr(vg_object *obj, vg_vaddr vaddr);
vg_size		vg_obj_interp_get_size(vg_object *obj);
vg_size		vg_obj_interp_set_size(vg_object *obj, vg_size size);


/*
 * 		###############################
 *		##	  HASH TABLE         ##
 *		###############################
 *
 */
vg_vaddr	*vg_obj_get_hash(vg_object *obj);

vg_vaddr	vg_obj_hash_get_vaddr(vg_object *obj);
vg_vaddr	vg_obj_hash_set_vaddr(vg_object *obj, vg_vaddr vaddr);
vg_size		vg_obj_hash_get_size(vg_object *obj);
vg_size		vg_obj_hash_set_size(vg_object *obj, vg_size size);
vg_off		vg_obj_hash_get_offset(vg_object *obj);
vg_off		vg_obj_hash_set_offset(vg_object *obj, vg_off offset);

vg_vaddr	vg_symbol_hash(const char *name);
Elf32_Sym	*get_sym_in_hash(vg_object *, vg_char *, vg_idx *, vg_idx);


/*
 *		###############################
 *		##	    GOT		     ##
 *		###############################
 *
 */
vg_vaddr	*vg_obj_get_got(vg_object *obj, vg_int *entnum);

vg_vaddr	vg_obj_got_get_vaddr(vg_object *obj);
vg_vaddr	vg_obj_get_set_vaddr(vg_object *obj, vg_vaddr vaddr);
vg_off		vg_obj_got_get_offset(vg_object *obj);
vg_off		vg_obj_got_set_offset(vg_object *obj, vg_off offset);
vg_size		vg_obj_got_get_size(vg_object *obj);
vg_size		vg_obj_got_set_size(vg_object *obj, vg_size size);
vg_idx		vg_obj_got_get_entnum(vg_object *obj);
vg_idx		vg_obj_got_set_entnum(vg_object *obj, vg_idx entnum);
vg_size		vg_obj_got_get_entsize(vg_object *obj);
vg_size		vg_obj_got_set_entsize(vg_object *obj, vg_size entsize);

vg_int		vg_obj_gentry_by_idx(vg_object *obj, vg_idx idx, vg_gotentry *gent);
vg_int		vg_obj_gentry_by_sym(vg_object *obj, vg_char *sname, vg_gotentry *gent);


/*
 *		###############################
 *		##	PLT		     ##
 *		###############################
 *
 */
vg_char		*vg_obj_get_plt(vg_object *obj, vg_idx *entnum);

vg_vaddr        vg_obj_plt_get_vaddr(vg_object *obj);
vg_vaddr        vg_obj_plt_set_vaddr(vg_object *obj, vg_vaddr vaddr);
vg_size         vg_obj_plt_get_size(vg_object *obj);
vg_size         vg_obj_plt_set_size(vg_object *obj, vg_size size);
vg_off          vg_obj_plt_get_offset(vg_object *obj);
vg_off          vg_obj_plt_set_offset(vg_object *obj, vg_off offset);
vg_size         vg_obj_plt_get_entsize(vg_object *obj);
vg_size         vg_obj_plt_set_entsize(vg_object *obj, vg_size entsize);
vg_idx          vg_obj_plt_get_entnum(vg_object *obj);
vg_idx          vg_obj_plt_set_entnum(vg_object *obj, vg_idx entnum);


/*
 *		###############################
 *		##	FINI		     ##
 *		###############################
 *
 */
vg_vaddr	*vg_obj_get_fini(vg_object *obj);

vg_vaddr	vg_obj_fini_get_vaddr(vg_object *obj);
vg_vaddr	vg_obj_fini_set_vaddr(vg_object *obj, vg_vaddr vaddr);
vg_off		vg_obj_fini_get_offset(vg_object *obj);
vg_off		vg_obj_fini_set_offset(vg_object *obj, vg_off offset);


/*
 *		###############################
 *		##	INIT		     ##
 *		###############################
 *
 */
vg_vaddr	*vg_obj_get_init(vg_object *obj);

vg_vaddr	vg_obj_init_get_vaddr(vg_object *obj);
vg_vaddr	vg_obj_init_set_vaddr(vg_object *obj, vg_vaddr vaddr);
vg_off		vg_obj_init_get_offset(vg_object *obj);
vg_off		vg_obj_init_set_offset(vg_object *obj, vg_off offset);


/*
 *		###############################
 *		##	NOTE		     ##
 *		###############################
 *
 */
vg_char		*vg_obj_get_note(vg_object *obj);

vg_off		vg_obj_note_get_offset(vg_object *obj);
vg_off		vg_obj_note_set_offset(vg_object *obj, vg_off offset);
vg_vaddr	vg_obj_note_get_vaddr(vg_object *obj);
vg_vaddr	vg_obj_note_set_vaddr(vg_object *obj, vg_vaddr vaddr);
vg_size		vg_obj_note_get_size(vg_object *obj);
vg_size		vg_obj_note_set_size(vg_object *obj, vg_size size);


/*
 *		###############################
 *		##	BSS                  ##
 *		###############################
 *
 */
vg_char		*vg_obj_get_bss(vg_object *obj);

vg_vaddr	vg_obj_bss_get_vaddr(vg_object *obj);
vg_vaddr	vg_obj_bss_set_vaddr(vg_object *obj, vg_vaddr vaddr);
vg_size		vg_obj_bss_get_size(vg_object *obj);
vg_size		vg_obj_bss_set_size(vg_object *obj, vg_size size);
vg_off		vg_obj_bss_get_offset(vg_object *obj);
vg_off		vg_obj_bss_set_offset(vg_object *obj, vg_off offset);


/*
 *		###############################
 *		##	REPLACE DATA	     ##
 *		###############################
 *
 */
vg_int		vg_replace_obj_hdr(vg_object *obj, vg_int fd, vg_char *buf);
vg_int		vg_replace_obj_phdr(vg_object *obj, vg_int fd, vg_char *buf);
vg_int		vg_replace_obj_dyn(vg_object *obj, vg_int fd, vg_char *buf);
vg_int		vg_replace_obj_dynsym(vg_object *obj, vg_int fd, vg_char *buf);
vg_int		vg_replace_obj_dynstr(vg_object *obj, vg_int fd, vg_char *buf);
vg_int		vg_replace_obj_reldyn(vg_object *obj, vg_int fd, vg_char *buf);
vg_int 		vg_replace_obj_relplt(vg_object *obj, vg_int fd, vg_char *buf);
vg_int 		vg_replace_obj_hash(vg_object *obj, vg_int fd, vg_char *buf);
vg_int		vg_replace_obj_interp(vg_object *obj, vg_int fd, vg_char *buf);
vg_int		vg_replace_obj_note(vg_object *obj, vg_int fd, vg_char *buf);
vg_int		vg_replace_obj_bss(vg_object *obj, vg_int fd, vg_char *buf);
vg_int 		vg_replace_obj_plt(vg_object *obj, vg_int fd, vg_char *buf);
vg_int		vg_replace_obj_got(vg_object *obj, vg_int fd, vg_char *buf);
vg_int 		vg_replace_obj_seg(vg_object *obj, vg_int fd, vg_char *buf, vg_int type);
vg_int		vg_replace_stack(vg_int fd, vg_char *buf);
vg_int 		vg_replace_obj(vg_object *obj, vg_int fd, vg_char *buf);
vg_int 		vg_replace_data(vg_vaddr start, vg_vaddr end, vg_int fd, vg_char *buf);
vg_int 		vg_replace_sym(vg_int fd, vg_char *buf, vg_sym *sym, vg_char *name);


/*
 *		###############################
 *		##	  DUMP DATA	     ##
 *		###############################
 *
 */
vg_int		vg_dump_obj_hdr(vg_object *obj, vg_int fd, vg_char *buf);
vg_int		vg_dump_obj_phdr(vg_object *obj, vg_int fd, vg_char *buf);
vg_int		vg_dump_obj_dyn(vg_object *obj, vg_int fd, vg_char *buf);
vg_int		vg_dump_obj_dynsym(vg_object *obj, vg_int fd, vg_char *buf);
vg_int		vg_dump_obj_dynstr(vg_object *obj, vg_int fd, vg_char *buf);
vg_int		vg_dump_obj_hash(vg_object *obj, vg_int fd, vg_char *buf);
vg_int		vg_dump_obj_plt(vg_object *obj, vg_int fd, vg_char *buf);
vg_int		vg_dump_obj_got(vg_object *obj, vg_int fd, vg_char *buf);
vg_int		vg_dump_obj_reldyn(vg_object *obj, vg_int fd, vg_char *buf);
vg_int		vg_dump_obj_relplt(vg_object *obj, vg_int fd, vg_char *buf);
vg_int		vg_dump_obj_interp(vg_object *obj, vg_int fd, vg_char *buf);
vg_int		vg_dump_obj_note(vg_object *obj, vg_int fd, vg_char *buf);
vg_int		vg_dump_obj_bss(vg_object *obj, vg_int fd, vg_char *buf);
vg_int		vg_dump_obj_seg(vg_object *obj, vg_int fd, vg_char *buf, vg_uint type);
vg_int		vg_dump_stack(vg_int fd, vg_char *buf);
vg_int		vg_dump_obj(vg_object *obj, vg_int fd, vg_char *buf);
vg_int		vg_dump_data(vg_vaddr start, vg_vaddr end, vg_int fd, vg_char *buf);
vg_int		vg_dump_sym(vg_int fd, vg_char *buf, vg_sym *s, vg_char *name);

vg_int		vg_format_data(vg_size size, u_char *data, u_char *fdata);


/*
 *		#########################
 *		##       Symbols       ##
 *              #########################
 *
 */
		/* Local Functions */
vg_int		vg_sym_func_local_by_idx(vg_object *obj, vg_sym *sym, vg_idx idx);
vg_int		vg_sym_func_local_by_name(vg_object *obj, vg_sym *sym, vg_char *name);
vg_int		vg_sym_func_local_by_vaddr(vg_object *obj, vg_sym *sym, vg_vaddr vaddr);

		/* Global Functions */
vg_int		vg_sym_func_global_by_idx(vg_object *obj, vg_sym *sym, vg_idx idx);
vg_int		vg_sym_func_global_by_name(vg_object *obj, vg_sym *sym, vg_char *name);
vg_int		vg_sym_func_global_by_vaddr(vg_object *obj, vg_sym *sym, vg_vaddr vaddr);

		/* Local Variables */
vg_int		vg_sym_var_local_by_idx(vg_object *obj, vg_sym *sym, vg_idx idx);
vg_int		vg_sym_var_local_by_name(vg_object *obj, vg_sym *sym, vg_char *name);
vg_int		vg_sym_var_local_by_vaddr(vg_object *obj, vg_sym *sym, vg_vaddr vaddr);

		/* Global variables */
vg_int		vg_sym_var_global_by_idx(vg_object *obj, vg_sym *sym, vg_idx idx);
vg_int		vg_sym_var_global_by_name(vg_object *obj, vg_sym *sym, vg_char *name);
vg_int		vg_sym_var_global_by_vaddr(vg_object *obj, vg_sym *sym, vg_vaddr vaddr);

		/* Sections */
vg_int		vg_sym_section_by_name(vg_object *obj, vg_sym *sym, vg_char *name);

		/* Others */
vg_int		vg_sym_file_by_name(vg_object *obj, vg_sym *sym, vg_char *name);

vg_char		*vg_symbol_get_soname(vg_sym *s);
vg_char		*vg_symbol_get_name(vg_sym *s);

vg_vaddr	vg_symbol_get_vaddr(vg_sym *s);
vg_off		vg_symbol_get_offset(vg_sym *s);
vg_size		vg_symbol_get_size(vg_sym *s);
vg_idx		vg_symbol_get_stridx(vg_sym *s);
vg_char		vg_symbol_get_info(vg_sym *s);
vg_idx		vg_symbol_get_symtabidx(vg_sym *s);


/*
 *              ##################################
 *              ##      SYMBOL REDIRECTION      ##
 *              ##################################
 *
 */
vg_int		vg_set_hook(vg_vaddr from, vg_vaddr to);
vg_int		vg_redir_s2s_by_hook(vg_char *from, vg_char *to);
vg_int		vg_redir_s2v_by_hook(vg_char *from, vg_vaddr to);
vg_int		vg_redir_s2s_by_relplt(vg_object *obj, vg_char *from, vg_char *to);
vg_int		vg_redir_s2v_by_relplt(vg_object *obj, vg_char *from, vg_vaddr to);


/*
 *		##############################
 *		##      CODE INJECTION      ##
 *		##############################
 *
 */
vg_int		vg_inject(vg_vaddr where, void *start, void *end, vg_size size,
                                                vg_char *str1, vg_char *str2);


/*
 *		#################################
 *		##      DIGEST RUTINES         ##
 *		#################################
 *
 */
vg_int		vg_digest_data(vg_uint htype, vg_uchar *data, vg_size dsize,
						vg_uchar *digest, vg_int fd);

vg_int		vg_digest_obj(vg_uint htype, vg_object *obj, vg_int what,
						vg_uchar *digest, vg_int fd);




/*
 *		###############################
 *		##        DEBUG              ##
 *		###############################
 *
 */
vg_int		vg_bkpt_set_by_name(vg_char *symname);
vg_int		vg_bkpt_set_by_vaddr(vg_vaddr vaddr);

vg_int		vg_bkpt_enable(vg_bkpt *bkpt);
vg_int		vg_bkpt_disable(vg_bkpt *bkpt);

vg_int		vg_bkpt_del_by_idx(vg_idx idx);
vg_int		vg_bkpt_del_by_vaddr(vg_vaddr vaddr);
vg_int		vg_bkpt_del_last();

vg_int		vg_bkpt_clear();

vg_bkpt		*vg_bkpt_find_by_idx(vg_idx idx);
vg_bkpt		*vg_bkpt_find_by_vaddr(vg_vaddr vaddr);



/*
 *		##############################
 *		##	CREATE	ENTRIES	    ##
 *		##############################
 */
vg_int		vg_create_ehdr(vg_vaddr vaddr, vg_uchar ident[16], vg_uint16 type,	
			vg_uint16 machine, vg_uint32 version, vg_vaddr entry,
			vg_off phoff, vg_off shoff, vg_uint32 flags, vg_uint16 ehsize,
			vg_uint16 phentsize, vg_uint16 phnum, vg_uint16 shentsize,
			vg_uint16 shnum, vg_uint16 shstrndx);

vg_int		vg_create_phdr(vg_vaddr vaddr, vg_uint32 type, vg_off offset,
			vg_vaddr vvaddr, vg_vaddr paddr, vg_uint32 filesz,
			vg_uint32 memsz, vg_uint32 flags, vg_uint32 align);

vg_int		vg_create_shentry(vg_vaddr vaddr, vg_uint name, vg_uint type,
			vg_uint flags, vg_vaddr vvaddr, vg_off offset,
			vg_size size, vg_uint link, vg_uint info,
			vg_uint addralign, vg_uint entsize);

vg_int		vg_create_dentry(vg_vaddr vaddr, vg_int tag, vg_uint32 val,
			vg_vaddr ptr);

vg_int		vg_create_sentry(vg_vaddr, vg_uint32 name, vg_vaddr value,
			vg_size size, vg_uchar info, vg_uchar other, 
			vg_uint16 shndx);

vg_int		vg_create_rentry(vg_vaddr, vg_off offset, vg_idx symidx, 
			vg_uchar type);


/*
 *		##############################
 *		##          RESIN           ##
 *		##############################
 *
 */
vg_int		vg_sys_mmap(vg_size size, int prot, int flags);
vg_int		vg_sys_munmap(u_long vaddr, vg_size size);
vg_int		vg_sys_mprotect(vg_vaddr vaddr, vg_size size, vg_int prot);
vg_int		vg_sys_open(char *path, int flags, int mode);
vg_int		vg_sys_read(int fd, vg_vaddr addr, vg_size size);
vg_int		vg_sys_write(int fd, vg_vaddr addr, vg_size size);
vg_int		vg_sys_chmod(char *path, int mode);
vg_int		vg_sys_fchmod(int fd, int mode);
vg_int		vg_sys_chdir(char *path);
vg_int		vg_sys_fchdir(int fd);
vg_int		vg_sys_chroot(char *path);
vg_int		vg_sys_getpid(void);
vg_int		vg_sys_getppid(void);
vg_int		vg_sys_getuid(void);
vg_int		vg_sys_geteuid(void);
vg_int		vg_sys_getgid(void);
vg_int		vg_sys_getegid(void);
vg_int		vg_sys_mkdir(char *path, int mode);
vg_int		vg_sys_rmdir(char *path);
vg_int		vg_sys_rename(char *from , char *to);
vg_int		vg_sys_dup(int oldd);
vg_int		vg_sys_dup2(int oldd, int newd);
vg_int		vg_sys_link(char *name1, char *name2);
vg_int		vg_sys_unlink(char *path);
vg_int		vg_sys_mkfifo(char *path, int mode);


#endif	/* __LIBVG_FUNCTIONS_H */

