/*

 [=-- LIBVG --=] Runtime Process Manipulation Library [=------------- v0.2 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE ON YOUR OWN RISK

*/
#ifndef	__LIBVG_GLOBALS_H
#define	__LIBVG_GLOBALS_H

/* page size */
#ifndef PAGE_SIZE
#define	PAGE_SIZE		4096
#endif

/* ret values 			*/
#define	ERR			-1
#define	OK			0

/* VGERR macro flags 		*/
#define	KEEP_LAST		0x01
#define	NO_RET			0x10
#define	CLEAN			1

#define	PLT_LINKER		0
#define	PLT_GOTENTRY		1

#define	DEFAULT_ALIGN		PAGE_SIZE

/* proc flags (vg_pctx->flags)  */
#define	PROC_INUSE		0x0001		/* currect process at foreground 	*/
#define	PROC_NOUSE		0x0002		/* process at background 		*/
#define	PROC_OBJD_CHANGED	0x0004		/* set object ref list changed 		*/
#define	PROC_RG_CHANGED		0x0008		/* set regs changed 			*/
#define	PROC_PROTECTED_MODE	0x0010		/* protected mode for curr proc 	*/
#define	PROC_DIRECT_MODE	0x0020		/* directed mode for curr proc 		*/
#define	PROC_WITH_RTLD		0x0040		/* dynamically linked process		*/
#define	PROC_WITHOUT_RTLD	0x0080		/* statically linked process		*/
#define	PROC_BKPT		0x0100		/* some breakpoint enabled		*/

/* object flags (vg_object->flags) */
#define	OBJ_USED		0x0000		/* object has been used 		*/
#define	OBJ_MAPPED		0x0001		/* object is mapped = protected	mode 	*/
#define	OBJ_CHANGED		0x0002		/* object has been modified		*/
#define	OBJ_MO			0x0004		/* object is the main object 		*/
#define	OBJ_SO			0x0008		/* object is a shared object 		*/

/* trace process state          */
#define PS_STOPPED		0x0001		/* traced process is stopped		*/
#define PS_RUNNING		0x0002		/* traced process is running		*/
#define PS_TERMINATED		0x0004		/* traced process was terminated	*/
#define PS_BKPT			0x0008		/* trace process is stopped by a bkpt	*/
#define PS_ICE			0x0010		
#define	ENABLED			0x0000		/* SIGCHLD handler is enabled		*/
#define	DISABLED		0x0001		/* SIGCHLD handler is disabled		*/ 

/* object segments types 	*/
#define	VG_TEXT_SEG		0x0100		/* text segment				*/
#define	VG_DATA_SEG		0x0200		/* data segment 			*/
#define	VG_HEAP_SEG		0x0400		/* heap segment pff.. 			*/
#define	VG_STACK_SEG		0x0800


/* tags for code injections and others */
#define	VG_OBJ_HDR		0x1
#define	VG_OBJ_PHDR		0x2
#define VG_OBJ_DYN		0x3	
#define	VG_OBJ_DYNSYM		0x4
#define	VG_OBJ_DYNSTR		0x5
#define	VG_OBJ_RELPLT		0x6
#define	VG_OBJ_RELDYN		0x7
#define	VG_OBJ_HASH		0x8
#define	VG_OBJ_GOT		0x9
#define	VG_OBJ_PLT		0xa
#define VG_OBJ_BSS              0xb
#define VG_OBJ_NOTE             0xc
#define VG_OBJ_FINI             0xd
#define VG_OBJ_INIT             0xe
#define	VG_OBJ_INTERP		0xf
#define VG_OBJ_TEXT_SEG		0x10
#define	VG_OBJ_DATA_SEG		0x11
#define VG_OBJ_HEAP_SEG		0x12
#define VG_STACK 		0x13
#define VG_NEXT_INSTRUCTION 	0x14
#define	VG_FUNC			0x15
#define	VG_VAR			0x16
#define	LAST_TAG		VG_VAR


/* stack base address */
#if defined(__i386__)
#if defined(__linux__)
#define	STACK_TOP		0xC0000000
#elif defined(__OpenBSD__)
#define	STACK_TOP		0xCFBF0000
#elif defined(__FreeBSD__)	
#define	STACK_TOP		0xEFBFE000
#elif defined(__NetBSD__)
#define	STACK_TOP		0xC0000000
#endif
#endif

//#define	SOLARIS_STACK_BASE	0xC0000000

#define	ST_NO_EXPANDED		0x0001
#define	ST_EXPANDED		0x0002

#define	INCORRECT_ENTRY		0x0010

/* def 16 */
#define	HEX_ROW_SZ		16

/* code insertion */
#define	VG_HEAD			"VG_HEAD"
#define	VG_TAIL			"VG_TAIL"
#define	EXTERNAL_CODE		0x1
#define	INTERNAL_CODE		0x2

#define M_SHARED_OBJECT         0x1
#define M_SHELLCODE             0x2
#define M_VADDR                 0x3


/* breakpoints stuff		*/
#define	BKPT_ENABLE		0x0001		/* set breakpoint enabled		*/
#define	BKPT_DISABLE		0x0002		/* set breaopoind disabled		*/
#if defined(__i386__) || defined(i386)		/* x86 */
 #define BKPT_SIZE		1
 #define BKPT_CODE		0xcc			
#elif defined(sun)				/* sparc */
 #define BKPT_SIZE		4
 #define BKPT_CODE		0x91d02001
#endif

#define	MAX_BUF			0x100
#define	MAX_OBJECTS		0x100
#define	MAX_OBJ_DESC		0x100

#define	NUM_SIG			30

/* ptrace globals 		*/
#ifdef PT_TRACE_ME	
#define	VG_TRACE_ME		PT_TRACE_ME
#endif
#ifdef PT_ATTACH
#define VG_ATTACH		PT_ATTACH
#endif
#ifdef PT_DETACH
#define	VG_DETACH		PT_DETACH
#endif
#ifdef PT_READ_I
#define	VG_READ_I		PT_READ_I
#endif
#ifdef PT_READ_D
#define	VG_READ_D		PT_READ_D
#endif
#ifdef PT_WRITE_I
#define	VG_WRITE_I		PT_WRITE_I
#endif
#ifdef PT_WRITE_D
#define	VG_WRITE_D		PT_WRITE_D
#endif
#ifdef PT_CONTINUE
#define	VG_CONTINUE		PT_CONTINUE
#endif
#ifdef PT_KILL
#define VG_KILL			PT_KILL
#endif
#ifdef PT_GETREGS
#define VG_GET_REGS		PT_GETREGS
#endif
#ifdef PT_SETREGS
#define	VG_SET_REGS		PT_SETREGS
#endif
#ifdef PT_STEP
#define	VG_STEP			PT_STEP
#endif

/* elf stuff 			*/
#ifndef	ELFMAG
#define	ELFMAG			"\177ELF"
#endif
#ifndef	SELFMAG
#define	SELFMAG			4
#endif

/* os globals 			*/
#if defined(__OpenBSD__) || defined(__FreeBSD__) || defined(__NetBSD__)
#define __BSD__			0x1
#endif	

#endif	/* __LIBVG_GLOBALS_H */

