

/* some internals funcs */
vg_int		proc_attach(vg_pid pid);
vg_int		proc_detach(vg_pid pid);

vg_int		load_odt(vg_proc *proc, Elf32_Ehdr *, Elf32_Phdr*);
vg_int		unload_odt(vg_proc *proc);
vg_int		load_objects_table(vg_object **list, vg_obj_desc **reflist);
vg_int		unload_objects_table(vg_object **list);

vg_int		setup_proc_operations(vg_proc *p);
vg_int		setup_object_operations(vg_object *obj);
vg_int		setup_stack_operations(vg_proc *p);

vg_int		set_error_msg(vg_ushort, char *, vg_flags flags);

vg_int		get_stack_info();

int             vg_bkpt_check(void);

vg_vaddr        get_sun_objref_list(vg_proc *p);
void            get_base();

void		enable_rpsm();
void		disable_rpsm();

void            check_pstate();
void            sig_handler();
void            load_default_sighandlers(void);


