/*

 [=-- LIBVG --=] Runtime Process Manipulation Library [=------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE ON YOUR OWN RISK

*/
#ifndef __LIBVG_RESIN_H
#define	__LIBVG_RESIN_H

typedef	struct	str_arg_info {	/* [e] String argument ======== */
	vg_char	*str;		/* ptr to string		*/
	vg_size	size;		/* size of string		*/
	vg_int	patch;		/* byte of sc to patch		*/
}	str_arg;

typedef	struct	sys_info {	/* [e] Syscall Info =========== */
	vg_char	*code;		/* ptr to shellcode		*/
	vg_size	size;		/* size of shellcode		*/
	str_arg	str1;		/* first string arg		*/
	str_arg	str2;		/* second string arg		*/
}	sys;

#if defined(__i386__)
/*

   	###################################
   	##	  I386 templates         ##
   	################################### 

*/
/* 
   -----------------------------------
   syscall template1: 1 arg, ret = esi 
   -----------------------------------
*/
vg_char	sc_temp1[]=
"\x31\xc0"
"\xbb\x00\x00\x00\xB0"		/* (B) arg1		buf[3]	*/
"\x53"
"\xb8\x00\x00\x00\xA0"		/* (A) syscall		buf[9]	*/
"\x50"
"\xcd\x80"
"\x89\xc6";

/* 
   ------------------------------------
   syscall template2: 2 args, ret = esi
   ------------------------------------
*/
vg_char	sc_temp2[]=
"\x31\xc9"			
"\x31\xdb"
"\x31\xc0"
"\xb9\x00\x00\x00\xC0"		/* (C) arg2 		buf[7]	*/
"\x51"
"\xbb\x00\x00\x00\xB0"		/* (B) arg1		buf[13]	*/
"\x53"
"\xb8\x00\x00\x00\xA0"		/* (A) syscall		buf[19]	*/
"\x50"				
"\xcd\x80"
"\x89\xc6";

/* 
   ------------------------------------
   syscall template3: 3 args, ret = esi
   ------------------------------------
*/
vg_char	sc_temp3[]=
"\x31\xc0"
"\xba\x00\x00\x00\xD0"		/* (D) arg3		buf[3]	*/
"\x52"			
"\xb9\x00\x00\x00\xC0"		/* (C) arg2		buf[9]	*/
"\x51"
"\xbb\x00\x00\x00\xB0"		/* (B) arg1		buf[15]	*/
"\x53"			
"\xb8\x00\x00\x00\xA0"		/* (A) syscall		buf[21]	*/
"\x50"
"\xcd\x80"
"\x89\xc6";

/* 
   ------------------------------------
   syscall template4: 4 args, ret = esi
   ------------------------------------
*/
vg_char	sc_temp4[]=
"\x31\xc0"
"\xbe\x00\x00\x00\xE0"		/* (E) arg4		buf[3] 	*/
"\x56"				
"\xba\x00\x00\x00\xD0"		/* (D) arg3 		buf[9]	*/
"\x52"
"\xb9\x00\x00\x00\xC0"		/* (C) arg2		buf[15]	*/
"\x51"
"\xbb\x00\x00\x00\xB0"		/* (B) arg1		buf[21]	*/
"\x53"
"\xb8\x00\x00\x00\xA0"		/* (A) syscall		buf[27] */
"\x50"
"\xcd\x80"
"\x89\xc6";

/*
   -----------------------------------
   return shellcode: getpid() + kill()
   -----------------------------------
*/
char    sc_ret[]=
"\x31\xc0"                      /* GETPID()             	*/
"\xb8\x00\x00\x00\xa0"          /* buf[3] SYS_getpid    	*/
"\x50"
"\xcd\x80"
"\x89\xc3"                      /* KILL() kill arg => mov eax, ebx */
"\xb9\x00\x00\x00\xb0"          /* buf[13] signal => SIGSTOP            */
"\x51"
"\x53"
"\x31\xc0"
"\xb8\x00\x00\x00\xc0"          /* buf[22] SYS_getpid           */
"\x50"
"\xcd\x80";

#define SC_GETPID		SYS_getpid
#define SC_KILL			SYS_kill
#define SC_RET_SIZE		29

char    sc_mmap[]=
"\x31\xc0"
"\x50"
"\x50"
"\x6a\xff"
"\x68\x00\x00\x00\xd0"          /* buf[7]       (D) prot        */
"\x68\x00\x00\x00\xc0"          /* buf[12]      (C) flags       */
"\x68\x00\x00\x00\xb0"          /* buf[17]      (B) size        */
"\x50"
"\x89\xe3"
"\x68\x00\x00\x00\xa0"          /* buf[25]      (A) syscall     */
"\xb8\x00\x00\x00\xa0"          /* buf[30]                      */
"\xcd\x80"
"\x89\xc6";

#define SC_MMAP                 SYS_mmap
#define SC_MMAP_SIZE            38
#define SC_MMAP_ARG1            17
#define SC_MMAP_ARG2            12
#define SC_MMAP_ARG3            7
#define SC_MMAP_DEFARG1         0x1000
#define SC_MMAP_DEFARG2         (PROT_EXEC|PROT_READ|PROT_WRITE)
#define SC_MMAP_DEFARG3         (MAP_PRIVATE|MAP_ANON)


#define SC_TEMP1_SIZE		18
#define	SC_TEMP1_SYSN		9
#define	SC_TEMP1_ARG1		3

#define SC_TEMP2_SIZE           28
#define SC_TEMP2_SYSN           19
#define SC_TEMP2_ARG1           13
#define SC_TEMP2_ARG2           7

#define SC_TEMP3_SIZE           30
#define SC_TEMP3_SYSN           21
#define SC_TEMP3_ARG1           15
#define SC_TEMP3_ARG2           9
#define SC_TEMP3_ARG3           3

#define SC_TEMP4_SIZE           36
#define SC_TEMP4_SYSN           27
#define SC_TEMP4_ARG1           21
#define SC_TEMP4_ARG2           15
#define SC_TEMP4_ARG3           9
#define SC_TEMP4_ARG4           3

#define	SC_CHDIR		SYS_chdir
#define	SC_CHDIR_DEFARG1	0x0

#define	SC_FCHDIR		SYS_fchdir
#define	SC_FCHDIR_DEFARG1	0x0

#define	SC_CHROOT		SYS_chroot
#define	SC_CHROOT_DEFARG1	0x0

#define	SC_GETPPID		SYS_getppid
#define	SC_GETUID		SYS_getuid
#define	SC_GETEUID		SYS_geteuid
#define	SC_GETGID		SYS_getgid
#define	SC_GETEGID		SYS_getegid

#define	SC_MUNMAP		SYS_munmap
#define SC_MUNMAP_DEFARG1	0
#define	SC_MUNMAP_DEFARG2	0x1000

#define	SC_CHMOD		SYS_chmod
#define	SC_CHMOD_DEFARG1	0
#define	SC_CHMOD_DEFARG2	(S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH)

#define	SC_FCHMOD		SYS_fchmod
#define	SC_FCHMOD_DEFARG1	0
#define	SC_FCHMOD_DEFARG2	(S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH)

#define SC_MPROTECT		SYS_mprotect
#define	SC_MPROTECT_DEFARG1	0	
#define SC_MPROTECT_DEFARG2	0x1000
#define SC_MPROTECT_DEFARG3	(PROT_READ|PROT_WRITE|PROT_EXEC)

#define	SC_MLOCK		SYS_mlock
#define	SC_MLOCK_DEFARG1	0
#define	SC_MLOCK_DEFARG2	0
	
#define	SC_MUNLOCK		SYS_munlock
#define	SC_MUNLOCK_DEFARG1	0
#define	SC_MUNLOCK_DEFARG2	0

#define	SC_MLOCKALL		SYS_mlockall
#define	SC_MLOCKALL_DEFARG1	0
#define	SC_MLOCKALL_DEFARG2	0

#define	SC_MUNLOCKALL		SYS_munlockall
#define	SC_MUNLOCKALL_DEFARG1	0
#define SC_MUNLOCKALL_DEFARG2	0

#define SC_OPEN			SYS_open
#define	SC_OPEN_DEFARG1		0x0
#define SC_OPEN_DEFARG2		(O_RDWR|O_CREAT)
#define SC_OPEN_DEFARG3		0x1a4		/* perm 644 */

#define	SC_READ			SYS_read
#define	SC_READ_DEFARG1		0x0
#define	SC_READ_DEFARG2		0x0
#define SC_READ_DEFARG3		0x0

#define	SC_WRITE		SYS_write
#define	SC_WRITE_DEFARG1	0x0
#define	SC_WRITE_DEFARG2	0x0
#define SC_WRITE_DEFARG3	0x0

#define	SC_DUP			SYS_dup
#define	SC_DUP_DEFARG1		0x0

#define	SC_DUP2			SYS_dup2
#define	SC_DUP2_DEFARG1		0x0	
#define	SC_DUP2_DEFARG2		0x0

#define	SC_MKDIR		SYS_mkdir
#define	SC_MKDIR_DEFARG1	0x0
#define	SC_MKDIR_DEFARG2	0x1ed	/* perm 755 */

#define	SC_RMDIR		SYS_rmdir
#define	SC_RMDIR_DEFARG1	0x0

#define	SC_RENAME		SYS_rename
#define	SC_RENAME_DEFARG1	0x0
#define SC_RENAME_DEFARG2	0x0

#define	SC_LINK			SYS_link
#define SC_LINK_DEFARG1		0x0
#define	SC_LINK_DEFARG2		0x0

#define	SC_UNLINK		SYS_unlink
#define	SC_UNLINK_DEFARG1	0x0

#endif


#endif

