/*

 [=-- LIBVG --=] Runtime Process Manipulation Library [=------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE AT YOUR OWN RISK

*/
#include "libvg.h"

/*
 * vg_obj_get_init = load init section
 */
vg_vaddr *vg_obj_get_init(vg_object *obj)
{	
	Elf32_Dyn	*init;

	if (!obj)
		VGERR(VG_OBJ_GET_INIT, NULL, E_INVAL, NULL);

	if (obj->elf.init.vaddr)
		goto end;

	if (!vg_obj_get_dyn(obj, 0))
		return (NULL);

	if (!(init = vg_obj_dentry_by_type(obj, DT_INIT, 0)))
		VGERR(VG_OBJ_GET_INIT, "INIT section not found", 0, NULL);	

	SET_OBJECT_VADDR(init->d_un.d_ptr, obj);

	obj->elf.init.vaddr = init->d_un.d_ptr;
	obj->elf.init.offset = obj->elf.init.vaddr - obj->text.start;
end:
	return ((vg_vaddr*)obj->elf.init.vaddr);
}

/*
 * vg_obj_init_get/set_vaddr = get/set the starting address of the init 
 * section
 */
vg_vaddr vg_obj_init_get_vaddr(vg_object *obj)
{
	if (!obj)
		VGERR(VG_OBJ_FINI_GET_VADDR, NULL, E_INVAL, ERR);
	return (obj->elf.init.vaddr);
}

vg_vaddr vg_obj_init_set_vaddr(vg_object *obj, vg_vaddr vaddr)
{
	if (!obj)
		VGERR(VG_OBJ_FINI_SET_VADDR, NULL, E_INVAL, ERR);
	obj->elf.init.vaddr = vaddr;
	return (obj->elf.init.vaddr);
}

/*
 * vg_obj_init_get/set_offset = get/set the offset of the init section
 * into the object
 */
vg_off	vg_obj_init_get_offset(vg_object *obj)
{
	if (!obj)
		VGERR(VG_OBJ_FINI_SET_OFFSET, NULL, E_INVAL, ERR);
	return (obj->elf.init.offset);
}

vg_off	vg_obj_init_set_offset(vg_object *obj, vg_off offset)
{
	if (!obj)
		VGERR(VG_OBJ_FINI_SET_OFFSET, NULL, E_INVAL, ERR);
	obj->elf.init.offset = offset;
	return (obj->elf.init.offset);
}

