/*

 [=-- LIBVG --=] Runtime Process Manipulation Library [=------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE AT YOUR OWN RISK

*/
#include "libvg.h"


/*
 * vg_obj_get_interp = 
 *
 */
vg_char	*vg_obj_get_interp(vg_object *obj)
{
	Elf32_Phdr	*intp;

	CHECKDYN(VG_OBJ_GET_INTERP, NULL);
	if (!obj)
		VGERR(VG_OBJ_GET_INTERP, NULL, E_INVAL, NULL);

	if (obj->elf.interp.data)
		goto end;	

	if (!(intp = vg_obj_phentry_by_type(obj, PT_INTERP, 0)))
		VGERR(VG_OBJ_GET_INTERP, "INTERP section not found", 0, NULL);

	SET_OBJECT_VADDR(intp->p_vaddr, obj);

	if (OBJ_IS_MAPPED(obj)) {
		obj->elf.interp.data = (char*)RTOL((u_long)intp->p_vaddr, obj);
	} 
	else {
		S_ALLOC(obj->elf.interp.data, intp->p_filesz, NULL, 
						VG_OBJ_GET_INTERP, CLEAN);
		if (vg_dread(obj->elf.interp.data, intp->p_vaddr,
					intp->p_filesz) != intp->p_filesz)
			VGERR2(VG_OBJ_GET_INTERP, 0, 0, NULL, obj->elf.interp.data);
	}
	obj->elf.interp.vaddr = intp->p_vaddr;
	obj->elf.interp.offset = intp->p_offset;
	obj->elf.interp.size = intp->p_filesz;
end:
	return (obj->elf.interp.data);
}

/*
 * vg_obj_interp_get/set_offet = 
 *
 */
vg_off vg_obj_interp_get_offset(vg_object *obj)
{
	CHECKDYN(VG_OBJ_INTERP_GET_OFFSET, ERR);
	if (!obj || !obj->elf.interp.data)
		VGERR(VG_OBJ_INTERP_GET_OFFSET, NULL, E_INVAL, ERR);
	return (obj->elf.interp.offset);
}

vg_off vg_obj_interp_set_offset(vg_object *obj, vg_off offset)
{
	CHECKDYN(VG_OBJ_INTERP_SET_OFFSET, ERR);
	if (!obj || !obj->elf.interp.data)
		VGERR(VG_OBJ_INTERP_SET_OFFSET, NULL, E_INVAL, ERR);
	obj->elf.interp.offset = offset;
	return (obj->elf.interp.offset);
}

/*
 * vg_obj_interp_get/set_vaddr = 
 *
 */
vg_vaddr vg_obj_interp_get_vaddr(vg_object *obj)
{
	CHECKDYN(VG_OBJ_INTERP_GET_VADDR ,ERR);
	if (!obj || !obj->elf.interp.data)
		VGERR(VG_OBJ_INTERP_GET_VADDR, NULL, E_INVAL, ERR);
	return (obj->elf.interp.vaddr);
}

vg_vaddr vg_obj_interp_set_vaddr(vg_object *obj, vg_vaddr vaddr)
{
	CHECKDYN(VG_OBJ_INTERP_SET_VADDR, ERR);
	if (!obj || !obj->elf.interp.data)
		VGERR(VG_OBJ_INTERP_SET_VADDR, NULL, E_INVAL, ERR);
	obj->elf.interp.vaddr = vaddr;
	return (obj->elf.interp.vaddr);
}

/*
 * vg_obj_interp_get/set_size = 
 *
 */
vg_size	vg_obj_interp_get_size(vg_object *obj)
{
	CHECKDYN(VG_OBJ_INTERP_GET_SIZE, ERR);
	if (!obj || !obj->elf.interp.data)
		VGERR(VG_OBJ_INTERP_GET_SIZE, NULL, E_INVAL, ERR);
	return (obj->elf.interp.size);
}

vg_size	vg_obj_interp_set_size(vg_object *obj, vg_size size)
{
	CHECKDYN(VG_OBJ_INTERP_SET_SIZE, ERR);
	if (!obj || !obj->elf.interp.data)
		VGERR(VG_OBJ_INTERP_SET_SIZE, NULL, E_INVAL, ERR);
	obj->elf.interp.size = size;
	return (obj->elf.interp.size);
}

