/*

 [=-- LIBVG --=] Runtime Process Manipulation Library [=------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE AT YOUR OWN RISK

*/
#include "libvg.h"

/*
 * vg_obj_get_note = load note section
 * 
 * @obj:
 * #ret:
 */
vg_char	*vg_obj_get_note(vg_object *obj)
{
	Elf32_Phdr *note;

	if (!obj)
		VGERR(VG_OBJ_GET_NOTE, NULL, E_INVAL, NULL);

	if (obj->elf.note.data)
		goto end;	

	if (!(note = vg_obj_phentry_by_type(obj, PT_NOTE, 0)))
		VGERR(VG_OBJ_GET_NOTE, "NOTE section not found", 0, NULL);

	SET_OBJECT_VADDR(note->p_vaddr, obj);

	if (OBJ_IS_MAPPED(obj)) {
		obj->elf.note.data = (char*)RTOL((u_long)note->p_vaddr, obj);
	} 
	else {
		S_ALLOC(obj->elf.note.data, note->p_filesz, NULL, VG_OBJ_GET_NOTE, CLEAN);
		if (vg_dread(obj->elf.note.data, note->p_vaddr, note->p_filesz) != 
								note->p_filesz)
			VGERR2(VG_OBJ_GET_NOTE, 0, 0, NULL, obj->elf.note.data);
	}
	obj->elf.note.vaddr = note->p_vaddr;
	obj->elf.note.offset = note->p_offset;
	obj->elf.note.size = note->p_filesz;
end:
	return (obj->elf.note.data);
}

/*
 * vg_obj_note_get/set_offset = get/set the offset of the note section
 * into the object
 */
vg_off vg_obj_note_get_offset(vg_object *obj)
{
	if (!obj || !obj->elf.note.data)
		VGERR(VG_OBJ_NOTE_GET_OFFSET, NULL, E_INVAL, ERR);
	return (obj->elf.note.offset);
}

vg_off vg_obj_note_set_offset(vg_object *obj, vg_off offset)
{
	if (!obj || !obj->elf.note.data)
		VGERR(VG_OBJ_NOTE_SET_OFFSET, NULL, E_INVAL, ERR);
	obj->elf.note.offset = offset;
	return (obj->elf.note.offset);
}

/*
 * vg_obj_note_get/set_vaddr = get/set the starting address of the note
 * section
 */
vg_vaddr vg_obj_note_get_vaddr(vg_object *obj)
{
	if (!obj || !obj->elf.note.data)
		VGERR(VG_OBJ_NOTE_GET_VADDR, NULL, E_INVAL, ERR);
	return (obj->elf.note.vaddr);
}

vg_vaddr vg_obj_note_set_vaddr(vg_object *obj, vg_vaddr vaddr)
{
	if (!obj || !obj->elf.note.data)
		VGERR(VG_OBJ_NOTE_SET_VADDR, NULL, E_INVAL, ERR);
	obj->elf.note.vaddr = vaddr;
	return (obj->elf.note.vaddr);
}

/*
 * vg_obj_note_get/set_size = get/set the note section size
 */
vg_size	vg_obj_note_get_size(vg_object *obj)
{
	if (!obj || !obj->elf.note.data)
		VGERR(VG_OBJ_NOTE_GET_SIZE, NULL, E_INVAL, ERR);
	return (obj->elf.note.size);
}

vg_size	vg_obj_note_set_size(vg_object *obj, vg_size size)
{
	if (!obj || !obj->elf.note.data)
		VGERR(VG_OBJ_NOTE_SET_SIZE, NULL, E_INVAL, ERR);
	obj->elf.note.size = size;
	return (obj->elf.note.size);
}

