/*

 [=-- LIBVG --=] Runtime Process Manipulation Library [=------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE AT YOUR OWN RISK

*/
#include "libvg.h"

extern  vg_proc *cur_proc;
extern	pid_t	cur_pid;

/*
 *      [I]     This func gets the address of main object link_map entry
 *
        There are two well known methods to get the first entry of link_maps
        or object descriptors list: we can get the correct address of the first
        link_map entry at got[2], this is on linux and bsd, and the second
        is get the r_debug struture, r_debug->r_map points at first entry,
        this is the easy way i found to get it on solaris.
*/
vg_vaddr	get_objdc_tbl(vg_proc *p, Elf32_Ehdr *hdr, Elf32_Phdr *phdr)
{
	Elf32_Dyn       dyn;
	vg_vaddr	dyn_addr = 0x0;
	vg_int		method = 0x0;
	struct r_debug  deb;

#if defined(sun)
	method = DT_DEBUG;
#else
	method = DT_PLTGOT;
#endif

        for(dyn_addr = phdr->p_vaddr; dyn.d_tag != method;
                                dyn_addr +=sizeof(Elf32_Dyn))
                vg_dread(&dyn, dyn_addr, sizeof(Elf32_Dyn));

        if (method == DT_PLTGOT) {
                if (vg_dread(&p->reflist_addr, (dyn.d_un.d_val + sizeof(Elf32_Word)),
                                sizeof(Elf32_Word)) != sizeof(Elf32_Word))
                        VGERR(0,0,0,0);
        }
        if (method == DT_DEBUG) {
                if (vg_dread(&deb, dyn.d_un.d_val, sizeof(struct r_debug)) !=
                                sizeof(struct r_debug))
                        VGERR(0,0,0,0);
                p->reflist_addr = (u_long)deb.r_map;
        }
        return (p->reflist_addr);
}

/*
 *	[I]	LOAD PROCESS'S OBJECTS DESCRIPTOR TABLE (ODT)
 */
vg_int	load_odt(vg_proc *p, Elf32_Ehdr *hdr, Elf32_Phdr *phdr)
{	
	vg_char		*soname[MAX_BUF];
#if defined(__OpenBSD__) || defined(__linux__) || defined(sun)
	lm_entry	rtld_entry;
#else
	bsd_obj_ref	fentry;
#endif
	vg_vaddr	vaddr;
	vg_int		idx = 0;

	if (!(vaddr = get_objdc_tbl(p, hdr, phdr)))
		VGERR(__LOAD_ODT, "Imposible get main object descriptor table", 0, ERR);

/* link_map based */
#if defined(__OpenBSD__) || defined(__linux__) || defined(sun)
	while (vaddr && idx<MAX_OBJECTS) {
	//	printf("mirando %d\n", idx);
 
		/* get objref (next link_map entry) */
		if (!(p->obj_desc_table[idx] = (vg_obj_desc*)malloc(sizeof(vg_obj_desc))))
			VGERR(__LOAD_ODT, INTERNAL_ERR, 0, ERR);

		memset(p->obj_desc_table[idx], 0, sizeof(vg_obj_desc));

		if (vg_dread(&rtld_entry, vaddr, sizeof(lm_entry)) 
				!= sizeof(lm_entry))	
			VGERR2(__LOAD_ODT, 0, 0, ERR, p->obj_desc_table[idx]);

		/* copy link_map to our object descriptor */
		p->obj_desc_table[idx]->od_idx = (vg_int)idx;
		p->obj_desc_table[idx]->od_base = (vg_vaddr)rtld_entry.l_addr;
		p->obj_desc_table[idx]->od_dyn = (vg_vaddr*)rtld_entry.l_ld;
		p->obj_desc_table[idx]->od_name = (vg_vaddr)rtld_entry.l_name;
		p->obj_desc_table[idx]->od_next = (void*)rtld_entry.l_next;
		p->obj_desc_table[idx]->od_prev = (void*)rtld_entry.l_prev;
		
		/* get soname string */
		memset(soname, 0, MAX_BUF+1);
		vg_dread(soname, p->obj_desc_table[idx]->od_name, MAX_BUF);
		if (!soname[0])
			memcpy(soname, "main",4);
		p->obj_desc_table[idx]->od_str = strdup((vg_char*)soname);

		/* in some cases first entry (main object) has addr = 0 so we 
		   can fix that with proc_base, incorrect entries that could be
		   found must be ignored by load_objlist() */
		if (!p->obj_desc_table[idx]->od_base) {
			if (!idx)	/* mo */
				p->obj_desc_table[0]->od_base = proc_base;
			else
				p->obj_desc_table[idx]->od_base = INCORRECT_ENTRY;
		}

/*
		printf("addr 0x%x, name [%s], ld 0x%x, next 0x%x, prev 0x%x\n",
		p->obj_desc_table[idx]->od_base, p->obj_desc_table[idx]->od_str,
		p->obj_desc_table[idx]->od_dyn, p->obj_desc_table[idx]->od_next, 
		p->obj_desc_table[idx]->od_prev);
*/
		++idx;
		vaddr = (u_long)rtld_entry.l_next;
	}

/* object descriptor based */
#elif defined(__FreeBSD__) || defined(__NetBSD__)
        while (vaddr) {
		if (!(p->obj_desc_table[idx] = (vg_obj_desc*)malloc(sizeof(vg_obj_desc))))
			VGERR(__LOAD_ODT, INTERNAL_ERR, 0, ERR);
		memset(p->obj_desc_table[idx], 0, sizeof(vg_obj_desc));
                if (vg_dread(&fentry, vaddr, sizeof(bsd_obj_ref))
					!= sizeof(bsd_obj_ref))
			VGERR2(__LOAD_ODT, 0, 0, ERR, p->obj_desc_table[idx]);

		p->obj_desc_table[idx]->od_idx = (vg_idx)idx;
		p->obj_desc_table[idx]->od_base = (vg_vaddr)fentry.mapbase;
		p->obj_desc_table[idx]->od_dyn = fentry.dynamic;
		p->obj_desc_table[idx]->od_name = fentry.path;		
		p->obj_desc_table[idx]->od_next = fentry.next;
		p->obj_desc_table[idx]->od_prev = 0x0;

                memset(soname, 0, MAX_BUF+1);
		vg_dread(soname, p->obj_desc_table[idx]->od_name, MAX_BUF);
		p->obj_desc_table[idx]->od_str = strdup((vg_char*)soname);

                ++idx;
                vaddr = (u_long)fentry.next;
        }
#endif
	return (OK);
}

/*
 *	[I]	UNLOAD PROCESS'S OBJECTS DESCRIPTOR TABLE
 */
vg_int	unload_odt(vg_proc *pctx)
{
	vg_idx idx = 0;
	/* exit if static, nothing to free */
	if (pctx->flags & PROC_WITHOUT_RTLD)
		return (OK);
	/* free elements */
	while(pctx->obj_desc_table[idx]) {
		free(pctx->obj_desc_table[idx]->od_str);
		free(pctx->obj_desc_table[idx]);
		++idx;
	}
	return (OK);
}






/* TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO 



 *WARNING* *WARNING* *WARNING* *WARNING* *WARNING* *WARNING*

 Under some systems as linux we can play with the objects
 descriptors and do evil things but it hasn't been tested. 
 The following functions are really inmatures so aren't part of 
 the API, them will be introduced on future versions.
 Use it carefully :)
 
 *WARNING* *WARNING* *WARNING* *WARNING* *WARNING* *WARNING*


*/
/*
 * vg_objd_by_name = get obj descr giving its name
 */
vg_obj_desc *vg_objd_by_name(vg_char *name)
{
	vg_idx idx = 0;
	CHECKDYN(0, NULL);
	/* check args */
	if (!name)
		VGERR(0, "Incorrect args", 0, NULL);
	/* check correct length */
	if (strlen(name)>MAX_BUF)
		VGERR(0, "Name too long",0,NULL);
	/* check each entry */
	while(cur_proc->obj_desc_table[idx]) {
		if (!strcmp(cur_proc->obj_desc_table[idx]->od_str, name))
			return (cur_proc->obj_desc_table[idx]);
		++idx;
	}

	VGERR(0, "Incorrect object name", 0, NULL);
}

/*
 * vg_objd_by_base = get obj descr giving the base address of the 
 * the object
 */
vg_obj_desc *vg_objd_by_base(vg_vaddr base)
{
	vg_int	idx = 0;
	CHECKDYN(0, NULL);
	if (!base)
		VGERR(0, "Incorrect args", 0, NULL);
	while(cur_proc->obj_desc_table[idx]) {
		if (cur_proc->obj_desc_table[idx]->od_base == base)
			return (cur_proc->obj_desc_table[idx]);
		++idx;
	}
	VGERR(0, "Incorrect object base addr", 0, NULL);
}

/*
 * vg_objd_by_dyn = get a obj descr giving the starting address of the 
 * dynamic section into the object
 */
vg_obj_desc	*vg_objd_by_dyn(vg_vaddr dyn)
{
	vg_int	idx = 0;
	CHECKDYN(0, NULL);
	while(cur_proc->obj_desc_table[idx]) {
		if (cur_proc->obj_desc_table[idx]->od_dyn == (vg_vaddr*)dyn)
			return (cur_proc->obj_desc_table[idx]);
		++idx;
	}
	return (NULL);
}

/*
 * vg_objd_by_idx =
 */
vg_obj_desc	*vg_objd_by_idx(vg_idx idx)
{
	CHECKDYN(0, NULL);
	if (idx<0 || idx>MAX_OBJ_DESC) 
		VGERR(0, "Incorrect args",0, NULL);
	if (!idx)
		return (cur_proc->obj_desc_table[0]);
	return (cur_proc->obj_desc_table[idx]);
}

/*
 * vg_objd_get/set_name = this get/set the object name
 */
vg_char	*vg_objd_get_name(vg_object *obj)
{
	CHECKDYN(0, NULL);
	if (!obj)
		VGERR(0, "Incorrect args", 0,NULL);
	return (obj->od->od_str);
}

vg_int	vg_objd_set_name(vg_object *obj, vg_char *name)
{
	CHECKDYN(0, ERR);
	if (!obj || !name)
		VGERR(0, "Incorrect args", 0, ERR);
	if (strlen(name)>MAX_BUF)
		VGERR(0, "Object name too long",0,ERR);
	if (obj->od->od_str)
		free(obj->od->od_str);
	obj->od->od_str = strdup(name);
	SETOBJDCH(cur_proc);
	return (OK);
}

/*
 * vg_objd_get_base = GET/SET OBJ_DESC->BASE
 */
vg_vaddr	vg_objd_get_base(vg_object *obj)
{
	CHECKDYN(0, ERR);
	if (!obj)
		VGERR(0, "Incorrect args", 0, ERR);
	return (obj->od->od_base);
}

vg_int	vg_objd_set_base(vg_object *obj, vg_vaddr base)
{
	CHECKDYN(0, ERR);
	if (!obj)
		VGERR(0, "Incorrect args", 0, ERR);
	obj->od->od_base = base;
	SETOBJDCH(cur_proc);
	return (OK);
}

/*
 * vg_objd_get/set_dyn = GET/SET OBJ_DESC->DYN
 */
vg_vaddr	vg_objd_get_dyn(vg_object *obj)
{
	CHECKDYN(0, ERR);
	if (!obj)
		VGERR(0, "Incorrect args",0, ERR);
	return ((vg_vaddr)obj->od->od_dyn);
}

vg_int	vg_objd_set_dyn(vg_object *obj, vg_vaddr dyn)
{
	CHECKDYN(0, ERR);
	if (!obj) 
		VGERR(0, "Incorrect args", 0,ERR);
	obj->od->od_dyn = (u_long*)dyn;
	SETOBJDCH(cur_proc);
	return (OK);
}

/*
 * vg_objd_get/set_idx = GET/SET OBJ_DESC->IDX
 */
vg_int	vg_objd_get_idx(vg_object *obj)
{
	CHECKDYN(0, ERR);
	if (!obj)
		VGERR(0, "Incorrect args", 0,ERR);
	return (obj->od->od_idx);
}

vg_int	vg_objd_set_idx(vg_object *obj, vg_idx idx)
{
	CHECKDYN(0, ERR);
	if (!obj || idx<0 || idx>MAX_OBJ_DESC)
		VGERR(0, "Incorrect args", 0,ERR);
	obj->od->od_idx = idx;
	SETOBJDCH(cur_proc);
	return (OK);
}

/*
 * vg_objd_get/set_next = GET/SET OBJ_DESC->NEXT
 */
vg_int	vg_objd_get_next(vg_object *obj)
{
	return (OK);
}

vg_int	vg_objd_set_next(vg_object *obj, vg_vaddr next)
{
	return (OK);
}

/*
 * vg_objd_get_prev = GET/SET OBJ_DESC->PREV
 */
vg_int	vg_objd_get_prev(vg_object *obj)
{
	return (OK);
}

vg_int	vg_objd_set_prev(vg_object *obj, vg_vaddr prev)
{
	return (OK);
}

/*
 * vg_objd_del_by_idx = DEL OBJECT DESCRIPTOR BY IDX
 */
vg_int	vg_objd_del_by_idx(vg_idx idx)
{
	CHECKDYN(0, ERR);

	if (cur_proc->obj_desc_table[idx])
		VGERR(0, "Incorrect args", 0,ERR);
	/* set new next and prev*/
	cur_proc->obj_desc_table[idx-1]->od_next = 
			cur_proc->obj_desc_table[idx]->od_next;
	if (cur_proc->obj_desc_table[idx+1])
		cur_proc->obj_desc_table[idx+1]->od_prev = 
			cur_proc->obj_desc_table[idx]->od_prev;
	SETOBJDCH(cur_proc);
	return (OK);
}

/*
 * vg_objd_del_by_name = DEL OBJECT DESCRIPTOR BY NAME
 */
vg_int	vg_objd_del_by_name(vg_char *name)
{
	vg_obj_desc	*desc;

	CHECKDYN(0, ERR);
	if (!name)
		VGERR(0, "Incorrect args", 0, ERR);
	/* get ref for name */	
	if (!(desc = vg_objd_by_name(name)))
		return (ERR);
	cur_proc->obj_desc_table[desc->od_idx-1]->od_next = 
			cur_proc->obj_desc_table[desc->od_idx]->od_next;
	if (cur_proc->obj_desc_table[desc->od_idx+1])
		cur_proc->obj_desc_table[desc->od_idx+1]->od_prev = 
			cur_proc->obj_desc_table[desc->od_idx]->od_prev;	
	SETOBJDCH(cur_proc);
	return (OK);
}

/*
 * vg_objd_del_by_base = DEL OBJECT DESCRIPTOR BY BASE
 */
vg_int	vg_objd_del_by_base(vg_vaddr base)
{
	vg_obj_desc	*desc;

	CHECKDYN(0, ERR);
	if (!base) 
		VGERR(0, "Incorrect args", 0, ERR);
	if (!(desc = vg_objd_by_base(base)))
		return (ERR);
	cur_proc->obj_desc_table[desc->od_idx-1]->od_next =
			cur_proc->obj_desc_table[desc->od_idx]->od_next;
	if (cur_proc->obj_desc_table[desc->od_idx+1])
		cur_proc->obj_desc_table[desc->od_idx+1]->od_prev =
			cur_proc->obj_desc_table[desc->od_idx]->od_prev;
	SETOBJDCH(cur_proc);
	return (OK);
}

/*
 * vg_objd_del_by_dyn = DEL OBJECT DESCRIPTOR BY DYNAMIC SECTION ADDR
 */
vg_int	vg_objd_del_by_dyn(vg_vaddr dyn)
{
	vg_obj_desc	*desc;

	CHECKDYN(0, ERR);
	if (!dyn)
		VGERR(0, "Incorrect args", 0, ERR);

	if (!(desc = vg_objd_by_dyn(dyn)))
		return (ERR);
	cur_proc->obj_desc_table[desc->od_idx-1]->od_next =
			cur_proc->obj_desc_table[desc->od_idx]->od_next;
	if (cur_proc->obj_desc_table[desc->od_idx+1])
		cur_proc->obj_desc_table[desc->od_idx+1]->od_prev =
			cur_proc->obj_desc_table[desc->od_idx]->od_prev;
	SETOBJDCH(cur_proc);
	return (OK);
}

/*
 * vg_del_objd = DEL OBJECT DESCRIPTOR
 */
vg_int	vg_del_objd(vg_obj_desc *desc)
{
	vg_obj_desc	*dc;

	CHECKDYN(0, ERR);
	if (!desc)
		VGERR(0, "Incorrect args", 0, ERR);

	/* in order to use a correct descriptor */
	if (!(dc = vg_objd_by_base(desc->od_base)))
		return (ERR);
	cur_proc->obj_desc_table[dc->od_idx-1]->od_next = 
			cur_proc->obj_desc_table[dc->od_idx]->od_next;
	cur_proc->obj_desc_table[dc->od_idx+1]->od_prev = 
			cur_proc->obj_desc_table[dc->od_idx]->od_prev;
	SETOBJDCH(cur_proc);
	return (OK);
}

