/*

 [=-- LIBVG --=] Runtime Process Manipulation Library [=------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE AT YOUR OWN RISK

*/
#include "libvg.h"

/*
 * vg_obj_get_phdr = load program header table
 */	
Elf32_Phdr *vg_obj_get_phdr(vg_object *obj, vg_uint *entnum)
{
	if (!obj) 
		VGERR(VG_OBJ_GET_PHDR, NULL, E_INVAL, NULL);

	if (obj->elf.phdr.data)
		goto end;

	if (!vg_obj_get_hdr(obj))
		return (NULL);

	obj->elf.phdr.entsize = sizeof(Elf32_Phdr);
	obj->elf.phdr.size = obj->elf.hdr.data->e_phnum * obj->elf.phdr.entsize;

	if (OBJ_IS_MAPPED(obj)) {
		obj->elf.phdr.data = (Elf32_Phdr*)((vg_char*)obj->text.ptr +
						 obj->elf.hdr.data->e_phoff);
	}
	else { 
		/* resevar mem */
		S_ALLOC(obj->elf.phdr.data, obj->elf.phdr.size, NULL, 
						VG_OBJ_GET_PHDR, CLEAN);
		/* copiar */
                if (vg_dread((Elf32_Phdr*)obj->elf.phdr.data, 
			(obj->text.start + obj->elf.hdr.data->e_phoff),
				obj->elf.phdr.size) != obj->elf.phdr.size)
			VGERR2(VG_OBJ_GET_PHDR, 0, 0, NULL, obj->elf.phdr.data);
	}
	obj->elf.phdr.vaddr = obj->text.start + obj->elf.hdr.data->e_phoff;
	obj->elf.phdr.offset = obj->elf.hdr.data->e_phoff;
	obj->elf.phdr.entnum = obj->elf.hdr.data->e_phnum;
end:
	if (entnum)
		*entnum = obj->elf.phdr.entnum;
	return (obj->elf.phdr.data);
}


/*
 * vg_obj_phdr_get/set_vaddr = 
 */
vg_vaddr vg_obj_phdr_get_vaddr(vg_object *obj)
{
	if (!obj || !obj->elf.phdr.data)
		VGERR(VG_OBJ_PHDR_GET_VADDR, NULL, E_INVAL, ERR);
	return (obj->elf.phdr.vaddr);
}

vg_vaddr vg_obj_phdr_set_vaddr(vg_object *obj, vg_vaddr vaddr)
{
	if (!obj || !obj->elf.phdr.data)
		VGERR(VG_OBJ_PHDR_SET_VADDR, NULL, E_INVAL, ERR);
	obj->elf.phdr.vaddr = vaddr;
	return (obj->elf.phdr.vaddr);
}

/*	
 * vg_obj_pdr_get/set_size = 
 */
vg_size	vg_obj_phdr_get_size(vg_object *obj)
{
	if (!obj || !obj->elf.phdr.data)
		VGERR(VG_OBJ_PHDR_GET_SIZE, NULL, E_INVAL, ERR);
	return (obj->elf.phdr.size);
}

vg_size	vg_obj_phdr_set_size(vg_object *obj, vg_size size)
{
	if (!obj || !obj->elf.phdr.data) 
		VGERR(VG_OBJ_PHDR_SET_SIZE, NULL, E_INVAL, ERR);
	obj->elf.phdr.size = size;
	return (obj->elf.phdr.size);
}

/*
 * vg_obj_phdr_get/set_offset = 
 */
vg_off	vg_obj_phdr_get_offset(vg_object *obj)
{
	if (!obj || !obj->elf.phdr.data)
		VGERR(VG_OBJ_PHDR_GET_OFFSET, NULL, E_INVAL, ERR);
	return (obj->elf.phdr.offset);
}
	
vg_off	vg_obj_phdr_set_offset(vg_object *obj, vg_off offset)
{
	if (!obj || !obj->elf.phdr.data)
		VGERR(VG_OBJ_PHDR_SET_OFFSET, NULL, E_INVAL, ERR);
	obj->elf.phdr.offset = offset;
	return (obj->elf.phdr.offset);
}

/*
 * vg_obj_phdr_get/set_entsize = 
 */
vg_size	vg_obj_phdr_get_entsize(vg_object *obj)
{
	if (!obj || !obj->elf.phdr.data)
		VGERR(VG_OBJ_PHDR_GET_ENTSIZE, NULL, E_INVAL, ERR);
	return (obj->elf.phdr.entsize);
}

vg_size	vg_obj_phdr_set_entsize(vg_object *obj, vg_size entsize)
{
	if (!obj || !obj->elf.phdr.data)
		VGERR(VG_OBJ_PHDR_SET_ENTSIZE, NULL, E_INVAL, ERR);
	obj->elf.phdr.entsize = entsize;
	return (obj->elf.phdr.entsize);
}

/*
 * vg_obj_phdr_get/set_entnum = 
 */
vg_idx	vg_obj_phdr_get_entnum(vg_object *obj)
{
	if (!obj || !obj->elf.phdr.data)
		VGERR(VG_OBJ_PHDR_GET_ENTNUM, NULL, E_INVAL, ERR);
	return (obj->elf.phdr.entnum);
}

vg_idx	vg_obj_phdr_set_entnum(vg_object *obj, vg_idx entnum)
{
	if (!obj || !obj->elf.phdr.data)
		VGERR(VG_OBJ_PHDR_SET_ENTNUM, NULL, E_INVAL, ERR);
	obj->elf.phdr.entnum = entnum;
	return (obj->elf.phdr.entnum);
}

/*
 * vg_obj_phentry_by_idx = return an entry giving its index into 
 * the program header table
 */
Elf32_Phdr *vg_obj_phentry_by_idx(vg_object *obj, vg_idx idx)
{
	if (!obj || (idx<0 || idx>obj->elf.hdr.data->e_phnum)) 
		VGERR(VG_OBJ_PHENTRY_BY_IDX, NULL, E_INVAL, NULL);

	if (!vg_obj_get_phdr(obj, 0))
		return (NULL);

	return ((idx? obj->elf.phdr.data+idx: obj->elf.phdr.data));
}

/*
 * vg_obj_phentry_by_type = return an entry giving its type
 */
Elf32_Phdr *vg_obj_phentry_by_type(vg_object *obj, vg_uint type, vg_idx entidx)
{
	Elf32_Phdr *p;

	if (!obj || (entidx<0))
		VGERR(VG_OBJ_PHENTRY_BY_TYPE, NULL, E_INVAL, NULL);

	if (!(p = vg_obj_get_phdr(obj, 0)))
		return (NULL);

	for(; p->p_type != PT_NULL; p++) {
		if (p->p_type == type) {
			entidx -= (entidx?1:0);
			if (!entidx)
				return (p);
		}
	}

	return (NULL);	
}

/*
 * vg_obj_phentry_by_offset = return an entry giving its offset 
 */
Elf32_Phdr *vg_obj_phentry_by_offset(vg_object *obj, vg_off offset, vg_idx entidx)
{
	Elf32_Phdr *p;

	if (!obj)
		VGERR(VG_OBJ_PHENTRY_BY_OFFSET, NULL, E_INVAL, NULL);

	if (!(p = vg_obj_get_phdr(obj, 0)))
		return (NULL);

	for(; p->p_type != PT_NULL; p++) {
		if (p->p_offset == offset) {
			entidx -= (entidx?1:0);
			if (!entidx)
				return (p);
		}
	}

	return (NULL);
}

/* 
 * vg_obj_phentry_by_vaddr = return an entry giving its starting address at
 * memory
 */
Elf32_Phdr *vg_obj_phentry_by_vaddr(vg_object *obj, vg_vaddr vaddr, vg_idx entidx)
{
	Elf32_Phdr *p;

	if (!obj)
		VGERR(VG_OBJ_PHENTRY_BY_VADDR, NULL, E_INVAL, NULL);

	if (!(p = vg_obj_get_phdr(obj,0)))
		return (NULL);

	for(; p->p_type != PT_NULL; p++) {
		if (p->p_vaddr == vaddr) {
			entidx -= (entidx?1:0);
			if (!entidx)
				return (p);
		}
	}

	return (NULL);
}

/*
 * vg_obj_phentry_by_memsz = return an entry giving its size in memory
 */
Elf32_Phdr *vg_obj_phentry_by_memsz(vg_object *obj, vg_size memsz, vg_idx entidx)
{
	Elf32_Phdr *p;

	if (!obj)
		VGERR(VG_OBJ_PHENTRY_BY_MEMSZ, NULL, E_INVAL, NULL);

	if (!(p = vg_obj_get_phdr(obj,0)))
		return (NULL);

	for(; p->p_type != PT_NULL; p++) {
		if (p->p_memsz == memsz) {
			entidx -= (entidx?1:0);
			if (!entidx)
				return (p);
		}
	}

	return (NULL);
}

/*  
 * vg_obj_phentry_by_filesz = return an entry giving its size in file
 */
Elf32_Phdr *vg_obj_phentry_by_filesz(vg_object *obj, vg_size filesz, vg_idx entidx)
{
	Elf32_Phdr *p;

	if (!obj)
		VGERR(VG_OBJ_PHENTRY_BY_FILESZ, NULL, E_INVAL, NULL);

	if (!(p = vg_obj_get_phdr(obj,0)))
		return (NULL);

	for(; p->p_type != PT_NULL; p++) {
		if (p->p_filesz == filesz) {
			entidx -= (entidx?1:0);
			if (!entidx)
				return (p);
		}
	}

	return (NULL);
}


/*
 *  vg_obj_phentry_get/set_type = return/change the type of a program header
 */
Elf32_Word vg_obj_phentry_get_type(vg_object *obj, Elf32_Phdr *phdr)
{
	if (!obj || !obj->elf.phdr.data || !phdr)
		VGERR(VG_OBJ_PHENTRY_GET_TYPE, NULL, E_INVAL, ERR);
	return (phdr->p_type);
}

Elf32_Word vg_obj_phentry_set_type(vg_object *obj, Elf32_Phdr *phdr, Elf32_Word type)
{
	if (!obj || !obj->elf.phdr.data || !phdr)
		VGERR(VG_OBJ_PHENTRY_SET_TYPE, NULL, E_INVAL, ERR);
	phdr->p_type = type;
	SETOBJCH(obj);
	return (phdr->p_type);
}

/*	
 * vg_obj_phentry_get/set_offset = return/change the offset of a program header
 */
Elf32_Off vg_obj_phentry_get_offset(vg_object *obj, Elf32_Phdr *phdr)
{
	if (!obj || !obj->elf.phdr.data || !phdr)
		VGERR(VG_OBJ_PHENTRY_GET_OFFSET, NULL, E_INVAL, ERR);
	return (phdr->p_offset);
}

Elf32_Off vg_obj_phentry_set_offset(vg_object *obj, Elf32_Phdr *phdr, Elf32_Off offset)
{
	if (!obj || !obj->elf.phdr.data || !phdr)
		VGERR(VG_OBJ_PHENTRY_SET_OFFSET, NULL, E_INVAL, ERR);
	phdr->p_offset = offset;
	SETOBJCH(obj);
	return (phdr->p_offset);
}

/*
 * vg_obj_phentry_get/set_vaddr = return/change the virtual address of a
 * program header
 */
Elf32_Addr vg_obj_phentry_get_vaddr(vg_object *obj, Elf32_Phdr *phdr)
{
	if (!obj || !obj->elf.phdr.data || !phdr)
		VGERR(VG_OBJ_PHENTRY_GET_VADDR, NULL, E_INVAL, ERR);
	return (phdr->p_vaddr);
}

Elf32_Addr vg_obj_phentry_set_vaddr(vg_object *obj, Elf32_Phdr *phdr, Elf32_Addr vaddr)
{
	if (!obj || !obj->elf.phdr.data || !phdr)
		VGERR(VG_OBJ_PHENTRY_SET_VADDR, NULL, E_INVAL, ERR);
	phdr->p_vaddr = vaddr;
	SETOBJCH(obj);
	return (phdr->p_vaddr);
}

/*
 * vg_obj_phentry_get/set_paddr = return/change the physical address of
 * a program header
 */
Elf32_Addr vg_obj_phentry_get_paddr(vg_object *obj, Elf32_Phdr *phdr)
{
	if (!obj || !obj->elf.phdr.data || !phdr)
		VGERR(VG_OBJ_PHENTRY_GET_PADDR, NULL, E_INVAL, ERR);
	return (phdr->p_paddr);
}

Elf32_Addr vg_obj_phentry_set_paddr(vg_object *obj, Elf32_Phdr *phdr, Elf32_Addr paddr)
{
	if (!obj || !obj->elf.phdr.data || !phdr)
		VGERR(VG_OBJ_PHENTRY_SET_PADDR, NULL, E_INVAL, ERR);
	phdr->p_paddr = paddr;
	SETOBJCH(obj);
	return (phdr->p_paddr);
}

/*
 * vg_obj_phentry_get/set_filesz = return/change the size in file of a program
 * header
 */
Elf32_Word vg_obj_phentry_get_filesz(vg_object *obj, Elf32_Phdr *phdr)
{
	if (!obj || !obj->elf.phdr.data || !phdr)
		VGERR(VG_OBJ_PHENTRY_GET_FILESZ, NULL, E_INVAL, ERR);
	return (phdr->p_filesz);
}

Elf32_Word vg_obj_phentry_set_filesz(vg_object *obj, Elf32_Phdr *phdr, Elf32_Word filesz)
{
	if (!obj || !obj->elf.phdr.data || !phdr)
		VGERR(VG_OBJ_PHENTRY_SET_FILESZ, NULL, E_INVAL, ERR);
	phdr->p_filesz = filesz;
	SETOBJCH(obj);
	return (phdr->p_filesz);
}

/*
 * vg_obj_phentry_get/set_memsz = return/change the size in memory of a program
 * header
 */
Elf32_Word vg_obj_phentry_get_memsz(vg_object *obj, Elf32_Phdr *phdr)
{
	if (!obj || !obj->elf.phdr.data || !phdr)
		VGERR(VG_OBJ_PHENTRY_GET_MEMSZ, NULL, E_INVAL, ERR);
	return (phdr->p_memsz);
}

Elf32_Word vg_obj_phentry_set_memsz(vg_object *obj, Elf32_Phdr *phdr, Elf32_Word memsz)
{
	if (!obj || !obj->elf.phdr.data || !phdr)
		VGERR(VG_OBJ_PHENTRY_SET_MEMSZ, NULL, E_INVAL, ERR);
	phdr->p_memsz = memsz;
	SETOBJCH(obj);
	return (phdr->p_memsz);
}

/*
 * vg_obj_phentry_get/set_flags = return/change the flags of a program header
 */
Elf32_Word vg_obj_phentry_get_flags(vg_object *obj, Elf32_Phdr *phdr)
{
	if (!obj || !obj->elf.phdr.data || !phdr)
		VGERR(VG_OBJ_PHENTRY_GET_FLAGS, NULL, E_INVAL, ERR);
	return (phdr->p_flags);
}

Elf32_Word vg_obj_phentry_set_flags(vg_object *obj, Elf32_Phdr *phdr, Elf32_Word flags)
{
	if (!obj || !obj->elf.phdr.data || !phdr)
		VGERR(VG_OBJ_PHENTRY_SET_FLAGS, NULL, E_INVAL, ERR);
	phdr->p_flags = flags;
	SETOBJCH(obj);
	return (phdr->p_flags);
}

/*
 * vg_obj_phentry_get/set_align = return/change the alignment of a program
 * header
 */
Elf32_Word vg_obj_phentry_get_align(vg_object *obj, Elf32_Phdr *phdr)
{
	if (!obj || !obj->elf.phdr.data || !phdr)
		VGERR(VG_OBJ_PHENTRY_GET_ALIGN, NULL, E_INVAL, ERR);
	return (phdr->p_align);
}

Elf32_Word vg_obj_phentry_set_align(vg_object *obj, Elf32_Phdr *phdr, Elf32_Word align)
{
	if (!obj || !obj->elf.phdr.data || !phdr)
		VGERR(VG_OBJ_PHENTRY_SET_ALIGN, NULL, E_INVAL, ERR);
	phdr->p_align = align;
	SETOBJCH(obj);
	return (phdr->p_align);
}

