/*

 [=-- LIBVG --=] Runtime Process Manipulation Library [=------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE AT YOUR OWN RISK

*/
#include "libvg.h"

#if defined(__i386__)
#define	PLT_ENTRY_SIZE	16
#endif

vg_int	try_with_dynsym(vg_object *obj)
{
	Elf32_Sym	*s1, *s2;
	vg_idx		idx;

	for (idx = 0; idx < vg_obj_dynsym_get_entnum(obj); idx++) {
		if ((s1 = vg_obj_dsym_by_idx(obj, idx)) && s1->st_value &&
			ELF32_ST_TYPE(s1->st_info) == STT_FUNC) {	

			if ((s2 = vg_obj_dsym_by_idx(obj, idx+1)) && s1->st_value &&
				ELF32_ST_TYPE(s1->st_info) == STT_FUNC)
				obj->elf.plt.entsize = vg_obj_dsym_get_value(obj, s2)-
							vg_obj_dsym_get_value(obj, s1);
			else
				obj->elf.plt.entsize = PLT_ENTRY_SIZE;
			
			obj->elf.plt.size = vg_obj_relplt_get_entnum(obj)*obj->elf.plt.entsize;
			obj->elf.plt.vaddr = vg_obj_dsym_get_value(obj, s1)-(obj->elf.plt.entsize * idx);
			obj->elf.plt.entnum = vg_obj_relplt_get_entnum(obj);
			obj->elf.plt.offset = obj->elf.plt.vaddr-obj->text.start;

			return (OK);
		}
	}
	return (ERR);
}

vg_int	try_with_got(vg_object *obj)
{
	vg_gotentry	gentry;
	vg_idx		idx;

	for (idx = 0; idx < vg_obj_relplt_get_entnum(obj); idx++) {

		vg_obj_gentry_by_idx(obj, idx+3, &gentry);

		SET_OBJECT_VADDR(gentry.vaddr, obj);

		if (gentry.value>vg_obj_get_text_start(obj)&&gentry.value<vg_obj_get_text_end(obj)) {
	
			obj->elf.plt.entsize = PLT_ENTRY_SIZE;
			obj->elf.plt.size = vg_obj_relplt_get_entnum(obj)*obj->elf.plt.entsize;
			obj->elf.plt.entnum = vg_obj_relplt_get_entnum(obj);
			obj->elf.plt.vaddr = gentry.value - 0x6;
			obj->elf.plt.offset = obj->elf.plt.vaddr - obj->text.start;

			return (0);
		}
	}
	return (ERR);
}

vg_int	search_plt(vg_object *obj)
{
	/*
	  severeal methods:
		  a) main object   = dynsym/got
		  b) shared object = got

		gcc/libc or sthing has changed
		and all dynsym entries on main object
		has st_value = 0 instead of  
		st_value = plt_entry, pff..	
	*/
	if (OBJ_IS_MO(obj))
		if (!try_with_dynsym(obj))
			return (0);

	if (!try_with_got(obj))
		return (0);

	return (ERR);
}

/*
 * vg_obj_get_plt = load procedure linkage table
 */
vg_char *vg_obj_get_plt(vg_object *obj, vg_idx *entnum)
{
	CHECKDYN(VG_OBJ_GET_PLT, NULL);
	if (!obj)
		VGERR(VG_OBJ_GET_PLT, NULL, E_INVAL, NULL);

	if (obj->elf.plt.data)
		goto end;

	if (!vg_obj_get_relplt(obj, NULL))
		return (NULL);

	if (!vg_obj_get_dynsym(obj, NULL))
		return (NULL);

	if (!vg_obj_get_got(obj, NULL))
		return (NULL);

	/* find plt init can be a hard work */
	if (search_plt(obj)<0)
		VGERR(VG_OBJ_GET_PLT, "PLT section not found", 0, NULL);

	if (OBJ_IS_MAPPED(obj)) {
		obj->elf.plt.data = (vg_char*)RTOL((vg_vaddr)obj->elf.plt.vaddr, obj);
	}
	else {
		S_ALLOC(obj->elf.plt.data, obj->elf.plt.size, NULL, VG_OBJ_GET_PLT, CLEAN);	
		if (vg_dread(obj->elf.plt.data, obj->elf.plt.vaddr, 
				obj->elf.plt.size) != obj->elf.plt.size)
			VGERR2(VG_OBJ_GET_PLT,0,0, NULL, obj->elf.plt.data);
	}
end:
	if (entnum)
		*entnum = obj->elf.plt.entnum;
	return (obj->elf.plt.data);
}


/*
 * vg_obj_plt_get/set_vaddr = 
 */
vg_vaddr vg_obj_plt_get_vaddr(vg_object *obj)
{
	CHECKDYN(VG_OBJ_PLT_GET_VADDR, ERR);
	if (!obj || !obj->elf.plt.data)
		VGERR(VG_OBJ_PLT_GET_VADDR, NULL, E_INVAL, ERR);
	return (obj->elf.plt.vaddr);
}

vg_vaddr vg_obj_plt_set_vaddr(vg_object *obj, vg_vaddr vaddr)
{
	CHECKDYN(VG_OBJ_PLT_SET_VADDR, ERR);
	if (!obj || !obj->elf.plt.data)
		VGERR(VG_OBJ_PLT_SET_VADDR, NULL, E_INVAL, ERR);
	obj->elf.plt.vaddr = vaddr;
	return (obj->elf.plt.vaddr);
}

/*
 * vg_obj_plt_get/set_offset = 
 */
vg_off	vg_obj_plt_get_offset(vg_object *obj)
{
	CHECKDYN(VG_OBJ_PLT_GET_OFFSET, ERR);
	if (!obj || !obj->elf.plt.data)
		VGERR(VG_OBJ_PLT_GET_OFFSET, NULL, E_INVAL, ERR);
	return (obj->elf.plt.offset);
}

vg_off	vg_obj_plt_set_offset(vg_object *obj, vg_off offset)
{
	CHECKDYN(VG_OBJ_PLT_SET_OFFSET, ERR);
	if (!obj || !obj->elf.plt.data)
		VGERR(VG_OBJ_PLT_SET_OFFSET, NULL, E_INVAL, ERR);
	obj->elf.plt.offset = offset;
	return (obj->elf.plt.offset);
}

/*
 * vg_obj_plt_get/set_size = 
 */
vg_size	vg_obj_plt_get_size(vg_object *obj)
{
	CHECKDYN(VG_OBJ_PLT_GET_SIZE, ERR);
	if (!obj || !obj->elf.plt.data)
		VGERR(VG_OBJ_PLT_GET_SIZE, NULL, E_INVAL, ERR);
	return (obj->elf.plt.size);
}

vg_size	vg_obj_plt_set_size(vg_object *obj, vg_size size)
{
	CHECKDYN(VG_OBJ_PLT_SET_SIZE, ERR);
	if (!obj || !obj->elf.plt.data)
		VGERR(VG_OBJ_PLT_SET_SIZE, NULL, E_INVAL, ERR);
	obj->elf.plt.size = size;
	return (obj->elf.plt.size);
}

/*
 * vg_obj_plt_get/set_entsize = 
 */
vg_size	vg_obj_plt_get_entsize(vg_object *obj)
{
	CHECKDYN(VG_OBJ_PLT_GET_ENTSIZE, ERR);
	if (!obj || !obj->elf.plt.data)
		VGERR(VG_OBJ_PLT_GET_ENTSIZE, NULL, E_INVAL, ERR);
	return (obj->elf.plt.entsize);
}

vg_size	vg_obj_plt_set_entsize(vg_object *obj, vg_size entsize)
{
	CHECKDYN(VG_OBJ_PLT_SET_ENTSIZE, ERR);
	if (!obj || !obj->elf.plt.data)
		VGERR(VG_OBJ_PLT_SET_ENTSIZE, NULL, E_INVAL, ERR);
	obj->elf.plt.entsize = entsize;
	return (obj->elf.plt.entsize);
}

/*
 * vg_obj_plt_get/set_entnum = 
 */
vg_idx	vg_obj_plt_get_entnum(vg_object *obj)
{
	CHECKDYN(VG_OBJ_PLT_GET_ENTNUM, ERR);
	if (!obj || !obj->elf.plt.data)
		VGERR(VG_OBJ_PLT_GET_ENTNUM, NULL, E_INVAL, ERR);
	return (obj->elf.plt.entnum);
}

vg_idx	vg_obj_plt_set_entnum(vg_object *obj, vg_idx entnum)
{
	CHECKDYN(VG_OBJ_PLT_SET_ENTNUM, ERR);
	if (!obj || !obj->elf.plt.data)
		VGERR(VG_OBJ_PLT_SET_ENTNUM, NULL, E_INVAL, ERR);
	obj->elf.plt.entnum = entnum;
	return (obj->elf.plt.entnum);
}


/*
 * NOTE:
 *
 * VG_pltentry structure and the rest of plt functions
 * will be added on version 0.4, be patience :)
 *
 */


