/*

 [=-- LIBVG --=] Runtime Process Manipulation Library [=------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE AT YOUR OWN RISK

*/
#include "libvg.h"

extern  vg_proc *cur_proc;

#if defined(__linux__) || defined(__BSD__)

char	sc_hook[]=
	"\xb8\x00\x00\x00\x0a"
	"\xff\xe0"
	"\xc9\xc3"
	"\x90\x90\x90";

#define SC_HOOK_SIZE	0xc
#define SC_HOOK_ARG1	0x1

#elif defined(sun)

char	sc_hook[]="";

#define SC_HOOK_SIZE	0x0
#define SC_HOOK_ARG1	0x0

#endif


/*	
 * vg_set_hook = insert a hook into a given virtual address
 */
vg_int	vg_set_hook(vg_vaddr from, vg_vaddr to)
{	
	if (!from || !to)
		VGERR(VG_SET_HOOK, NULL, E_INVAL, ERR);

	/* patch the hook shellcode with "to" */
	PATCH_SC(sc_hook, SC_HOOK_ARG1, to, 0);

	/* insert patched hook code into "from" */
	if (vg_write(sc_hook, from, SC_HOOK_SIZE) != SC_HOOK_SIZE)
		return (ERR);

	return (OK);
}

/*
 * vg_redir_s2s_by_hook = redirect a local function to another
 * using a simple hook (sym to sym). vg_set_hook wrapper A
 * 
 * @from: source symbol name
 * @to: destination symbol name
 */
vg_int	vg_redir_s2s_by_hook(vg_char *from, vg_char *to)
{
	vg_sym	s1, s2;

	if (!from || !to)
		VGERR(VG_REDIR_S2S_BY_HOOK, NULL, E_INVAL, ERR);

	if (vg_sym_func_local_by_name(0, &s1, from)<0)
		VGERR(VG_REDIR_S2S_BY_HOOK, "Function not found", 0, ERR);

	if (vg_sym_func_local_by_name(0, &s2, to)<0)
		VGERR(VG_REDIR_S2S_BY_HOOK, "Function not found", 0, ERR);

	return (vg_set_hook(s1.vaddr, s2.vaddr));
}

/*
 * vg_redir_s2v_by_hook = redirect a local function to a virtual address
 * using a hook (sym to vaddr). vg_set_hook wrapper B
 *
 * @from: source symbol name
 * @to: destination virtual address
 */
vg_int	vg_redir_s2v_by_hook(vg_char *from, vg_vaddr to)
{
	vg_sym	s1;

	if (!from || !to)
		VGERR(VG_REDIR_S2V_BY_HOOK, NULL, E_INVAL, ERR);

	if (vg_sym_func_local_by_name(0, &s1, from)<0)
		VGERR(VG_REDIR_S2V_BY_HOOK, "Function not found", 0, ERR); 
	
	return (vg_set_hook(s1.vaddr, to));
}	


/*
 * vg_redir_s2s_by_relplt = redirect a global symbol of the object given 
 * to a local symbol changing its global offset table entry (sym to sym)
 *
 * @obj: an object
 * @from: a global function name of @obj
 * @to: a local function name
 */
vg_int	vg_redir_s2s_by_relplt(vg_object *obj, vg_char *from, vg_char *to)
{
	vg_gotentry	gentry;
	vg_sym		s1;

	if (!obj || !from || !to)
		VGERR(VG_REDIR_S2S_BY_RELPLT, NULL, E_INVAL, ERR);

	if (vg_sym_func_local_by_name(0, &s1, to)<0)
		VGERR(VG_REDIR_S2S_BY_RELPLT, "Function not found", 0, ERR);

	if (vg_obj_gentry_by_sym(obj, from, &gentry)<0)
		return (ERR);

	return (vg_write(&s1.vaddr, gentry.vaddr, sizeof(vg_vaddr)));
}

/*
 * vg_redir_s2v_by_relplt = redirect a global symbol of an object given
 * to a virtual address changing its got entry (sym to vaddr)
 */
vg_int	vg_redir_s2v_by_relplt(vg_object *obj, vg_char *from, vg_vaddr to)
{
	vg_gotentry	gentry;

	if (!obj || !from || !to)
		VGERR(VG_REDIR_S2V_BY_RELPLT, NULL, E_INVAL, ERR);	

	if (vg_obj_gentry_by_sym(obj, from, &gentry)<0) 
		return (ERR);

	return (vg_write(&to, gentry.vaddr, sizeof(vg_vaddr)));
}

