/*

 [=-- LIBVG --=] Runtime Process Manipulation Library [=------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE AT YOUR OWN RISK

*/
#include "libvg.h"

/*
 * vg_obj_get_reldyn = load reldyn section
 */
Elf32_Rel *vg_obj_get_reldyn(vg_object *obj, vg_uint *entnum)
{
	Elf32_Dyn	*reldyn, *relsz;

	CHECKDYN(VG_OBJ_GET_RELDYN, NULL);
	/* check args */
	if (!obj)
		VGERR(VG_OBJ_GET_RELDYN, NULL, E_INVAL, NULL);

	/* check previous */
	if (obj->elf.reldyn.data)
		goto end;
	
	/* get dynamic if not set */
	if (!vg_obj_get_dyn(obj, NULL))
		return (NULL);

	/* get size and vaddr/offset */
	if (!(reldyn = vg_obj_dentry_by_type(obj, DT_REL, 0)))
		VGERR(VG_OBJ_GET_RELDYN, "rel.dyn table not found", 0, NULL);
	if (!(relsz = vg_obj_dentry_by_type(obj, DT_RELSZ, 0)))
		VGERR(VG_OBJ_GET_RELDYN, "rel.dyn table size not found", 0, NULL);

	/* check if offset => offset + base */
	SET_OBJECT_VADDR(reldyn->d_un.d_ptr, obj);

	/* check segment */
	if (OBJ_IS_MAPPED(obj)) {
		obj->elf.reldyn.data = (Elf32_Rel*)RTOL((u_long)reldyn->d_un.d_ptr, obj);
	}
	else {	
		S_ALLOC(obj->elf.reldyn.data, relsz->d_un.d_ptr, NULL, 
						VG_OBJ_GET_RELDYN, CLEAN);
		if (vg_dread(obj->elf.reldyn.data, reldyn->d_un.d_ptr,
				 relsz->d_un.d_ptr) != relsz->d_un.d_ptr)
			VGERR2(VG_OBJ_GET_RELDYN, 0, 0, NULL, obj->elf.reldyn.data);
	}

	obj->elf.reldyn.size = relsz->d_un.d_ptr;
	obj->elf.reldyn.vaddr = reldyn->d_un.d_ptr;
	obj->elf.reldyn.offset = obj->elf.reldyn.vaddr - obj->text.start;
	obj->elf.reldyn.entsize = sizeof(Elf32_Rel);
	obj->elf.reldyn.entnum = obj->elf.reldyn.size / obj->elf.reldyn.entsize;
end:
	if (entnum)
		*entnum = obj->elf.reldyn.entnum;
	return (obj->elf.reldyn.data);
}

/*
 * vg_obj_reldyn_get/set_vaddr = 
 */
vg_vaddr vg_obj_reldyn_get_vaddr(vg_object *obj)
{
	CHECKDYN(VG_OBJ_RELDYN_GET_VADDR, ERR);
	if (!obj || !obj->elf.reldyn.data)
		VGERR(VG_OBJ_RELDYN_GET_VADDR, NULL, E_INVAL, ERR);	
	return (obj->elf.reldyn.vaddr);
}

vg_vaddr vg_obj_reldyn_set_vaddr(vg_object *obj, vg_vaddr vaddr)
{
	CHECKDYN(VG_OBJ_RELDYN_SET_VADDR, ERR);
	if (!obj || !obj->elf.reldyn.data)
		VGERR(VG_OBJ_RELDYN_SET_VADDR, NULL, E_INVAL, ERR);
	obj->elf.reldyn.vaddr = vaddr;
	return (obj->elf.reldyn.vaddr);
}
 
/*
 * vg_obj_reldyn_get/set_size = 
 */
vg_size	vg_obj_reldyn_get_size(vg_object *obj)
{
	CHECKDYN(VG_OBJ_RELDYN_GET_SIZE, ERR);
	if (!obj || !obj->elf.reldyn.data)
		VGERR(VG_OBJ_RELDYN_GET_SIZE, NULL, E_INVAL, ERR);
	return (obj->elf.reldyn.size);
}

vg_size	vg_obj_reldyn_set_size(vg_object *obj, vg_size size)
{
	CHECKDYN(VG_OBJ_RELDYN_SET_SIZE, ERR);
	if (!obj || !obj->elf.reldyn.data)
		VGERR(VG_OBJ_RELDYN_SET_SIZE, NULL, E_INVAL, ERR);
	obj->elf.reldyn.size = size;
	return (obj->elf.reldyn.size);
}

/*
 * vg_obj_reldyn_get/set_offset = 
 */
vg_off	vg_obj_reldyn_get_offset(vg_object *obj)
{
	CHECKDYN(VG_OBJ_RELDYN_GET_OFFSET, ERR);
	if (!obj || !obj->elf.reldyn.data)
		VGERR(VG_OBJ_RELDYN_GET_OFFSET, NULL, E_INVAL, ERR);
	return (obj->elf.reldyn.offset);
}

vg_off	vg_obj_reldyn_set_offset(vg_object *obj, vg_off offset)
{
	CHECKDYN(VG_OBJ_RELDYN_SET_OFFSET, ERR);
	if (!obj || !obj->elf.reldyn.data)
		VGERR(VG_OBJ_RELDYN_SET_OFFSET, NULL, E_INVAL, ERR);
	obj->elf.reldyn.offset = offset;
	return (obj->elf.reldyn.offset);
}

/*
 * vg_obj_reldyn_get/set/entsize = 
 */
vg_size	vg_obj_reldyn_get_entsize(vg_object *obj)
{
	CHECKDYN(VG_OBJ_RELDYN_GET_ENTSIZE, ERR);
	if (!obj || !obj->elf.reldyn.data)
		VGERR(VG_OBJ_RELDYN_GET_ENTSIZE, NULL, E_INVAL, ERR);
	return (obj->elf.reldyn.entsize);
}

vg_size	vg_obj_reldyn_set_entsize(vg_object *obj, vg_size entsize)
{
	CHECKDYN(VG_OBJ_RELDYN_SET_ENTSIZE, ERR);
	if (!obj || !obj->elf.reldyn.data)
		VGERR(VG_OBJ_RELDYN_SET_ENTSIZE, NULL, E_INVAL, ERR);
	obj->elf.reldyn.entsize = entsize;
	return (obj->elf.reldyn.entsize);
}

/* 
 * vg_obj_reldyn_get/set_entnum = 
 */
vg_idx	vg_obj_reldyn_get_entnum(vg_object *obj)
{
	CHECKDYN(VG_OBJ_RELDYN_GET_ENTNUM, ERR);
	if (!obj || !obj->elf.reldyn.data)
		VGERR(VG_OBJ_RELDYN_GET_ENTNUM, NULL, E_INVAL, ERR);
	return (obj->elf.reldyn.entnum);
}

vg_idx	vg_obj_reldyn_set_entnum(vg_object *obj, vg_idx entnum)
{
	CHECKDYN(VG_OBJ_RELDYN_SET_ENTNUM, ERR);
	if (!obj || !obj->elf.reldyn.data)
		VGERR(VG_OBJ_RELDYN_SET_ENTNUM, NULL, E_INVAL, ERR);
	obj->elf.reldyn.entnum = entnum;
	return (obj->elf.reldyn.entnum);
}


/*
 * vg_obj_reldyn_rentry_by_idx = return a relocation entry giving its index
 * into the reldyn table
 */
Elf32_Rel *vg_obj_reldyn_rentry_by_idx(vg_object *obj, vg_idx idx)
{
	CHECKDYN(VG_OBJ_RELDYN_RENTRY_BY_IDX, NULL);
	if (!obj)
		VGERR(VG_OBJ_RELDYN_RENTRY_BY_IDX, NULL, E_INVAL, NULL);

	if (!vg_obj_get_reldyn(obj, 0))
		return (NULL);

	if (idx<0 || idx>obj->elf.reldyn.entnum)
		VGERR(VG_OBJ_RELDYN_RENTRY_BY_IDX, "Incorrect index", 0, NULL);

	return ((idx? obj->elf.reldyn.data+idx: obj->elf.reldyn.data));
}

/*
 * vg_obj_reldyn_rentry_by_sym = 
 *
 */
Elf32_Rel *vg_obj_reldyn_rentry_by_sym(vg_object *obj, vg_char *sname)
{
	Elf32_Rel	*rentry;
	Elf32_Sym	*dsym;
	vg_idx		idx;

	CHECKDYN(VG_OBJ_RELDYN_RENTRY_BY_SYM, NULL);
	if (!obj || !sname)
		VGERR(VG_OBJ_RELDYN_RENTRY_BY_SYM, NULL, E_INVAL, NULL);

	if (!vg_obj_get_reldyn(obj,0))
		return (NULL);

	for (idx = 0; idx < vg_obj_reldyn_get_entnum(obj); idx++) {
		rentry = vg_obj_reldyn_rentry_by_idx(obj, idx);
		if (!rentry)
			continue;

		dsym = vg_obj_dsym_by_idx(obj,
			vg_obj_rentry_get_info_symidx(obj, rentry));
		if (!dsym)
			continue;

		/* ok, this symbol has a correct relplt entry */
		return (rentry);
        }

	return (NULL);
}

/*
 * vg_obj_reldyn_rentry_by_symidx = return a relocation entry giving its symbol
 * index
 */
Elf32_Rel *vg_obj_reldyn_rentry_by_symidx(vg_object *obj, vg_idx symidx)
{
	Elf32_Rel	*rentry;
	vg_idx		idx;

	CHECKDYN(VG_OBJ_RELDYN_RENTRY_BY_SYMIDX, NULL);
	if (!obj || symidx<0)
		VGERR(VG_OBJ_RELDYN_RENTRY_BY_SYMIDX, NULL, E_INVAL, NULL);

	if (!vg_obj_get_reldyn(obj, 0))
		return (NULL);

	for (idx = 0, rentry = obj->elf.reldyn.data;
		idx < obj->elf.reldyn.entnum;
			++idx, ++rentry) {
		if (vg_obj_rentry_get_info_symidx(obj, rentry) == symidx)
			return (rentry);
	}

	return (NULL);
}

/*
 * vg_obj_reldyn_rentry_by_offset = return a relocation entry giving its offset
 */
Elf32_Rel *vg_obj_reldyn_rentry_by_offset(vg_object *obj, vg_off offset)
{
	Elf32_Rel	*rentry;
	vg_idx		idx;

	CHECKDYN(VG_OBJ_RELDYN_RENTRY_BY_OFFSET, NULL);
	if (!obj || offset<0) 
		VGERR(VG_OBJ_RELDYN_RENTRY_BY_OFFSET, NULL, E_INVAL, NULL);

	if (!vg_obj_get_reldyn(obj, 0))
		return (NULL);

	for(idx=0, rentry = obj->elf.reldyn.data;
		idx < obj->elf.reldyn.entnum;
			++idx, ++rentry) {
		if (vg_obj_rentry_get_offset(obj, rentry) == offset)
			return (rentry);
	}

	return (NULL);
}

