/*

 [=-- LIBVG --=] Runtime Process Manipulation Library [=------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE AT YOUR OWN RISK

*/
#include "libvg.h"

/*
 * vg_replace_obj_hdr =	replace elf header
 * 
 * @obj: vg_obj structure
 * @fd: file descriptor
 * @buf: local buffer
 * #ret: size of data replaced
 */
vg_int	vg_replace_obj_hdr(vg_object *obj, vg_int fd, vg_char *buf)
{
	/* check args */	     /* only one */
	if (!obj || (fd<=0 && !buf) || (fd && buf))
		VGERR(VG_REPLACE_OBJ_HDR, NULL, E_INVAL, ERR);

	/* object need to be mapped */
	if (vg_map_object(obj)<0)
		return (ERR);

	/* check if hdr pointer is correct */
	if (!vg_obj_get_hdr(obj))
		return (ERR);

	/* get mem; copy; write */
	if (fd)
		if (read(fd, obj->elf.hdr.data, obj->elf.hdr.size) != 
						obj->elf.hdr.size)
			VGERR(VG_REPLACE_OBJ_HDR, INTERNAL_ERR, 0, ERR);
	if (buf)
		memcpy(obj->elf.hdr.data, buf, obj->elf.hdr.size);

	/* set object changed */
	SETOBJCH(obj);
	return (obj->elf.hdr.size);
}

/*
 * vg_replace_obj_phdr = replace program header table
 */
vg_int	vg_replace_obj_phdr(vg_object *obj, vg_int fd, vg_char *buf)
{
	if (!obj || (fd<=0 && !buf) || (fd && buf))
		VGERR(VG_REPLACE_OBJ_PHDR, NULL, E_INVAL, ERR);

	if (vg_map_object(obj)<0)
		return (ERR);

	if (!vg_obj_get_phdr(obj, 0))
		return (ERR);

	if (fd)
		if (read(fd, obj->elf.phdr.data, obj->elf.phdr.size)!= 
						 obj->elf.phdr.size)
			VGERR(VG_REPLACE_OBJ_PHDR, INTERNAL_ERR,0,ERR);
	if (buf)
		memcpy(obj->elf.phdr.data, buf, obj->elf.phdr.size);

	SETOBJCH(obj);
	return (obj->elf.phdr.size);
}

/*
 * vg_replace_obj_dyn = replace dynamic section
 */
vg_int	vg_replace_obj_dyn(vg_object *obj, vg_int fd, vg_char *buf)
{
	if (!obj || (fd<=0 && !buf) || (fd && buf)) 
		VGERR(VG_REPLACE_OBJ_DYN, NULL, E_INVAL, ERR);

	if (vg_map_object(obj)<0)
		return (ERR);

	if (!vg_obj_get_dyn(obj, 0)) 
		return (ERR);

	if (fd)
		if (read(fd, obj->elf.dyn.data, obj->elf.dyn.size) != 
						obj->elf.dyn.size)
			VGERR(VG_REPLACE_OBJ_DYN, INTERNAL_ERR, 0,ERR);
	if (buf)
		memcpy(obj->elf.dyn.data, buf, obj->elf.dyn.size);

	SETOBJCH(obj);
	return (obj->elf.dyn.size);
}

/*
 * vg_replace_obj_dynsym = replace dynamic symbol table
 */
vg_int	vg_replace_obj_dynsym(vg_object *obj, vg_int fd, vg_char *buf)
{
	if (!obj || (fd<=0 && !buf) || (fd && buf))
		VGERR(VG_REPLACE_OBJ_DYNSYM, NULL, E_INVAL, ERR);

	if (vg_map_object(obj)<0)
		return (ERR);

	if (!vg_obj_get_dynsym(obj,0))
		return (ERR);

	if (fd) 
		if (read(fd, obj->elf.dynsym.data, obj->elf.dynsym.size) !=
						   obj->elf.dynsym.size) 
			VGERR(VG_REPLACE_OBJ_DYNSYM, INTERNAL_ERR,0, ERR);
	if (buf)
		memcpy(obj->elf.dynsym.data, buf, obj->elf.dynsym.size);

	SETOBJCH(obj);
	return (obj->elf.dynsym.size);
}

/*
 * vg_replace_obj_dynstr = replace dynamic string table 
 */
vg_int	vg_replace_obj_dynstr(vg_object *obj, vg_int fd, vg_char *buf)
{
	if (!obj || (fd<=0 && !buf) || (fd && buf))
		VGERR(VG_REPLACE_OBJ_DYNSTR, NULL, E_INVAL, ERR);

	if (vg_map_object(obj)<0)
		return (ERR);

	if (!vg_obj_get_dynstr(obj))
		return (ERR);

	if (fd)
		if (read(fd,  obj->elf.dynstr.data, obj->elf.dynstr.size) !=
						    obj->elf.dynstr.size)
			VGERR(VG_REPLACE_OBJ_DYNSTR, INTERNAL_ERR, 0,ERR);
	if (buf)
		memcpy(obj->elf.dynstr.data, buf, obj->elf.dynstr.size);

	SETOBJCH(obj);
	return (obj->elf.dynstr.size);
}

/* 
 * vg_replace_obj_reldyn = replace reldyn section
 */
vg_int	vg_replace_obj_reldyn(vg_object *obj, vg_int fd, vg_char *buf)
{
	if (!obj || (fd<=0 && !buf) || (fd && buf))
		VGERR(VG_REPLACE_OBJ_RELDYN, NULL, E_INVAL, ERR);

	if (vg_map_object(obj)<0)
		return (ERR);

	if (!vg_obj_get_reldyn(obj,0))
		return (ERR);

	if (fd)
		if (read(fd, obj->elf.reldyn.data, obj->elf.reldyn.size) !=
						   obj->elf.reldyn.size) 
			VGERR(VG_REPLACE_OBJ_RELDYN, INTERNAL_ERR,0,ERR);
	if (buf)
		memcpy(obj->elf.reldyn.data, buf, obj->elf.reldyn.size);

	SETOBJCH(obj);
	return (obj->elf.reldyn.size);
}

/*
 * vg_replace_obj_relplt = replace relplt section
 */
vg_int	vg_replace_obj_relplt(vg_object *obj, vg_int fd, vg_char *buf)
{
	if (!obj || (fd<=0 && !buf) || (fd && buf))
		VGERR(VG_REPLACE_OBJ_RELPLT, NULL, E_INVAL, ERR);

	if (vg_map_object(obj)<0)
		return (ERR);

	if (!vg_obj_get_relplt(obj,0))
		return (ERR);

	if (fd)
		if (read(fd, obj->elf.relplt.data, obj->elf.relplt.size) != 
						   obj->elf.relplt.size)
			VGERR(VG_REPLACE_OBJ_RELPLT, INTERNAL_ERR, 0,ERR);
	if (buf)
		memcpy(obj->elf.relplt.data, buf, obj->elf.relplt.size);

	SETOBJCH(obj);
	return (obj->elf.relplt.size);	
}

/*
 * vg_replace_obj_hash = replace hash table
 */
vg_int	vg_replace_obj_hash(vg_object *obj, vg_int fd, vg_char *buf)
{
        if (!obj || (fd<=0 && !buf) || (fd && buf))
		VGERR(VG_REPLACE_OBJ_HASH, NULL, E_INVAL, ERR);

	if (vg_map_object(obj) == ERR)	
		return (ERR);

	if (!vg_obj_get_hash(obj))
		return (ERR);

	if (fd)
 	       if (read(fd, obj->elf.hash.data, obj->elf.hash.size) != 
						obj->elf.hash.size)
	        	VGERR(VG_REPLACE_OBJ_HASH, INTERNAL_ERR, 0,ERR);
	if (buf)
		memcpy(obj->elf.hash.data, buf, obj->elf.hash.size);

	SETOBJCH(obj);
	return (obj->elf.hash.size);
}

/*
 * vg_replace_obj_plt = replace plt
 */
vg_int	vg_replace_obj_plt(vg_object *obj, vg_int fd, vg_char *buf)
{
	if (!obj || (fd<=0 && !buf) || (fd && buf)) 
		VGERR(VG_REPLACE_OBJ_PLT, NULL, E_INVAL, ERR);

	if (vg_map_object(obj)<0)
		return (ERR);

	if (!vg_obj_get_plt(obj,0))
		return (ERR);

	if (fd)
		if (read(fd, obj->elf.plt.data, obj->elf.plt.size) != 
						obj->elf.plt.size)
			VGERR(VG_REPLACE_OBJ_PLT, INTERNAL_ERR, 0,ERR);		
	if (buf)
		memcpy(obj->elf.plt.data, buf, obj->elf.plt.size);

	SETOBJCH(obj);
	return (obj->elf.plt.size);
}

/*
 * vg_replace_obj_got = replace got
 */
vg_int	vg_replace_obj_got(vg_object *obj, vg_int fd, vg_char *buf)
{
	if (!obj || (fd<=0 && !buf) || (fd && buf))
		VGERR(VG_REPLACE_OBJ_GOT, NULL, E_INVAL, ERR);
	
	if (vg_map_object(obj)<0)
		return (ERR);
	
	if (!vg_obj_get_got(obj, 0))
		return (ERR);

	if (fd)	
		if (read(fd, obj->elf.got.data, obj->elf.got.size) !=
						obj->elf.got.size)
			VGERR(VG_REPLACE_OBJ_GOT, INTERNAL_ERR, 0, ERR);
	if (buf)
		memcpy(obj->elf.got.data, buf, obj->elf.got.size);

	SETOBJCH(obj);
	return (obj->elf.got.size);
}

/*
 * vg_replace_obj_interp = replace interp section
 */
vg_int	vg_replace_obj_interp(vg_object *obj, vg_int fd, vg_char *buf)
{
	if (!obj || (fd<=0 && !buf) || (fd && buf))
		VGERR(VG_REPLACE_OBJ_INTERP, NULL, E_INVAL, ERR);

	if (vg_map_object(obj)<0)
		return (ERR);

	if (!vg_obj_get_interp(obj))
		return (ERR);

	if (fd)
		if (read(fd, obj->elf.interp.data, obj->elf.interp.size) !=
						   obj->elf.interp.size)
			VGERR(VG_REPLACE_OBJ_INTERP, INTERNAL_ERR, 0, ERR);
	if (buf)
		memcpy(obj->elf.interp.data, buf, obj->elf.interp.size);

	SETOBJCH(obj);
	return (obj->elf.interp.size);
}

/*
 * vg_replace_obj_note = replace note section
 */
vg_int  vg_replace_obj_note(vg_object *obj, vg_int fd, vg_char *buf)
{
	if (!obj || (fd<=0 && !buf) || (fd && buf))
		VGERR(VG_REPLACE_OBJ_NOTE, NULL, E_INVAL, ERR);

        if (vg_map_object(obj)<0)
		return (ERR);

	if (!vg_obj_get_note(obj))
		return (ERR);

	if (fd)
		if (read(fd, obj->elf.note.data, obj->elf.note.size) !=
						 obj->elf.note.size)
		VGERR(VG_REPLACE_OBJ_NOTE, INTERNAL_ERR, 0, ERR);
	if (buf)
		memcpy(obj->elf.note.data, buf, obj->elf.note.size);

	SETOBJCH(obj);
	return (obj->elf.note.size);
}

/*
 * vg_replace_obj_bss = replace bss
 */
vg_int	vg_replace_obj_bss(vg_object *obj, vg_int fd, vg_char *buf)
{
	if (!obj || (fd<=0 && !buf) || (fd && buf))
		VGERR(VG_REPLACE_OBJ_BSS, NULL, E_INVAL, ERR);
	
	if (vg_map_object(obj)<0)
		return (ERR);
	
	if (!vg_obj_get_bss(obj))
		return (ERR);
	
	if (fd)	
		if (read(fd, obj->elf.bss.data, obj->elf.bss.size) !=
						obj->elf.bss.size)
			VGERR(VG_REPLACE_OBJ_BSS, INTERNAL_ERR, 0, ERR);
	if (buf)
		memcpy(obj->elf.bss.data, buf, obj->elf.bss.size);

	SETOBJCH(obj);
	return (obj->elf.bss.size);
}

/*
 * vg_replace_obj_seg = replace text/dat/heap segment
 */
vg_int	vg_replace_obj_seg(vg_object *obj, vg_int fd, vg_char *buf, vg_int type)
{
	vg_vaddr *ptr;
	vg_size size;

	/* check args */
	if (!obj || (fd<=0 && !buf) || (fd && buf) || !type)
		VGERR(VG_REPLACE_OBJ_SEG, NULL, E_INVAL, ERR);

	/* map object */
	if (vg_map_object(obj)<0)
		return (ERR);

	/* check type */
	switch(type) {
	case VG_TEXT_SEG:	
		ptr = obj->text.ptr;
		size = obj->text.size;
		break;
	case VG_DATA_SEG:
		ptr = obj->data.ptr;
		size = obj->data.size;
		break;
	case VG_HEAP_SEG:
		ptr = obj->heap.ptr;
		size = obj->heap.size;
		break;
	default:
		VGERR(VG_REPLACE_OBJ_SEG, "Incorrect segment type", 0, ERR);
	}

	if (fd)
		if (read(fd, ptr, size) != size) 	
			VGERR(VG_REPLACE_OBJ_SEG, INTERNAL_ERR, 0, ERR);
	if (buf)
		memcpy(ptr, buf, size);

	SETOBJCH(obj);
	return(size);
}

/*
 * vg_replace_stack = replace stack 
 */
vg_int	vg_replace_stack(vg_int fd, vg_char *buf)
{
	vg_char	*data;

	if ((fd<=0 && !buf) || (fd && buf)) 
		VGERR(VG_REPLACE_STACK, NULL, E_INVAL, ERR);

	S_ALLOC(data, cur_proc->stack.csize, ERR, VG_REPLACE_STACK, CLEAN);

	if (fd)
		if (read(fd, data, cur_proc->stack.csize) != 
				   cur_proc->stack.csize)
			VGERR(VG_REPLACE_STACK, INTERNAL_ERR, 0, ERR);
	if (buf)
		memcpy(data, buf, cur_proc->stack.csize);

	free(data);
	return (cur_proc->stack.csize);
}

/*
 * vg_replace_obj = replace object, all segments
 */
vg_int	vg_replace_obj(vg_object *obj, vg_int fd, vg_char *buf)
{
	if (!obj || (fd<=0 && !buf) || (fd && buf))
		VGERR(VG_REPLACE_OBJ, NULL, E_INVAL, ERR);

	if (vg_map_object(obj)<0)
		return (ERR);

	/* do not worry about segments alignement, vg_save_ctx manage this */
	if (fd)
		if (read(fd, obj->text.ptr, (obj->text.size + obj->data.size))
				!= (obj->text.size + obj->data.size))
			VGERR(VG_REPLACE_OBJ, INTERNAL_ERR, 0,ERR);
	if (buf)
		memcpy(obj->text.ptr, buf, (obj->text.size + obj->data.size));

	return (obj->text.size + obj->data.size);
}

/*
 * vg_replace_data = replace X data starting at @start vaddr
 */
vg_int	vg_replace_data(vg_vaddr start, vg_vaddr end, vg_int fd, vg_char *buf)
{
	vg_char	*data;

	if ((!start || !end || (fd<=0 && !buf) || (fd && buf)) || (end <= start))
		VGERR(VG_REPLACE_DATA, NULL, E_INVAL, ERR);

	/* get mem */
	S_ALLOC(data, end - start, ERR, VG_REPLACE_DATA, CLEAN);

	/* get data */
	if (fd)
		if (read(fd, data, end-start) != (end-start)) 
			VGERR2(VG_REPLACE_DATA, INTERNAL_ERR, 0, ERR, data);
	if (buf)
		memcpy(data, buf, end-start);

	/* write data into vaddr (only for mapped objects) */
	if (vg_write(data, start, (end-start)) == ERR)
		VGERR2(VG_REPLACE_DATA, INTERNAL_ERR, 0, ERR, data);

	free(data);
	return (end-start);
}

/*
 * vg_replace_sym = replace symbol, local function/variable
 *
 * @sym: symbol to replace
 * @name: symbol name
 * #ret: symbol size
 *
 * some symbols from dynsym have no
 * size so i can't work with them :(
 */
vg_int	vg_replace_sym(vg_int fd, vg_char *buf, vg_sym *sym, vg_char *name)
{
	vg_sym	s;	

	/* check args */
	if ((fd<=0 && !buf) || (fd && buf) || (!sym && !name) || (sym && name)) 
		VGERR(VG_REPLACE_SYM, NULL, E_INVAL, ERR);

	if (name) {
		if (vg_sym_func_local_by_name(0, &s, name)<0) 
			return (ERR);
		sym = &s;
	}

	if (!sym->size)
		VGERR(VG_REPLACE_SYM, "Incorrect symbol size", 0,ERR);

	if (vg_replace_data(sym->vaddr, sym->vaddr+sym->size, fd, buf)<0)
		return (ERR);

	return (sym->size);
}

