/*

 [=-- LIBVG --=] Runtime Process Manipulation Library [=------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE AT YOUR OWN RISK

*/
#include "libvg.h"
#include "vg_resin.h"

extern  vg_proc *cur_proc;
extern	pid_t cur_pid;


#if defined(__i386__)

/* 

  ##########################################################################
  ##   RESIN: REMOTE SYSCALL INTERFACE                                    ##
  ##########################################################################


 */
vg_int	doit(sys s)
{
	vg_regs	or, r;
	vg_char	*o_code;
	vg_int	sz;

	/* stop process */
	if (cur_proc->pstate.status == PS_RUNNING) {
		cur_proc->pstate.handler = DISABLED;
		kill(cur_proc->pid, SIGSTOP);
		waitpid(cur_pid, &cur_proc->pstate.wstatus, cur_proc->pstate.wopts);
		cur_proc->pstate.status = PS_STOPPED;
		cur_proc->pstate.handler = ENABLED;
	}

	/* patch retsc */
	*(u_long*)&sc_ret[3] = SYS_getpid;
	*(u_long*)&sc_ret[13] = SIGSTOP;
	*(u_long*)&sc_ret[22] = SYS_kill;

	/* size of syscallsc + retsc + 10 */
	sz = s.size + SC_RET_SIZE + 10;

	if (s.str1.str) sz += s.str1.size;
	if (s.str2.str) sz += s.str2.size;

	/* get regs */
	vg_direct_getregs(&or);

	/* save orig code */
	if (!(o_code = (vg_char*)malloc(sz)))
		VGERR(0, INTERNAL_ERR, 0, ERR);
	memset(o_code, 0, sz);
	if (vg_dread(o_code, or.eip, sz) != sz)
		VGERR2(0,0,0, ERR, o_code);

	if (s.str1.str)
		PATCH_SC(s.code, s.str1.patch, (or.eip + (sz - 
			(s.str1.size+(s.str2.str?s.str2.size:0)) - 10 )), 0);
	if (s.str2.str)
		PATCH_SC(s.code, s.str2.patch, (or.eip +  (sz - 
						s.str2.size - 10)), 0);	

	/* injectar codigo sc en EIP */
	if (vg_direct_write(s.code, or.eip, s.size) != s.size)
		VGERR2(0, 0,0,ERR, o_code);
	/* injectar codigo ret en EIP + strlen(sc) */
	if (vg_direct_write(sc_ret, or.eip+s.size, SC_RET_SIZE) != SC_RET_SIZE)
		VGERR2(0, 0,0,ERR, o_code);

	/* inject string into eip */
	if (s.str1.str)
		vg_direct_write(s.str1.str, or.eip+s.size +
					SC_RET_SIZE, s.str1.size);
	if (s.str2.str)
		vg_direct_write(s.str2.str, or.eip + 
			(sz - s.str2.size - 10), s.str2.size);

	/* run syscall and wait for ret */
	cur_proc->pstate.handler = DISABLED;
	vg_proc_continue(cur_proc->pid);

	waitpid(cur_pid, &cur_proc->pstate.wstatus, cur_proc->pstate.wopts);
        cur_proc->pstate.status = PS_STOPPED;
	cur_proc->pstate.handler = ENABLED;

	/* get ret value (esi) */
	vg_direct_getregs(&r);

	/* restore orig code */
	vg_direct_write(o_code, or.eip, sz);
	vg_direct_setregs(&or);

	return (r.esi);
}

 
/*
	####################
	##  MEM SYSCALLS  ##
	####################

*/
vg_int	vg_sys_mmap(vg_size size, vg_int prot, vg_int flags)
{
	sys	mmap;
	memset(&mmap, 0, sizeof(sys));

	PATCH_SC(sc_mmap, SC_MMAP_ARG1, size, SC_MMAP_DEFARG1);
	PATCH_SC(sc_mmap, SC_MMAP_ARG2, prot, SC_MMAP_DEFARG2);
	PATCH_SC(sc_mmap, SC_MMAP_ARG3, flags, SC_MMAP_DEFARG3);
	PATCH_SC(sc_mmap, 25, SC_MMAP, 0);
	PATCH_SC(sc_mmap, 30, SC_MMAP, 0);

	mmap.code = sc_mmap;
	mmap.size = SC_MMAP_SIZE;	

	return (doit(mmap));
}

vg_int	vg_sys_munmap(vg_vaddr vaddr, vg_size size)
{
	sys	munmap;
	memset(&munmap, 0, sizeof(sys));

	PATCH_SC(sc_temp2, SC_TEMP2_ARG1, vaddr, SC_MUNMAP_DEFARG1);
	PATCH_SC(sc_temp2, SC_TEMP2_ARG2, size, SC_MUNMAP_DEFARG2);
	PATCH_SC(sc_temp2, SC_TEMP2_SYSN, SC_MUNMAP, 0);

	munmap.code = sc_temp2;
	munmap.size = SC_TEMP2_SIZE;

	return (doit(munmap));
}

vg_int	vg_sys_mprotect(vg_vaddr vaddr, vg_size size, vg_int prot)
{
	sys	mprotect;
	memset(&mprotect, 0, sizeof(sys));

	PATCH_SC(sc_temp3, SC_TEMP3_ARG1, vaddr, SC_MPROTECT_DEFARG1);
	PATCH_SC(sc_temp3, SC_TEMP3_ARG2, size, SC_MPROTECT_DEFARG2);
	PATCH_SC(sc_temp3, SC_TEMP3_ARG3, prot, SC_MPROTECT_DEFARG3);
	PATCH_SC(sc_temp3, SC_TEMP3_SYSN, SC_MPROTECT, 0);

	mprotect.code = sc_temp3;
	mprotect.size = SC_TEMP3_SIZE;

	return (doit(mprotect));
}

vg_int	vg_sys_mlock(vg_vaddr vaddr, vg_size size)
{
	sys	mlock;
	memset(&mlock, 0, sizeof(sys));
	
	PATCH_SC(sc_temp2, SC_TEMP2_ARG1, vaddr, SC_MLOCK_DEFARG1);
	PATCH_SC(sc_temp2, SC_TEMP2_ARG2, size, SC_MLOCK_DEFARG2);
	PATCH_SC(sc_temp2, SC_TEMP2_SYSN,  SC_MLOCK, 0);

	mlock.code = sc_temp2;
	mlock.size = SC_TEMP2_SIZE;

	return (doit(mlock));
}

vg_int	vg_sys_munlock(vg_vaddr vaddr, vg_size size)
{
	sys	munlock;
	memset(&munlock, 0, sizeof(sys));

	PATCH_SC(sc_temp2, SC_TEMP2_ARG1, vaddr, SC_MUNLOCK_DEFARG1);
	PATCH_SC(sc_temp2, SC_TEMP2_ARG2, size, SC_MUNLOCK_DEFARG2);
	PATCH_SC(sc_temp2, SC_TEMP2_SYSN, SC_MUNLOCK, 0);
	
	munlock.code = sc_temp2;
	munlock.size = SC_TEMP2_SIZE;

	return (doit(munlock));
}

vg_int	vg_sys_mlockall(vg_uint flags)
{
	sys	mlockall;
	memset(&mlockall,0, sizeof(sys));
	
	PATCH_SC(sc_temp1, SC_TEMP1_ARG1, flags, SC_MLOCKALL_DEFARG1);	
	PATCH_SC(sc_temp1, SC_TEMP1_SYSN, SC_MLOCKALL, 0);

	mlockall.code = sc_temp1;
	mlockall.size = SC_TEMP1_SIZE;

	return (doit(mlockall));
}

vg_int	vg_sys_munlockall(void)
{
	sys	munlockall;
	memset(&munlockall, 0, sizeof(sys));

	PATCH_SC(sc_temp1, SC_TEMP1_ARG1, 0, 0);
	PATCH_SC(sc_temp1, SC_TEMP1_SYSN, SC_MUNLOCKALL, 0);

	munlockall.code = sc_temp1;
	munlockall.size = SC_TEMP1_SIZE;

	return (doit(munlockall));
}

/*
	######################	
	##   VFS SYSCALLS   ##
	######################

*/
vg_int	vg_sys_open(vg_char *path, vg_int flags, vg_int mode)
{
	sys	open;
	memset(&open, 0, sizeof(sys));

	PATCH_SC(sc_temp3, SC_TEMP3_ARG1, 0, SC_OPEN_DEFARG1);
	PATCH_SC(sc_temp3, SC_TEMP3_ARG2, flags, SC_OPEN_DEFARG2);
	PATCH_SC(sc_temp3, SC_TEMP3_ARG3, mode, SC_OPEN_DEFARG3);
	PATCH_SC(sc_temp3, SC_TEMP3_SYSN, SC_OPEN, 0);

	open.code = sc_temp3;
	open.size = SC_TEMP3_SIZE;
	open.str1.str = path;
	open.str1.size = strlen(path)+1;
	open.str1.patch = SC_TEMP3_ARG1;

	return (doit(open));	
}

vg_int	vg_sys_read(vg_int fd, vg_vaddr addr, vg_size size)
{
	sys	read;
	memset(&read, 0, sizeof(sys));

	PATCH_SC(sc_temp3, SC_TEMP3_ARG1, fd, SC_READ_DEFARG1);
	PATCH_SC(sc_temp3, SC_TEMP3_ARG2, addr, SC_READ_DEFARG2);
	PATCH_SC(sc_temp3, SC_TEMP3_ARG3, size, SC_READ_DEFARG3);
	PATCH_SC(sc_temp3, SC_TEMP3_SYSN, SC_READ, 0);

	read.code = sc_temp3;
	read.size = SC_TEMP3_SIZE;

	return (doit(read));
}

vg_int	vg_sys_write(vg_int fd, vg_vaddr addr, vg_size size)
{
	sys	write;
	memset(&write, 0, sizeof(sys));

	PATCH_SC(sc_temp3, SC_TEMP3_ARG1, fd, SC_WRITE_DEFARG1);
	PATCH_SC(sc_temp3, SC_TEMP3_ARG2, addr, SC_WRITE_DEFARG2);
	PATCH_SC(sc_temp3, SC_TEMP3_ARG3, size,	SC_WRITE_DEFARG3);
	PATCH_SC(sc_temp3, SC_TEMP3_SYSN, SC_WRITE, 0);

	write.code = sc_temp3;
	write.size = SC_TEMP3_SIZE;

	return (doit(write));
}

vg_int	vg_sys_chmod(vg_char *path, vg_int mode)
{
	sys	chmod;
	memset(&chmod, 0, sizeof(chmod));

	PATCH_SC(sc_temp2, SC_TEMP2_ARG1, 0, SC_CHMOD_DEFARG1);
	PATCH_SC(sc_temp2, SC_TEMP2_ARG2, mode, SC_CHMOD_DEFARG2);
	PATCH_SC(sc_temp2, SC_TEMP2_SYSN, SC_CHMOD, 0);

	chmod.code = sc_temp2;
	chmod.size = SC_TEMP2_SIZE;
	chmod.str1.str = path;
	chmod.str1.size = strlen(path)+1;
	chmod.str1.patch = SC_TEMP2_ARG1;

	return (doit(chmod));
}

vg_int	vg_sys_fchmod(vg_int fd, vg_int mode)
{
	sys	fchmod;
	memset(&fchmod, 0, sizeof(fchmod));

	PATCH_SC(sc_temp2, SC_TEMP2_ARG1, fd, SC_FCHMOD_DEFARG1);
	PATCH_SC(sc_temp2, SC_TEMP2_ARG2, mode, SC_FCHMOD_DEFARG1);
	PATCH_SC(sc_temp2, SC_TEMP2_SYSN, SC_FCHMOD, 0);

	fchmod.code = sc_temp2;
	fchmod.size = SC_TEMP2_SIZE;

	return (doit(fchmod));
}

vg_int	vg_sys_chdir(vg_char *path)
{
	sys	chdir;
	memset(&chdir, 0, sizeof(chdir));
	
	PATCH_SC(sc_temp1, SC_TEMP1_ARG1, 0, SC_CHDIR_DEFARG1);
	PATCH_SC(sc_temp1, SC_TEMP1_SYSN, SC_CHDIR, 0);

	chdir.code = sc_temp1;
	chdir.size = SC_TEMP1_SIZE;
	chdir.str1.str = path;
	chdir.str1.size = strlen(path)+1;
	chdir.str1.patch = SC_TEMP1_ARG1;

	return (doit(chdir));
}

vg_int	vg_sys_fchdir(vg_int fd)
{
	sys	fchdir;
	memset(&fchdir, 0, sizeof(fchdir));

	PATCH_SC(sc_temp1, SC_TEMP1_ARG1, fd, SC_FCHDIR_DEFARG1);
	PATCH_SC(sc_temp1, SC_TEMP1_SYSN, SC_FCHDIR, 0);

	fchdir.code = sc_temp1;
	fchdir.size = SC_TEMP1_SIZE;

	return (doit(fchdir));
}

vg_int	vg_sys_chroot(vg_char *path)
{
	sys	chroot;
	memset(&chroot, 0, sizeof(chroot));

	PATCH_SC(sc_temp1, SC_TEMP1_ARG1, 0, SC_CHROOT_DEFARG1);
	PATCH_SC(sc_temp1, SC_TEMP1_SYSN, SC_CHROOT, 0);

	chroot.code = sc_temp1;
	chroot.size = SC_TEMP1_SIZE;
	chroot.str1.str = path;
	chroot.str1.size = strlen(path)+1;
	chroot.str1.patch = SC_TEMP1_ARG1;

	return (doit(chroot));
}

vg_int	vg_sys_mkdir(vg_char *path, vg_int mode)
{
        sys     mkdir;
        memset(&mkdir, 0, sizeof(sys));

        PATCH_SC(sc_temp2, SC_TEMP2_ARG1, 0, SC_MKDIR_DEFARG1);
        PATCH_SC(sc_temp2, SC_TEMP2_ARG2, mode, SC_MKDIR_DEFARG2);
        PATCH_SC(sc_temp2, SC_TEMP2_SYSN, SC_MKDIR, 0);

        mkdir.code = sc_temp2;
        mkdir.size = SC_TEMP2_SIZE;
        mkdir.str1.str = path;;
        mkdir.str1.size = strlen(path)+1;
        mkdir.str1.patch = SC_TEMP2_ARG1;

        return (doit(mkdir));
}

vg_int	vg_sys_rmdir(vg_char *path)
{
        sys     rmdir;
        memset(&rmdir, 0, sizeof(sys));

        PATCH_SC(sc_temp1, SC_TEMP1_ARG1, 0, SC_RMDIR_DEFARG1);
        PATCH_SC(sc_temp1, SC_TEMP1_SYSN, SC_RMDIR, 0);

        rmdir.code = sc_temp1;
        rmdir.size = SC_TEMP1_SIZE;
        rmdir.str1.str = path;
        rmdir.str1.size = strlen(path)+1;
        rmdir.str1.patch = SC_TEMP1_ARG1;

        return (doit(rmdir));
}

vg_int	vg_sys_rename(vg_char *from , vg_char *to)
{
        sys     rename;
        memset(&rename, 0, sizeof(sys));

        PATCH_SC(sc_temp2, SC_TEMP2_ARG1, 0, SC_RENAME_DEFARG1);
        PATCH_SC(sc_temp2, SC_TEMP2_ARG2, 0, SC_RENAME_DEFARG2);
        PATCH_SC(sc_temp2, SC_TEMP2_SYSN, SC_RENAME, 0);

        rename.code = sc_temp2;
        rename.size = SC_TEMP2_SIZE;
        rename.str1.str = from;
        rename.str1.size = strlen(from)+1;
        rename.str1.patch = SC_TEMP2_ARG1;
        rename.str2.str = to;
        rename.str2.size = strlen(to)+1;
        rename.str2.patch = SC_TEMP2_ARG2;

        return (doit(rename));
}

vg_int	vg_sys_link(vg_char *name1, vg_char *name2)
{
        sys     link;
        memset(&link, 0, sizeof(sys));

        PATCH_SC(sc_temp2, SC_TEMP2_ARG1, 0, SC_LINK_DEFARG1);
        PATCH_SC(sc_temp2, SC_TEMP2_ARG2, 0, SC_LINK_DEFARG2);
        PATCH_SC(sc_temp2, SC_TEMP2_SYSN, SC_LINK, 0);

        link.code = sc_temp2;
        link.size = SC_TEMP2_SIZE;
        link.str1.str = name1;
        link.str1.size = strlen(name1)+1;
        link.str1.patch = SC_TEMP2_ARG1;
        link.str2.str = name2;
        link.str2.size = strlen(name2)+1;
        link.str2.patch = SC_TEMP2_ARG2;

        return (doit(link));
}

vg_int	vg_sys_unlink(vg_char *path)
{
        sys     unlink;
        memset(&unlink, 0, sizeof(unlink));

        PATCH_SC(sc_temp1, SC_TEMP1_ARG1, 0, SC_UNLINK_DEFARG1);
        PATCH_SC(sc_temp1, SC_TEMP1_SYSN, SC_UNLINK, 0);

        unlink.code = sc_temp1;
        unlink.size = SC_TEMP1_SIZE;
        unlink.str1.str = path;
        unlink.str1.size = strlen(path)+1;
        unlink.str1.patch = SC_TEMP1_ARG1;

        return (doit(unlink));
}

/*
	####################################
	#  PROCESS & PROTECTION SYSCALLS  ##
	####################################

*/
vg_int	vg_sys_getpid(void)
{
	sys	getpid;
	memset(&getpid, 0, sizeof(sys));

	PATCH_SC(sc_temp1, SC_TEMP1_ARG1, 0, 0);
	PATCH_SC(sc_temp1, SC_TEMP1_SYSN, SC_GETPID, 0);

	getpid.code = sc_temp1;
	getpid.size = SC_TEMP1_SIZE;
	
	return (doit(getpid));
}

vg_int	vg_sys_getppid(void)
{
	sys	getppid;
	memset(&getppid, 0, sizeof(sys));

	PATCH_SC(sc_temp1, SC_TEMP1_ARG1, 0, 0);
	PATCH_SC(sc_temp1, SC_TEMP1_SYSN, SC_GETPPID, 0);

	getppid.code = sc_temp1;
	getppid.size = SC_TEMP1_SIZE;

	return (doit(getppid));
}

vg_int	vg_sys_getuid(void)
{
	sys	getuid;
	memset(&getuid, 0, sizeof(sys));

	PATCH_SC(sc_temp1, SC_TEMP1_ARG1, 0, 0);
	PATCH_SC(sc_temp1, SC_TEMP1_SYSN, SC_GETUID, 0);

	getuid.code = sc_temp1;
	getuid.size = SC_TEMP1_SIZE;

	return(doit(getuid));
}

vg_int	vg_sys_geteuid(void)
{
	sys	geteuid;
	memset(&geteuid, 0, sizeof(sys));
	
	PATCH_SC(sc_temp1, SC_TEMP1_ARG1, 0, 0);
	PATCH_SC(sc_temp1, SC_TEMP1_SYSN, SC_GETEUID, 0);
	
	geteuid.code = sc_temp1;
	geteuid.size = SC_TEMP1_SIZE;

	return (doit(geteuid));
}

vg_int	vg_sys_getgid(void)
{
	sys	getgid;
	memset(&getgid, 0, sizeof(sys));

	PATCH_SC(sc_temp1, SC_TEMP1_ARG1, 0, 0);
	PATCH_SC(sc_temp1, SC_TEMP1_SYSN, SC_GETGID, 0);

	getgid.code = sc_temp1;
	getgid.size = SC_TEMP1_SIZE;

	return (doit(getgid));
}

vg_int	vg_sys_getegid(void)
{
	sys	getegid;
	memset(&getegid, 0, sizeof(sys));

	PATCH_SC(sc_temp1, SC_TEMP1_ARG1, 0, 0);
	PATCH_SC(sc_temp1, SC_TEMP1_SYSN, SC_GETEGID, 0);

	getegid.code = sc_temp1;
	getegid.size = SC_TEMP1_SIZE;

	return (doit(getegid));
}

vg_int	vg_sys_dup(vg_int oldd)
{
	sys	dup;
	memset(&dup, 0, sizeof(sys));

	PATCH_SC(sc_temp1, SC_TEMP1_ARG1, oldd, SC_DUP_DEFARG1);
	PATCH_SC(sc_temp1, SC_TEMP1_SYSN, SC_DUP, 0);

	dup.code = sc_temp1;
	dup.size = SC_TEMP1_SIZE;

	return (doit(dup));
}

vg_int	vg_sys_dup2(vg_int oldd, vg_int newd)
{
	sys	dup2;
	memset(&dup2, 0, sizeof(sys));

	PATCH_SC(sc_temp2, SC_TEMP2_ARG1, oldd, SC_DUP2_DEFARG1);
	PATCH_SC(sc_temp2, SC_TEMP2_ARG2, newd, SC_DUP2_DEFARG2);
	PATCH_SC(sc_temp2, SC_TEMP2_SYSN, SC_DUP2, 0);

	dup2.code = sc_temp2;
	dup2.size = SC_TEMP2_SIZE;

	return (doit(dup2));
}

#endif

