/*

 [=-- LIBVG --=] Runtime Process Manipulation Library [=------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE AT YOUR OWN RISK

*/
#include "libvg.h"

extern  vg_proc *cur_proc;
extern  pid_t   cur_pid;
void    (*sig_hand)();

#define	RPSM_ON		1
#define	RPSM_OFF	0

/*	remote process signal monitor: handler for traced process */

void	enable_rpsm()  { cur_proc->pstate.rpsm = RPSM_ON;  }
void	disable_rpsm() { cur_proc->pstate.rpsm = RPSM_OFF; }

void	rpsm(vg_int sig)
{
	/* this handler can be disabled so first of all check it */
	if (cur_proc->pstate.handler == RPSM_ON) {
		/* set wait opts and wait for any change on traced process (SIGCHLD) */
		cur_proc->pstate.wopts |= (WUNTRACED);
		waitpid(cur_pid, &cur_proc->pstate.wstatus, cur_proc->pstate.wopts);

		/* (A) check if attached process have been continued by SIGCONT,
			this isn't supported on all systems */
#if defined(WIFCONTINUED)
		if (WIFCONTINUED(cur_proc->pstate.wstatus)) {
			cur_proc->pstate.status = PS_RUNNING;
			cur_proc->pstate.signal = SIGCONT;
		}
#endif
		/* (B) check if attached process terminated normally by exit() */
		if (WIFEXITED(cur_proc->pstate.wstatus)) {
			cur_proc->pstate.status = PS_TERMINATED;
			cur_proc->pstate.signal = WTERMSIG(cur_proc->pstate.wstatus);
			cur_proc->pstate.exit_val = WEXITSTATUS(cur_proc->pstate.wstatus);
		}	
		/* (C) check if attached process terminated by a signal */
		if (WIFSIGNALED(cur_proc->pstate.wstatus)) {
			cur_proc->pstate.status = PS_TERMINATED;
			cur_proc->pstate.signal = WTERMSIG(cur_proc->pstate.wstatus);
		}
		else {	/* (D) process was stopped by one of the following signals:  */
			cur_proc->pstate.signal = WSTOPSIG(cur_proc->pstate.wstatus);
			switch(cur_proc->pstate.signal) {
			case SIGSTOP:
				cur_proc->pstate.status = PS_STOPPED;
				break;
			case SIGCONT:
				cur_proc->pstate.status = PS_RUNNING;
				break;
			case SIGTRAP:	/* diferent sigtrap schemes */
				/* d.1) stopped by breakpoint: we must disable it */
				cur_proc->pstate.status = PS_STOPPED;
				if ((cur_proc->flags & PROC_BKPT) && !vg_bkpt_check()) {
					cur_proc->pstate.status = PS_BKPT;
				}
				break;
			}
		}	
	}
	/* m....x.. reloaded */
	load_default_sighandlers();
}

/*
 *	EXIT IF SIGXXX
 */
void	local_sighandler()
{
	if (sig_hand)
                sig_hand();
        else
                vg_fini_pctx(cur_proc);
        exit(1);
}

/*
 *	LOAD HANDLERS FOR THE LOCAL AND REMOTE PROCESS
 */
void	load_default_sighandlers(void)
{
	/* our process */
	signal(SIGINT,  local_sighandler);
	signal(SIGQUIT, local_sighandler); 
	signal(SIGKILL, local_sighandler); 
	signal(SIGSEGV, local_sighandler);

	/* the remote process */
	signal(SIGCHLD, rpsm);

	sig_hand = NULL;
}

