/*

 [=-- LIBVG --=] Runtime Process Manipulation Library [=------------- v0.3 -]
 [--------------------------------------------------------------------------]
 [-- Copyright (c) 2004 Pluf ---------------------------< 7a69ezine.org >---]

 THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY, USE AT YOUR OWN RISK

*/
#include "libvg.h"

extern vg_proc	*cur_proc;
extern vg_pid	cur_pid;


vg_int	setup_stack_operations(vg_proc *p)
{
	p->stack.op.get		= vg_get_stack;
	p->stack.op.push	= vg_stack_push;
	p->stack.op.pop		= vg_stack_pop;

	return (OK);
}

/*
 * vg_get_stack = 
 *
 * @ret
 */
vg_vaddr vg_get_stack()
{
	struct rlimit rl;
	
	if (getrlimit(RLIMIT_STACK, &rl)<0)
		VGERR(VG_GET_STACK, INTERNAL_ERR, 0, ERR);

#if defined(__i386__)
#if defined(__linux__) || defined(__BSD__)
	cur_proc->stack.start = cur_proc->regs.esp;
	cur_proc->stack.end = STACK_TOP;
	cur_proc->stack.csize = cur_proc->stack.end - cur_proc->stack.start;
	cur_proc->stack.msize = rl.rlim_max;
	cur_proc->stack.ptr = (vg_char*)cur_proc->stack.start;
	cur_proc->stack.flags = 0;
	
	return (cur_proc->stack.start);
#endif
#endif
}

/*
 * vg_stack_push = push some data into the stack
 *
 * @data: data to be pushed into the stack
 * @size: size of data
 * #ret: updated esp
 */
vg_vaddr vg_stack_push(vg_void *data, vg_size size)
{
	if (!data || size<=0)
		VGERR(VG_STACK_PUSH, "Incorrect arg", 0,ERR);

#if defined(__i386__)
#if defined(__linux__) || defined(__BSD__)
        /* respect stack behavior */
        if (vg_write(data, cur_proc->regs.esp - size, size) != size)
                return (ERR);

        cur_proc->regs.esp -= size;
        return (cur_proc->regs.esp);
#endif
#endif
}

/*
 * vg_stack_pop = pop data from the stack
 *
 * @data: data to be poped from the stack
 * @size: size of data
 * #ret: updated esp
 */
vg_vaddr vg_stack_pop(vg_void *data, vg_size size)
{
	if (!data || size<=0)
		VGERR(VG_STACK_POP, NULL, E_INVAL, ERR);

#if defined(__i386__)
#if defined(__linux__) || defined(__BSD__)
	if (vg_read(data, cur_proc->regs.esp, size) != size)
		return (ERR); 

        cur_proc->regs.esp +=size;
        return (cur_proc->regs.esp);
#endif
#endif
}

/*
 * vg_stack_get_start = 
 */
vg_vaddr vg_stack_get_start(void)
{
	if (!cur_proc->stack.start) {
		if (cur_proc->stack.op.get()<0)
			return (ERR);
	}
	return (cur_proc->stack.start);
}

/*
 * vg_stack_get_end = 
 */
vg_vaddr vg_stack_get_end(void)
{
	if (!cur_proc->stack.start) {
		if (cur_proc->stack.op.get()<0)
			return (ERR);
	}
	return (cur_proc->stack.end);
}

/*
 * vg_stack_get_max_size = 
 */
vg_size	vg_stack_get_max_size(void)
{
	if (!cur_proc->stack.start) {
		if (cur_proc->stack.op.get()<0)
			return (ERR);
	}
	return (cur_proc->stack.msize);
}

/*
 * vg_stack_get_cur_size = 
 */
vg_size	vg_stack_get_cur_size(void)
{
	if (!cur_proc->stack.start) {
		if (cur_proc->stack.op.get()<0)
			return (ERR);
	}
	return (cur_proc->stack.csize);
}


