#!/usr/bin/perl -w

# USE
use English;
use Getopt::Long;
use POSIX;

# DEFINES
my $start;
my %children;
my $children = 0;
my @sigs;

$aanvalAppsDir = `cd \`dirname $0\`;pwd`;
chop($aanvalAppsDir);

# OPTIONS
GetOptions (
		'start' => \$start,
		'help|?' => \$help,
		'F' => \$opt_F,
		'U=s' => \$opt_U
		);

# Prepare for launch! T minus 3...2...1
launch();



################ FUNCTIONS ################

sub launch {

	my $run = 1;

	# Change to Aanval's /apps directory
	chdir("$aanvalAppsDir");
	
	# Exit immediately if this launch isn't going anywhere
	if (!$start && !$help) { print "\nNothing to do. Try -help\n\n"; $run = 0; }
	
	# Display Help
	if ($help) { displayHelp(); $run = 0; }

	if (!$opt_U) { print "\nMust use -U with option to start a processing unit\n\n"; $run = 0;}

	if ($run == 1) {
		# Check for foreground mode
		if (!$opt_F && $start) { daemonRun(); }
		
		main();
	}

	exit;
}

sub main {

	$0 = "Aanval BPU - $opt_U";
	
	while(1) {
	
		if (-e "$aanvalAppsDir/pid/allStop") { exit; }
	
		system("php -q $aanvalAppsDir/processor$opt_U.php > /dev/null");
		sleep 1;
		
	}
}

sub daemonRun {
	my $pid = fork;
	
	defined ($pid) or die "Cannot start Aanval as daemon: $!";
	
	if ($pid) {
		print "Aanval BPU $opt_U launched in daemon mode [PID: $pid].\n";
	}
	
	exit if $pid; # Return control to the user
	
	POSIX::setsid(); # Become a session mojo-master
	
	close (STDOUT); # Close file handles to detach from any terminals if necessary
	close (STDIN);
	close (STDERR);
	
	# Any death trigger will kill everything
	
	$SIG{HUP} = $SIG{INT} = $SIG{TERM} = sub {
		my $sig = shift;
		$SIG{$sig} = 'IGNORE';
		kill 'INT' => keys %children;
		die "killed by $sig\n";
		exit;
	};      
	
}

sub displayHelp {

	print "Usage: ./idsProcessor.pl [options] -U [A,B,C,etc]\n\n";
	
	print "-start			Start the Aanval Background Processor\n";
	print "-U [A,B,C,etc]	Specifies the processing unit to start\n";
	print "-F           	Foreground Mode - Runs in foreground\n";
	print "-help        	This Help Information\n";
	print "\n";
	print "Example: perl ./idsProcessor.pl -start -U A\n";

}
