<?php

/** Copyright 2009 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */

// Tell the system we are in processor mode
$processor = 1;

// Set some initital variables
$processorVersion = "5.0";

// Prepare environment
include "initialize.php";

function aLoop() {
	global $processorVersion, $masterCnt;

	// Start Timer
	$timerStart = date("U");
	
	procWrite("A", "RESET");
	
	procWrite("A", "----------------------------------------------------");
	procWrite("A", ":: Background Processing Unit A v$processorVersion");
	procWrite("A", ":: " . versionText());
	procWrite("A", ":: Date & Time " . date("r"));
	procWrite("A", "----------------------------------------------------");
	
	// Hold Check
	if (file_exists("../../tmp/holdA.tmp")) { procwrite("A", ":: Processor On Hold -> Exiting"); exit; }
	
	// MySQL Snort Processing Function
	idsSnort();
	
	// Unified Snort Processing Function
	idsSnortUnified();
	
	// Syslog Processing Function
	idsSyslog();
	
	// Timer Calculations
	$timerDiff = time() - $timerStart;
	
	// Write BPU Stat file
	bpuStatsWrite("A", $timerStart, time());
	
	// Footer
	procWrite("A", "----------------------------------------------------");
	procWrite("A", ":: Iteration $masterCnt");
	procWrite("A", ":: Completed in $timerDiff seconds");
	procWrite("A", "----------------------------------------------------");

}

while ($masterCnt != ops("site_bpuIterationA")) {
	$masterCnt++;

	// Exit if stop command found
	if (@file_exists("../../apps/bpu/pid/allStop")) { echo "Exiting...\nThis BPU has been issued a stop command. Please use idsBackground.pl to issue the start command\n\n"; exit; }
	
	// Perform Loop
	aLoop();
	
	// Sleep
	sleep(ops("site_bpuSleepA"));
}

// Close Database Connections
$idsDB->close();

exit;

?>
