<?php

/** Copyright 2010 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */

// Tell the system we are in processor mode
$processor = 1;

// Set some initital variables
$processorVersion = "5.5";

// Prepare environment
include "initialize.php";

function bLoop() {
	global $processorVersion, $masterCnt;

	// Start Timer
	$timerStart = date("U");
	
	procWrite("B", "RESET");
	
	procWrite("B", "----------------------------------------------------");
	procWrite("B", ":: Background Processing Unit B v$processorVersion");
	procWrite("B", ":: " . versionText());
	procWrite("B", ":: Date & Time " . date("r"));
	procWrite("B", "----------------------------------------------------");
	
	// Hold Check
	if (@file_exists("../../tmp/holdB.tmp")) { 
	
		procwrite("B", ":: ON HOLD");
		
	 } else {
	 
		// Customized Operations Loading
		customOperations();	
	
		// Mail Processor
		processMail();
		
		// Permissions Checking
		permissionsCheck();
		
		// Version Checking
		remoteVersionCheck();
		
		// AI (Artificial Intelligence)
//		analysisProcessor();
		
		// Deletions
		deleteDataProcessor();
		
		// Scanner
		nmapScanProcessor();
		
		// Signature System
		sigProcessor();
	
		// Auto Snort Trimming
		autoSnortTrimmer();
		
		// Hostname Resolving
		hostnameProcessor();
		
		// Maintenance
		consoleMaintenance();
		
		// Deletion System
		deleteDataStoreCheck();
		
	 }

	$timerDiff = date("U") - $timerStart;
		
	// Write BPU Stat file
	bpuStatsWrite("B", $timerStart, time());	 
	
	// Footer
	procWrite("B", "----------------------------------------------------");
	procWrite("B", ":: Iteration $masterCnt");
	procWrite("B", ":: Completed in $timerDiff seconds");
	procWrite("B", "----------------------------------------------------");
	
}

while ($masterCnt != ops("site_bpuIterationB")) {
	$masterCnt++;

	// Exit if stop command found
	if (@file_exists("../../apps/bpu/pid/allStop")) { echo "Exiting...\nThis BPU has been issued a stop command. Please use idsBackground.pl to issue the start command\n\n"; exit; }
	
	// Perform Loop
	bLoop();
	
	// Sleep
	sleep(ops("site_bpuSleepB"));
}

// Close Database Connections
$idsDB->close();

exit;

?>
