<?php

/** Copyright 2009 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */

// Tell the system we are in processor mode
$processor = 1;

// Set some initital variables
$processorVersion = "5.0";

// Prepare environment
include "initialize.php";

function cLoop() {
	global $processorVersion, $masterCnt;

	// Start Timer
	$timerStart = date("U");
	
	procWrite("C", "RESET");
	
	procWrite("C", "----------------------------------------------------");
	procWrite("C", ":: Background Processing Unit C v$processorVersion");
	procWrite("C", ":: " . versionText());
	procWrite("C", ":: Date & Time " . date("r"));
	procWrite("C", "----------------------------------------------------");
	
	// Hold Check
	if (file_exists("../../tmp/holdC.tmp")) { procwrite("C", ":: Processor On Hold -> Exiting"); exit;	}
	
	// Index System
#	indexer();
	
	$timerDiff = date("U") - $timerStart;
	
	// Write BPU Stat file
	bpuStatsWrite("C", $timerStart, time());
	
	// Footer
	procWrite("C", "----------------------------------------------------");
	procWrite("C", ":: Iteration $masterCnt");
	procWrite("C", ":: Completed in $timerDiff seconds");
	procWrite("C", "----------------------------------------------------");

}

while ($masterCnt != ops("site_bpuIterationC")) {
	$masterCnt++;

	// Exit if stop command found
	if (@file_exists("../../apps/bpu/pid/allStop")) { echo "Exiting...\nThis BPU has been issued a stop command. Please use idsBackground.pl to issue the start command\n\n"; exit; }
	
	// Perform Loop
	cLoop();
	
	// Sleep
	sleep(ops("site_bpuSleepC"));
}

// Close Database Connections
$idsDB->close();

exit;

?>