<?php

/** Copyright 2009 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */

// Tell the system we are in processor mode
$processor = 1;

// Set some initital variables
$processorVersion = "5.0";

// Prepare environment
include "initialize.php";

function dLoop() {
	global $processorVersion, $masterCnt;

	// Start Timer
	$timerStart = date("U");
	
	procWrite("D", "RESET");
	
	procWrite("D", "----------------------------------------------------");
	procWrite("D", ":: Background Processing Unit D v$processorVersion");
	procWrite("D", ":: " . versionText());
	procWrite("D", ":: Date & Time " . date("r"));
	procWrite("D", "----------------------------------------------------");
	
	// Hold Check
	if (file_exists("../../tmp/holdD.tmp")) { procwrite("D", ":: ON HOLD -> Exiting");	exit; }
	
	// Search Processor
	BPU_searchProcessor();
	
	$timerDiff = date("U") - $timerStart;
	
	// Write BPU Stat file
	bpuStatsWrite("D", $timerStart, time());
	
	// Footer
	procWrite("D", "----------------------------------------------------");
	procWrite("D", ":: Iteration $masterCnt");
	procWrite("D", ":: Completed in $timerDiff seconds");
	procWrite("D", "----------------------------------------------------");
}

while ($masterCnt != 10) {
	$masterCnt++;

	// Exit if stop command found
	if (@file_exists("../../apps/bpu/pid/allStop")) { echo "Exiting...\nThis BPU has been issued a stop command. Please use idsBackground.pl to issue the start command\n\n"; exit; }
	
	// Perform Loop
	dLoop();
	
	// Sleep
	sleep(1);
}

// Close Database Connections
$idsDB->close();

exit;

?>
