<?php

/** Copyright 2010 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */

// Tell the system we are in processor mode
$processor = 1;

// Set some initital variables
$processorVersion = "6.0";

// Prepare environment
include "initialize.php";

function eLoop() {
	global $processorVersion, $masterCnt;

	// Start Timer
	$timerStart = date("U");
	
	procWrite("E", "RESET");
	
	procWrite("E", "----------------------------------------------------");
	procWrite("E", ":: Background Processing Unit E v$processorVersion");
	procWrite("E", ":: " . versionText());
	procWrite("E", ":: Date & Time " . date("r"));
	procWrite("E", "----------------------------------------------------");
	
	// Hold Check
	if (file_exists("../../tmp/holdE.tmp")) { procwrite("E", ":: ON HOLD -> Exiting");	exit; }
	
	// Search Processor
	processReportSchedule();
	
	$timerDiff = date("U") - $timerStart;
	
	// Write BPU Stat file
	bpuStatsWrite("E", $timerStart, time());
	
	// Footer
	procWrite("E", "----------------------------------------------------");
	procWrite("E", ":: Iteration $masterCnt");
	procWrite("E", ":: Completed in $timerDiff seconds");
	procWrite("E", "----------------------------------------------------");
}

while ($masterCnt != 5) {
	$masterCnt++;

	// Exit if stop command found
	if (@file_exists("../../apps/bpu/pid/allStop")) { echo "Exiting...\nThis BPU has been issued a stop command. Please use idsBackground.pl to issue the start command\n\n"; exit; }
	
	// Perform Loop
	eLoop();
	
	// Sleep
	sleep(5);
}

// Close Database Connections
$idsDB->close();

exit;

?>
