#!/usr/bin/perl -w

# USE
use English;
use Getopt::Long;
use POSIX;

# DEFINES
my $start;
my $stop;
my $help;

$aanvalAppsDir = `cd \`dirname $0\`;pwd`;
chop($aanvalAppsDir);

$vMajor = 5;
$vMinor = 0;
$vBuild = 500;

# OPTIONS
GetOptions (
		'start' => \$start,
		'stop' => \$stop,
		'help' => \$help
		);
		
# Ready set go!
launch();		
		
sub launch {

	my $run = 1;

	print "---\nAanval Background Processing Unit (BPU) Initializer\nVersion: $vMajor.$vMinor.$vBuild\n---\n";

	# PERL TEST
	$command = "perl";
	for $dir (split /:/, $ENV{PATH}) { 
	   last if ($existsP = (-x "$dir/$command")); 
	} 
	die "Fatal Error -> '$command' command not found. Ensure this command is in your path before continuing.\n" unless ($existsP); 	
	
	# PHP TEST
	$command = "php";
	for $dir (split /:/, $ENV{PATH}) { 
	   last if ($existsP = (-x "$dir/$command")); 
	} 
	die "Fatal Error -> '$command' command not found. Ensure this command is in your path before continuing.\n" unless ($existsP); 		
	
	if ($stop) {
		system("touch $aanvalAppsDir/bpu/pid/allStop");
		print "BPU STOP Requested\n\n";
		print "Issuing STOP command to all BPU's ... please wait ...\n";
		sleep(5);
		print "Finished (running BPU's may take a few moments to exit)\n";
		exit;
	}
	
	# Exit immediately if this launch isn't going anywhere
	if (!$start && !$help) { print "\nNothing to do. Try -help\n\n"; $run = 0; }
	
	# Display Help
	if ($help) { displayHelp(); $run = 0; }

	if ($run == 1) {
		
		# Remove allStop semaphore if exists
		if (-e "$aanvalAppsDir/bpu/pid/allStop") {
			system("rm -f $aanvalAppsDir/bpu/pid/allStop");
		}

        system("perl $aanvalAppsDir/bpu/idsProcessor.pl -start -U A");
        system("perl $aanvalAppsDir/bpu/idsProcessor.pl -start -U B");
        system("perl $aanvalAppsDir/bpu/idsProcessor.pl -start -U C");
        system("perl $aanvalAppsDir/bpu/idsProcessor.pl -start -U D");
        system("perl $aanvalAppsDir/bpu/idsProcessor.pl -start -U E");
        
	}

	exit;
}

sub displayHelp {

	print "Usage: perl idsBackground.pl [options]\n\n";
	
	print "-start       Start all Aanval Background Processors\n";
	print "-stop        Stop all Aanval Background Processors\n";
	print "-help        This Help Information\n";
	print "\n";
	print "Example: perl idsBackground.pl -start\n";
	print "\n";

}
