#!/usr/bin/perl -w

use IO::Socket;

$MAXLEN = 1024;
$PORTNO = 514;

$sock = IO::Socket::INET->new(LocalPort => $PORTNO, Proto => 'udp') or die "socket: $@";

print "\nAanval Syslog Server\n--> Started. Waiting for messages.\n";

while ($sock->recv($packet, $MAXLEN)) {
	my($port, $ipaddr) = sockaddr_in($sock->peername);
	$ip = inet_ntoa($ipaddr);
	
	chomp($packet);
	print "Aanval Syslog < [$ip]: $packet\n";

	open(MYFILE, ">>../syslog/indata_$ip.sys");
	print MYFILE "$packet\n";
	close(MYFILE);
}
