<?php

/** Copyright 2009 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */

class coreReport {
	
	function setVar($key, $value) {
		$this->s_vars[$key] = $value;
	}

	function getVar($key) {
		$this->s_vars[$key] = stripslashes($this->s_vars[$key]);
		return $this->s_vars[$key];
	}
		
	function coreReport() {
		
		if (login("login") == true) {
			$this->setVar("store", login("activeSearchStore"));
		} else {
			$this->setVar("store", ops("site_activeIndexStore"));
		}
		
	}
		
	function reportProcess(&$data, $search) {
		
		$searchObj = new coreSearch();
		$searchObj->setVar("store", $this->getVar("store"));
		
		if (!is_array($data)) {
			$data = array($data);
		}
		
		$this->setVar("maxRows", ops("site_reportDisplayRows"));
		
		$totalReportEvents = count($data);
		if (empty($data[0])) $totalReportEvents = 0;
		
		$searchTrimmed = $search;
		if (strlen($searchTrimmed) > 125) $searchTrimmed = substr($searchTrimmed, 0, 125) . "...";
		
		$xml = "<document>\n";
		$xml .= "\t<data>\n";

    	$tmpGenerated = timeDisplay(consoleTimeConversion(date("U")), 1);
    	
    	$tmpTextA .= "This document contains sensitive and / or confidential information, do not distribute, email, fax or transfer via any ";
    	$tmpTextA .= "electronic mechanism without proper authorization. Information contained within this document should be handled with appropriate ";
    	$tmpTextA .= "caution. While reasonable attempts have been made to confirm the accuracy of the data contained herein, ";
    	$tmpTextA .= "this console applications creators assume no liability for the completeness, use of, or conclusions drawn from this data.";
		
    	$tmpTextB .= "The objective of this report is to provide an accurate and comprehensive summary of search results using the criteria provided. ";
    	$tmpTextB .= "The following report should be reviewed to identify possible patterns in suspicious and anomalous activity presented in the following technical details. ";
    	$tmpTextB .= "This report was generated using the most accurate information available to the console at the time of generation.";

		$xml .= "\t\t<generatedText><![CDATA[" . $tmpGenerated . "]]></generatedText>\n";
		$xml .= "\t\t<confidentialText><![CDATA[" . $tmpTextA . "]]></confidentialText>\n";
		$xml .= "\t\t<objectiveText><![CDATA[" . $tmpTextB . "]]></objectiveText>\n";

		$xml .= "\t\t<searchText><![CDATA[" . $search . "]]></searchText>\n";
		$xml .= "\t\t<searchTextTrimmed><![CDATA[" . $searchTrimmed . "]]></searchTextTrimmed>\n";

		$xml .= "\t\t<reportStatistics>\n";
		$xml .= "\t\t\t<item>\n";
		$xml .= "\t\t\t\t<name>Total Events (in this report)</name>\n";
		$xml .= "\t\t\t\t<total>" . $totalReportEvents . "</total>\n";
		$xml .= "\t\t\t</item>\n";
		$xml .= "\t\t\t<item>\n";
		$xml .= "\t\t\t\t<name>Total Events (in current Data Store)</name>\n";
		$xml .= "\t\t\t\t<total>" . $searchObj->getTotalEventsInCurrentStore() . "</total>\n";
		$xml .= "\t\t\t</item>\n";
		$xml .= "\t\t</reportStatistics>\n";

		########################################################################
		// Sensor

		// Resets for each summary		
		$summaryTotal = 0;

		$xml .= "\t\t<sensorSummary>\n";

		$sensorArray = explode(",", login("sensors"));
		foreach ($sensorArray as $sensor) {
		
			$sensor = trim($sensor);

			$subTotal = 0;

			// Get ID's for this sensor
			$IDArray = $this->getIDsBySensor($sensor);
			
			// Intersect this sensors ID's with search results ID's
			$intersect = array_intersect($IDArray, $data);
			$subTotal = count($intersect);
			
			$summaryTotal += $subTotal;

			if (!ops("site_custom_snortGroup")) {

				$xml .= "\t\t\t<item>\n";
				$xml .= "\t\t\t\t<name><![CDATA[" . getSensorNameByID($sensor) . "]]></name>\n";
				$xml .= "\t\t\t\t<total>" . $subTotal . "</total>\n";
				$xml .= "\t\t\t</item>\n";
				
			} else {

				// custom grouping

				$xml .= "\t\t\t<item>\n";
				$xml .= "\t\t\t\t<name><![CDATA[" . $sensor . "]]></name>\n";
				$xml .= "\t\t\t\t<total>" . $subTotal . "</total>\n";
				$xml .= "\t\t\t</item>\n";
			
			}
		
		}

		$xml .= "\t\t\t<total>" . $summaryTotal . "</total>\n";
					
		$xml .= "\t\t</sensorSummary>\n";

		########################################################################
		// Priority

		// Resets for each summary		
		$summaryTotal = 0;

		$xml .= "\t\t<prioritySummary>\n";
		
		$priorityArray = array(1,2,3,4,5);
		foreach ($priorityArray as $priority) {
		
			$subTotal = 0;

			// Get ID's for this sensor
			$IDArray = $this->getIDsByPriority($priority);
			
			// Intersect this priority ID's with search results ID's
			$intersect = array_intersect($IDArray, $data);
			$subTotal = count($intersect);
			
			$summaryTotal += $subTotal;

			$xml .= "\t\t\t<item>\n";
			$xml .= "\t\t\t\t<name><![CDATA[" . $priority . "]]></name>\n";
			$xml .= "\t\t\t\t<total>" . $subTotal . "</total>\n";
			$xml .= "\t\t\t</item>\n";

		}

		$xml .= "\t\t\t<total>" . $summaryTotal . "</total>\n";
		
		$xml .= "\t\t</prioritySummary>\n";

		########################################################################
		// Module

		// Resets for each summary		
		$summaryTotal = 0;

		$xml .= "\t\t<moduleSummary>\n";
		
		$moduleArray = array(1,2);
		foreach ($moduleArray as $module) {
		
			$subTotal = 0;

			// Get ID's for this sensor
			$IDArray = $this->getIDsByModule($module);
			
			// Intersect this priority ID's with search results ID's
			$intersect = array_intersect($IDArray, $data);
			$subTotal = count($intersect);
			
			$summaryTotal += $subTotal;

			$xml .= "\t\t\t<item>\n";
			$xml .= "\t\t\t\t<name><![CDATA[" . getModuleNameByType($module) . "]]></name>\n";
			$xml .= "\t\t\t\t<total>" . $subTotal . "</total>\n";
			$xml .= "\t\t\t</item>\n";

		}

		$xml .= "\t\t\t<total>" . $summaryTotal . "</total>\n";
		
		$xml .= "\t\t</moduleSummary>\n";

		########################################################################
		// Signature

		// Resets for each summary		
		$summaryTotal = 0;

		$xml .= "\t\t<signatureSummary>\n";
		
		$dataArray = $this->getSignatureSummaryTotals($data);
		
		foreach ($dataArray as $item => $cnt) {
		
			$xml .= "\t\t\t<item>\n";
			$xml .= "\t\t\t\t<name><![CDATA[" . $item . "]]></name>\n";
			$xml .= "\t\t\t\t<total>" . $cnt . "</total>\n";
			$xml .= "\t\t\t</item>\n";

			$summaryTotal += $cnt;

		}
			
		$xml .= "\t\t\t<total>" . $summaryTotal . "</total>\n";
		
		$xml .= "\t\t</signatureSummary>\n";
		
		########################################################################
		// Class

		// Resets for each summary		
		$summaryTotal = 0;

		$xml .= "\t\t<classSummary>\n";
		
		$dataArray = $this->getClassSummaryTotals($data);
		
		foreach ($dataArray as $item => $cnt) {
		
			$xml .= "\t\t\t<item>\n";
			$xml .= "\t\t\t\t<name><![CDATA[" . $item . "]]></name>\n";
			$xml .= "\t\t\t\t<total>" . $cnt . "</total>\n";
			$xml .= "\t\t\t</item>\n";

			$summaryTotal += $cnt;

		}
			
		$xml .= "\t\t\t<total>" . $summaryTotal . "</total>\n";
		
		$xml .= "\t\t</classSummary>\n";
		
		########################################################################
		// Protocol

		// Resets for each summary		
		$summaryTotal = 0;

		$xml .= "\t\t<protocolSummary>\n";
		
		$protocolArray = array(1,2);
		foreach ($protocolArray as $protocol) {
		
			$subTotal = 0;

			// Get ID's for this sensor
			$IDArray = $this->getIDsByProtocol($protocol);
			
			// Intersect this priority ID's with search results ID's
			$intersect = array_intersect($IDArray, $data);
			$subTotal = count($intersect);
			
			$summaryTotal += $subTotal;

			$xml .= "\t\t\t<item>\n";
			$xml .= "\t\t\t\t<name><![CDATA[" . protoToName($protocol) . "]]></name>\n";
			$xml .= "\t\t\t\t<total>" . $subTotal . "</total>\n";
			$xml .= "\t\t\t</item>\n";

		}

		$xml .= "\t\t\t<total>" . $summaryTotal . "</total>\n";
		
		$xml .= "\t\t</protocolSummary>\n";
		
		########################################################################
		// Source Port

		// Resets for each summary		
		$summaryTotal = 0;

		$xml .= "\t\t<sportSummary>\n";
		
		$dataArray = $this->getSportSummaryTotals($data);
		
		foreach ($dataArray as $item => $cnt) {
		
			$xml .= "\t\t\t<item>\n";
			$xml .= "\t\t\t\t<name><![CDATA[" . $item . "]]></name>\n";
			$xml .= "\t\t\t\t<total>" . $cnt . "</total>\n";
			$xml .= "\t\t\t</item>\n";

			$summaryTotal += $cnt;

		}
			
		$xml .= "\t\t\t<total>" . $summaryTotal . "</total>\n";
		
		$xml .= "\t\t</sportSummary>\n";	
		
		########################################################################
		// Destination Port

		// Resets for each summary
		$summaryTotal = 0;

		$xml .= "\t\t<dportSummary>\n";
		
		$dataArray = $this->getDportSummaryTotals($data);
		
		foreach ($dataArray as $item => $cnt) {
		
			$xml .= "\t\t\t<item>\n";
			$xml .= "\t\t\t\t<name><![CDATA[" . $item . "]]></name>\n";
			$xml .= "\t\t\t\t<total>" . $cnt . "</total>\n";
			$xml .= "\t\t\t</item>\n";

			$summaryTotal += $cnt;

		}
			
		$xml .= "\t\t\t<total>" . $summaryTotal . "</total>\n";
		
		$xml .= "\t\t</dportSummary>\n";
		
		########################################################################
		// Source IP

		// Resets for each summary		
		$summaryTotal = 0;

		$xml .= "\t\t<sipSummary>\n";
		
		$dataArray = $this->getSipSummaryTotals($data);
		
		foreach ($dataArray as $item => $cnt) {
		
			$xml .= "\t\t\t<item>\n";
			$xml .= "\t\t\t\t<name><![CDATA[" . longToIP($item) . "]]></name>\n";
			$xml .= "\t\t\t\t<total>" . $cnt . "</total>\n";
			$xml .= "\t\t\t</item>\n";

			$summaryTotal += $cnt;

		}
			
		$xml .= "\t\t\t<total>" . $summaryTotal . "</total>\n";
		
		$xml .= "\t\t</sipSummary>\n";	
		
		########################################################################
		// Destination IP

		// Resets for each summary
		$summaryTotal = 0;

		$xml .= "\t\t<dipSummary>\n";
		
		$dataArray = $this->getDipSummaryTotals($data);
		
		foreach ($dataArray as $item => $cnt) {

			$xml .= "\t\t\t<item>\n";
			$xml .= "\t\t\t\t<name><![CDATA[" . longToIP($item) . "]]></name>\n";
			$xml .= "\t\t\t\t<total>" . $cnt . "</total>\n";
			$xml .= "\t\t\t</item>\n";
		
			$summaryTotal += $cnt;

		}
			
		$xml .= "\t\t\t<total>" . $summaryTotal . "</total>\n";
		
		$xml .= "\t\t</dipSummary>\n";				

		$xml .= "\t</data>\n";
		$xml .= "</document>\n";

		return $xml;
	}
	
	function getIDsBySensor($sensor) {
		global $idsDB;
	
		if (!ops("site_custom_snortGroup")) {

			$idsQueryA = $idsDB->query("SELECT mas.id FROM idsDataStore_" . $this->getVar("store") . "_Master as mas LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Events as evt on (mas.id = evt.id) where mas.sensorID = '$sensor'");
		
		} else {
		
			// custom grouping
		
			$idsQueryA = $idsDB->query("SELECT mas.id FROM idsDataStore_" . $this->getVar("store") . "_Master as mas LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Events as evt on (mas.id = evt.id) where evt.customGrouping RLIKE REPLACE ( REPLACE ( REPLACE ('$sensor','+','[+]'), ' ', ''), ',', '|')");
		
		}			
			
		while ($row = mysql_fetch_array($idsQueryA, MYSQL_ASSOC)) {
	
			foreach ($row as $key => $val) {
		
				$idArray[] = $val;
		
			}
			
		}
	
		return $idArray;
	
	}
	
	function getIDsByPriority($priority) {
		global $idsDB;
	
		$idsQueryA = $idsDB->query("SELECT mas.id FROM idsDataStore_" . $this->getVar("store") . "_Master as mas LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Events as evt on (mas.id = evt.id) where evt.priority = '$priority'");
		while ($row = mysql_fetch_array($idsQueryA, MYSQL_ASSOC)) {
	
			foreach ($row as $key => $val) {
		
				$idArray[] = $val;
		
			}
			
		}
	
		return $idArray;
	
	}
	
	function getIDsByModule($module) {
		global $idsDB;
	
		$idsQueryA = $idsDB->query("SELECT mas.id FROM idsDataStore_" . $this->getVar("store") . "_Master as mas LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Events as evt on (mas.id = evt.id) where mas.moduleID = '$module'");
		while ($row = mysql_fetch_array($idsQueryA, MYSQL_ASSOC)) {
	
			foreach ($row as $key => $val) {
		
				$idArray[] = $val;
		
			}
			
		}
	
		return $idArray;
	
	}	
	
	function getIDsByProtocol($protocol) {
		global $idsDB;
	
		$idsQueryA = $idsDB->query("SELECT mas.id FROM idsDataStore_" . $this->getVar("store") . "_Master as mas LEFT JOIN idsDataStore_" . $this->getVar("store") . "_Events as evt on (mas.id = evt.id) where evt.protocol = '$protocol'");
		while ($row = mysql_fetch_array($idsQueryA, MYSQL_ASSOC)) {
	
			foreach ($row as $key => $val) {
		
				$idArray[] = $val;
		
			}
			
		}
	
		return $idArray;
	
	}	
	
	function getSignatureSummaryTotals(&$data) {
		global $idsDB;

		$idsQueryA = $idsDB->query("SELECT count(evt.id) as cnt, evt.signatureName, evt.signature FROM idsDataStore_" . $this->getVar("store") . "_Events as evt where evt.id in (" . implode(", ", $data) . ") group by evt.signatureName order by cnt desc limit " . $this->getVar("maxRows"));
		while ($row = mysql_fetch_array($idsQueryA)) {
		
			$dataArray[$row[1] . " [" . $row[2] . "]"] = $row[0];
		
		}

		return $dataArray;
	
	}
	
	function getClassSummaryTotals(&$data) {
		global $idsDB;

		$idsQueryA = $idsDB->query("SELECT count(evt.id) as cnt, evt.className, evt.class FROM idsDataStore_" . $this->getVar("store") . "_Events as evt where evt.id in (" . implode(", ", $data) . ") group by evt.className order by cnt desc limit " . $this->getVar("maxRows"));
		while ($row = mysql_fetch_array($idsQueryA)) {
		
			$dataArray[$row[1] . " [" . $row[2] . "]"] = $row[0];
		
		}

		return $dataArray;
	
	}		
	
	function getSportSummaryTotals(&$data) {
		global $idsDB;

		$idsQueryA = $idsDB->query("SELECT count(evt.id) as cnt, evt.sport FROM idsDataStore_" . $this->getVar("store") . "_Events as evt where evt.id in (" . implode(", ", $data) . ") group by evt.sport order by cnt desc limit " . $this->getVar("maxRows"));
		while ($row = mysql_fetch_array($idsQueryA)) {
		
			$dataArray[$row[1]] = $row[0];
		
		}

		return $dataArray;
	
	}		

	function getDportSummaryTotals(&$data) {
		global $idsDB;

		$idsQueryA = $idsDB->query("SELECT count(evt.id) as cnt, evt.dport FROM idsDataStore_" . $this->getVar("store") . "_Events as evt where evt.id in (" . implode(", ", $data) . ") group by evt.dport order by cnt desc limit " . $this->getVar("maxRows"));
		while ($row = mysql_fetch_array($idsQueryA)) {
		
			$dataArray[$row[1]] = $row[0];
		
		}

		return $dataArray;
	
	}		
	
	function getSipSummaryTotals(&$data) {
		global $idsDB;

		$idsQueryA = $idsDB->query("SELECT count(evt.id) as cnt, evt.sip FROM idsDataStore_" . $this->getVar("store") . "_Events as evt where evt.id in (" . implode(", ", $data) . ") group by evt.sip order by cnt desc limit " . $this->getVar("maxRows"));
		while ($row = mysql_fetch_array($idsQueryA)) {
		
			$dataArray[$row[1]] = $row[0];
		
		}

		return $dataArray;
	
	}		

	function getDipSummaryTotals(&$data) {
		global $idsDB;

		$idsQueryA = $idsDB->query("SELECT count(evt.id) as cnt, evt.dip FROM idsDataStore_" . $this->getVar("store") . "_Events as evt where evt.id in (" . implode(", ", $data) . ") group by evt.dip order by cnt desc limit " . $this->getVar("maxRows"));
		while ($row = mysql_fetch_array($idsQueryA)) {
		
			$dataArray[$row[1]] = $row[0];
		
		}

		return $dataArray;
	
	}			
	
}

?>