<?php

/** Copyright 2009 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */
 
class snortPort {

	function processSnortRange($sid, $sensorID, $lastTimestamp, $runMax, $truncateEnabled, $runType = 0, $lastCID = 0) {
		global $idsDB;
		
		$dataStoreObj = new dataStore();
		$indexerObj = new indexer();
		
		$counter = 0;

		// Risk scaling variable
		$riskRankTop = ops("site_riskRankTop");
		
		$riskArray = signatureRiskLoad();
		
        // Instantiate new module object
		$idsQueryA = $idsDB->query("SELECT * FROM idsModules where id = '1'");
		while ($row = mysql_fetch_array($idsQueryA, MYSQL_ASSOC)) {
			foreach ($row as $key => $val) {
				$modArray[$key] = $val;
			}
		}
			
		$moduleDB = new moduleDB();
		$moduleDB->load($modArray);
	        
		$Query = $moduleDB->query("SELECT vseq FROM `schema` order by vseq desc limit 1");
        for ($t = 0; $row = @mysql_fetch_row($Query); $t++) {
        	$schema = $row[0];
        }
        
		if (ops("site_custom_snortGroup") == 1) {
			$customGroupingQueryString = ", evt.`group` ";
		} else {
			$customGroupingQueryString = ", evt.cid as noCustomGroup ";
		}
        
		if ($schema >= 107) {
			$sig_gidQueryString = ", sig.sig_gid ";
		} else {
			$sig_gidQueryString = ", evt.cid as oldSchema ";
		}
        
        // $runType Query Set
        if ($runType == 0) {
	    	$Query = $moduleDB->query("SELECT evt.cid, evt.sid, UNIX_TIMESTAMP(evt.timestamp), sig.sig_sid, sig.sig_name, sig.sig_class_id, sig.sig_priority, cls.sig_class_name, iph.ip_src, iph.ip_dst, iph.ip_proto, iph.ip_ver, iph.ip_hlen, iph.ip_tos, iph.ip_len, iph.ip_id, iph.ip_flags, iph.ip_off, iph.ip_ttl, iph.ip_csum, opt.opt_proto, opt.opt_code, opt.opt_len, opt.opt_data, data.data_payload, tcp.tcp_sport, tcp.tcp_dport, tcp.tcp_seq, tcp.tcp_ack, tcp.tcp_off, tcp.tcp_res, tcp.tcp_flags, tcp.tcp_win, tcp.tcp_csum, tcp.tcp_urp, icmp.icmp_type, icmp.icmp_code, icmp.icmp_csum, icmp.icmp_id, icmp.icmp_seq, udp.udp_sport, udp.udp_dport, udp.udp_len, udp.udp_csum $customGroupingQueryString $sig_gidQueryString FROM event as evt LEFT JOIN signature as sig on (evt.signature = sig.sig_id) LEFT JOIN sig_class as cls on (sig.sig_class_id = cls.sig_class_id) LEFT JOIN iphdr as iph on (evt.sid = iph.sid and evt.cid = iph.cid) LEFT JOIN tcphdr as tcp on (evt.sid = tcp.sid and evt.cid = tcp.cid) LEFT JOIN icmphdr as icmp on (evt.sid = icmp.sid and evt.cid = icmp.cid) LEFT JOIN udphdr as udp on (evt.sid = udp.sid and evt.cid = udp.cid) LEFT JOIN opt on (evt.sid = opt.sid and evt.cid = opt.cid) LEFT JOIN data on (evt.sid = data.sid and evt.cid = data.cid) WHERE UNIX_TIMESTAMP(evt.timestamp) > $lastTimestamp and evt.sid = '$sid' order by evt.timestamp limit $runMax");
        } else {
	    	$Query = $moduleDB->query("SELECT evt.cid, evt.sid, UNIX_TIMESTAMP(evt.timestamp), sig.sig_sid, sig.sig_name, sig.sig_class_id, sig.sig_priority, cls.sig_class_name, iph.ip_src, iph.ip_dst, iph.ip_proto, iph.ip_ver, iph.ip_hlen, iph.ip_tos, iph.ip_len, iph.ip_id, iph.ip_flags, iph.ip_off, iph.ip_ttl, iph.ip_csum, opt.opt_proto, opt.opt_code, opt.opt_len, opt.opt_data, data.data_payload, tcp.tcp_sport, tcp.tcp_dport, tcp.tcp_seq, tcp.tcp_ack, tcp.tcp_off, tcp.tcp_res, tcp.tcp_flags, tcp.tcp_win, tcp.tcp_csum, tcp.tcp_urp, icmp.icmp_type, icmp.icmp_code, icmp.icmp_csum, icmp.icmp_id, icmp.icmp_seq, udp.udp_sport, udp.udp_dport, udp.udp_len, udp.udp_csum $customGroupingQueryString $sig_gidQueryString FROM event as evt LEFT JOIN signature as sig on (evt.signature = sig.sig_id) LEFT JOIN sig_class as cls on (sig.sig_class_id = cls.sig_class_id) LEFT JOIN iphdr as iph on (evt.sid = iph.sid and evt.cid = iph.cid) LEFT JOIN tcphdr as tcp on (evt.sid = tcp.sid and evt.cid = tcp.cid) LEFT JOIN icmphdr as icmp on (evt.sid = icmp.sid and evt.cid = icmp.cid) LEFT JOIN udphdr as udp on (evt.sid = udp.sid and evt.cid = udp.cid) LEFT JOIN opt on (evt.sid = opt.sid and evt.cid = opt.cid) LEFT JOIN data on (evt.sid = data.sid and evt.cid = data.cid) WHERE UNIX_TIMESTAMP(evt.timestamp) = $lastTimestamp and evt.cid > $lastCID and evt.sid = '$sid' order by evt.timestamp");
        }

        for ($t = 0; $row = @mysql_fetch_row($Query); $t++) {

			$cid = $row[0];

			$result["eventID"] = $row[0];
			$result["sensor"] = $row[1];
			$result["timestamp"] = $row[2];
			$result["signature"] = $row[3];
			$result["signatureName"] = $row[4];
			$result["class"] = $row[5];
			$result["priority"] = $row[6];
			$result["className"] = $row[7];
			$result["sip"] = $row[8];
			$result["dip"] = $row[9];
			$result["protocol"] = $row[10];
			$result["ip_ver"] = $row[11];
			$result["ip_hlen"] = $row[12];
			$result["ip_tos"] = $row[13];
			$result["ip_len"] = $row[14];
			$result["ip_id"] = $row[15];
			$result["ip_flags"] = $row[16];
			$result["ip_off"] = $row[17];
			$result["ip_ttl"] = $row[18];
			$result["ip_csum"] = $row[19];
			$result["opt_proto"] = $row[20];
			$result["opt_code"] = $row[21];
			$result["opt_len"] = $row[22];
			$result["opt_data"] = $row[23];
			$result["payload"] = $row[24];

			if ($result["protocol"] == "6") {

				$result["sport"] = $row[25];
				$result["dport"] = $row[26];
				$result["hdr_seq"] = $row[27];
				$result["hdr_ack"] = $row[28];
				$result["hdr_off"] = $row[29];
				$result["hdr_res"] = $row[30];
				$result["hdr_flags"] = $row[31];
				$result["hdr_win"] = $row[32];
				$result["hdr_csum"] = $row[33];
				$result["hdr_urp"] = $row[34];
				
			} else if ($result["protocol"] == "1") {
			
				$result["hdr_type"] = $row[35];
				$result["hdr_code"] = $row[36];
				$result["hdr_csum"] = $row[37];
				$result["hdr_id"] = $row[38];
				$result["hdr_seq"] = $row[39];
			
			} else if ($result["protocol"] == "17") {
			
				$result["sport"] = $row[40];
				$result["dport"] = $row[41];
				$result["hdr_len"] = $row[42];
				$result["hdr_csum"] = $row[43];
			
			}
			
			// Custom grouping feature

			if (ops("site_custom_snortGroup") == 1) {
				$result["customGrouping"] = strtolower($row[44]);
			}
			
			// Ensure schema is high enough
			
			if ($schema >= 107) {
				$result["gid"] = $row[45];
			}

	        // Signature to risk table lookup
	        $tmpA = signatureRiskLookup($riskArray, $result["signature"], $result["signatureName"]);
			if ($tmpA != 0) $result["priority"] = $tmpA;

	        // Risk level scaling
	       	$result["priority"] = snortRiskScaleOmatic($riskRankTop, $result["priority"]);
			
			$lastTimestamp = $result["timestamp"];
			
	        $counter++;

	        // Set Results
    		$masterDataArray["sensorID"] = $sensorID;
			$masterDataArray["moduleID"] = 1;
			$masterDataArray["enabled"] = 1;

			$eventMasterID = $this->writeMasterRecord($masterDataArray);

			$result["id"] = $eventMasterID;

			$this->writeEventRecord($result);

	    	// Delete events if truncate option is selected
	        if ($truncateEnabled == 1) {
	            $dquery = $moduleDB->query("delete from data where cid = " . $row[0] . " and sid = $sid");
	            $dquery = $moduleDB->query("delete from event where cid = " . $row[0] . " and sid = $sid");
	            $dquery = $moduleDB->query("delete from iphdr where cid = " . $row[0] . " and sid = $sid");
	            $dquery = $moduleDB->query("delete from icmphdr where cid = " . $row[0] . " and sid = $sid");
	            $dquery = $moduleDB->query("delete from tcphdr where cid = " . $row[0] . " and sid = $sid");
	            $dquery = $moduleDB->query("delete from udphdr where cid = " . $row[0] . " and sid = $sid");
	            $dquery = $moduleDB->query("delete from opt where cid = " . $row[0] . " and sid = $sid");
	        } 	
	        
			$assocEventDataArray[] = array_merge($masterDataArray, $result);
			
			unset($masterDataArray, $tmpA, $result);
    	}
	    
    	$moduleDB->close();

        $indexerObj->indexMultipleEvents($assocEventDataArray, ops("site_activeDataStore"));
    	
        // Protect integrity of processor if no events were processed this run (prevents cycling of existing events)
        $data[] = $lastTimestamp;
		$data[] = $counter;
		$data[] = $cid;
		
        return $data;
	}	

	function writeEventRecord($dataArray) {
		global $idsDB;
	
		foreach ($dataArray as $field => $value) {
		
			$fieldArray[] = $field;
			$valueArray[] = "'$value'";
	
		}
		
		$fieldString = implode(", ", $fieldArray);
		$valueString = implode(", ", $valueArray);
		
		$idsQueryA = $idsDB->query("INSERT INTO idsDataStore_" . ops("site_activeDataStore") . "_Events ($fieldString) VALUES ($valueString)");
	
	}
	
	function writeMasterRecord($dataArray) {
		global $idsDB;
	
		foreach ($dataArray as $field => $value) {
		
			$fieldArray[] = $field;
			$valueArray[] = "'$value'";
	
		}
		
		$fieldString = implode(", ", $fieldArray);
		$valueString = implode(", ", $valueArray);
		
		$idsQueryA = $idsDB->query("INSERT INTO idsDataStore_" . ops("site_activeDataStore") . "_Master ($fieldString) VALUES ($valueString)");
	
		return mysql_insert_id($idsDB->link);	
	
	}
		
}

?>