<?php

/** Copyright 2009 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */

class unifiedSnort {
	
 	var $logFields = array('gid', 'sid', 'rev', 'classtype', 'priority', 'event_id', 'reference', 'tv_sec', 'tv_usec', 'flags', 'pkt_sec', 'pkt_usec', 'caplen', 'pktlen', 'pkt');
 	var $alertFields = array('gid', 'sid', 'rev', 'classtype', 'priority', 'event_id', 'reference', 'tv_sec', 'tv_usec', 'tv_sec2', 'tv_usec2', 'source_ip', 'destination_ip', 'source_port', 'destination_port', 'protocol', 'flags');

	var $fp;
	var $type;
	var $endian;

	var $record_size;
	var $pack_record;
	var $pack_header;
	var $fields;
	
	var $versionHeader;
	
	function setVar($key, $value) {
		$this->s_vars[$key] = $value;
	}

	function getVar($key) {
		return $this->s_vars[$key];
	}	
	
	function initialize($filename) {
		global $fp, $logFields, $alertFields, $type, $endian, $fields, $record_size, $pack_header, $pack_record;
		
		$fp = fopen($filename, "r");
 		
		$this->setVar("magic", fread($fp, 4));

		switch ($this->getVar("magic")) {
			case "\x80\x10\xad\xde":
				
				// Log (little)
				$this->setVar("type", "log");
				$this->setVar("endian", "little");
				
				break;
	
			case "\xde\xad\x10\x80":
	
				// Log (Big)
				$this->setVar("type", "log");
				$this->setVar("endian", "big");
				
				break;
	
			case "\x37\x41\xad\xde":
				
				// Alert (little)	
				$this->setVar("type", "alert");
				$this->setVar("endian", "little");
				
				break;
			
			case "\xde\xad\x41\x37":
				
				// Alert (Big)
				$this->setVar("type", "alert");
				$this->setVar("endian", "big");
				
				break;
				
			default:
	
				return 2;
				break;
		}	
	
		switch ($this->getVar("type")) {
			case "log":
				
                $this->setVar("record_size", (14 * 4));
                $this->setVar("pack_record", 'V14');
                $this->setVar("pack_header", 'vMajor/vMinor/V4');
                $this->setVar("fields", $logFields);
                
				break;
	
			case "alert":
	
                $this->setVar("record_size", (15 * 4) + (2 * 2));
                $this->setVar("pack_record", 'V13Alpha/v2Bravo/V2Charlie');
                $this->setVar("pack_header", 'VMajor/VMinor/VTimezone');
                $this->setVar("fields", $alertFields);
				
                break;
                
			default:
	
				echo "Wrong Type; Error!\n";
				
				break;
		}			
		
		dbLog("Unified Log Processor", "Open Unified Log", 0, $filename);
		dbLog("Unified Log Processor", "Discovery", 0, "Type: " . $this->getVar("type") . " Endian: " . $this->getVar("endian"));
		
		$this->header();
	}
	
	function header() {
		global $fp;
		
		switch ($this->getVar("type")) {
			case "log":
				
				$tmp = fread($fp, 20);
				$tmp = unpack($this->getVar("pack_header"), $tmp);
				$this->setVar("versionHeader", $tmp["Major"] . "." . $tmp["Minor"]);
				
				break;
	
			case "alert":
	
				$tmp = fread($fp, 12);
				$tmp = unpack($this->getVar("pack_header"), $tmp);
				$this->setVar("versionHeader", $tmp["Major"] . "." . $tmp["Minor"]);
				
                break;
                
			default:
	
				echo "Invalid Header; Error!\n";
				
				break;
		}				
		
		dbLog("Unified Log Processor", "Get Header", 0, $tmp["Major"] . "." . $tmp["Minor"]);
		
	}
	
	function seekTo() {
		global $fp;
		
		if ($this->getVar("startByte")) {
			
			fseek($fp, $this->getVar("startByte"));
			
			if (feof($fp)) {
		        procWrite("A", " . EOF Detected: $filename");
				return 3;
			}
			
	        procWrite("A", " . Seeking: " . $this->getVar("startByte"));
		}
		
	}
	
	function record() {
		global $fp;
		
		if ($this->getVar("type") == "alert") {
		
			$data = fread($fp, $this->getVar("record_size"));
			$tmp = unpack($this->getVar("pack_record"), $data);
			
		} else if ($this->getVar("type") == "log") {

			$data = fread($fp, $this->getVar("record_size"));
			
			if ($data) {
			
				$tmp = unpack($this->getVar("pack_record"), $data);
				
				$data1 = fread($fp, $tmp[13]);
#				$tmp1 = unpack("V", $data1);
#				$tmp[15] = $tmp1[1];
			}
			
		}

		$this->setVar("lastByte", ftell($fp));
		
		return $tmp;
		
	}
}

?>