<?php

/** Copyright 2010 Tactical FLEX
 *
 * Aanval 5
 *
 * This program is owned and licensed by Tactical FLEX; it may be
 * redistributed only in its original configuration as originally
 * installed and available by Tactical FLEX and / or Aanval.
 *
 * To license and / or include this product in other forms or
 * applications, express prior written authorization must be
 * obtained by contract from authorized Tactical FLEX or Aanval agents.
 *
 * Tactical FLEX and Aanval may not be held liable nor responsible
 * for any and all issues arising from the use of, damages caused by, or 
 * conclusions drawn from the use of this product.
 *
 */

function importUnifiedSnort($sensorID) {
	global $flashWriteCount, $idsDB, $root_path;

	$counter = 0;
	
	$dataStoreObj = new dataStore();
	procWrite("A", " . . Using DataStore: " . ops("site_activeDataStore"));

    // Instantiate new module object
    $moduleDB = new moduleDB;
    $moduleDB->loadDB(1);
	
    // Create Sensor Object
    $objSensor = new mySensor();
    
    // Load sensor information
    $objSensor->loadSensor($sensorID);
    
    // Load run limit
    $runMax = ops("site_processorEventRun");

    // Load sid-msg.map
    $sidArray = loadSidMsgMap($sensorID);
    
	if (!$objSensor->getSensorVar("tracker1")) {
		$tmp = getUnifiedFileArray($sensorID);
		$objSensor->setSensorVar("tracker1", $tmp[0]);
	}

    procWrite("A", " . Processing: " . $objSensor->getSensorVar("tracker1"));
    procWrite("A", " . Seek: " . $objSensor->getSensorVar("tracker2"));
	
    // Instantiate Class
	$unified = new unifiedSnort();

	// Initialize Unified System
	$returnCode = $unified->initialize($objSensor->getSensorVar("tracker1"));
    if ($returnCode) procWrite("A", " . Initialize Code: $returnCode");

	if ($returnCode == 2) {
	    procWrite("A", " . Bad Header: " . $objSensor->getSensorVar("tracker1"));
	    procWrite("A", " . Triggering Next File");

	    $tmpNewFile = getNextUnifiedFile($objSensor->getSensorVar("tracker1"), $sensorID);
	    if ($tmpNewFile == $objSensor->getSensorVar("tracker1")) {

		    procWrite("A", " . No Change, Still Using: " . $objSensor->getSensorVar("tracker1"));
	    	
	    } else {
	    	
		    procWrite("A", " . New File: " . $objSensor->getSensorVar("tracker1"));
		    $objSensor->setSensorVar("tracker1", $tmpNewFile);
		    $objSensor->setSensorVar("tracker2", 0);
	    }
	    
	}

	// Set Start Byte Location
	$unified->setVar("startByte", $objSensor->getSensorVar("tracker2"));

	$unified->seekTo();
	
	// Loop
	for ($i=0;$i<$runMax;$i++) {

		$record = $unified->record();
		if (!$record) break;

		if ($unified->getVar("type") == "alert") {
#				$fields = array('gid', 'sid', 'rev', 'classtype', 'priority', 'event_id', 'reference', 'tv_sec', 'tv_usec', 'tv_sec2', 'tv_usec2', 'source_ip', 'destination_ip', 'source_port', 'destination_port', 'protocol', 'flags');	
			$fields = array('sig_gid', 'sig_sid', 'sig_rev', 'sig_class', 'sig_priority', 'sig_cid', 'sig_reference', 'tv_sec', 'tv_usec', 'tv_sec2', 'tv_usec2', 'src', 'dst', 'sport', 'dport', 'ip_proto', 'flags');	
		} else {
		 	$fields = array('gid', 'sid', 'rev', 'classtype', 'priority', 'event_id', 'reference', 'tv_sec', 'tv_usec', 'flags', 'pkt_sec', 'pkt_usec', 'caplen', 'pktlen');
		}

		$result = array_combine($fields, $record);
		
		$lastTimestamp = $result["timestamp"];
	    $flashWriteCount++;
	    $counter++;

	    // Risk level scaling
	    $result["sig_priority"] = snortRiskScaleOmatic($riskRankTop, $result["sig_priority"]);

	    // Set Default Risk Level
		if (!$result["sig_priority"]) $result["sig_priority"] = 5;
	    
	    // Set Results
		$result["datastore"] = "1.1";
		$result["unified_file"] = $objSensor->getSensorVar("path") . "/" . $objSensor->getSensorVar("tracker1");
		$result["unified_version"] = $unified->getVar("versionHeader");
		$result["timestamp"] = $result["tv_sec"];
		$result["intime"] = date("U");
		$result["module"] = 1;
		$result["enabled"] = 1;
		$result["sensorid"] = $sensorID;

		// Custom Sig Sid Data
		$tmpData = explode(" || ", $sidArray[$result["sig_sid"]]);
		
			$tmpChunk = explode(" ", $tmpData[1]);
			$sigClassName = $tmpChunk[0];
			$sigName = $tmpData[1];
			
			$result["sig_name"] = $sigName;
			$result["sig_class_name"] = $sigClassName;
		
		$result["misc1"] = "";
		$result["misc2"] = "";
		$result["misc3"] = "";
		$result["misc4"] = "";
		$result["misc5"] = "";
		$result["xcol1"] = "";
		$result["xcol2"] = "";
		$result["xcol3"] = "";
		$result["xcol4"] = "";
		$result["xcol5"] = "";

		// Write Data
		$dataStoreObj->writeDiskEventData($result);
	
		$cid = $result["sig_cid"];
		
		unset($record, $result, $sigClassName, $sigName, $tmpChunk, $tmpData);
		
	}
    
	$dataStoreObj->saveEventID();
	
	$moduleDB->close();
    
	// Set Trackers
#	$objSensor->setSensorVar("tracker1", $file);
	$objSensor->setSensorVar("tracker2", $unified->getVar("lastByte"));
	
    // Protect integrity of processor if no events were processed this run (prevents cycling of existing events)
    $data[] = $lastTimestamp;
	$data[] = $counter;
	$data[] = $cid;
	
    return $data;
    
}

function getUnifiedFileArray($sensorID) {
	
    // Create Sensor Object
    $objSensor = new mySensor();
    
    // Load sensor information
    $objSensor->loadSensor($sensorID);
	
    $userFullPath = $objSensor->getSensorVar("path");

    $userBasePath = str_replace("snort.alert", "", $userFullPath);
    $userBasePath = str_replace("snort.log", "", $userBasePath);
    
    $userFile = str_replace("$userBasePath", "", $userFullPath);
    
	// Check to ensure ops variable is not empty
	if ($userBasePath != "") {

		// Open unified directory and check for error
		if (!$this_dir = @dir("$userBasePath")) {
		    procWrite("A", " ! Path Error: $userBasePath could not be opened. Please check your  /conf/conf.php settings to resolve this issue.");
		} else {
			
	    	// Loop through files
	        while ($file = $this_dir->read()) {
	        	// Only check files which are NOT . and ..
	        	
		        if ($file != "." && $file != "..") {
	    	        if (strstr($file, $userFile)) {
	                    $fileArray[] = "$userBasePath$file";
	                    $epochArray[] = substr($file, -10);
	                }
	            }
		    }
		}
	}  	
	
	sort($epochArray);
	
	foreach ($epochArray as $stamp) {
		
		foreach ($fileArray as $file) {
			
			if (substr($file, -10) == $stamp) {
				$outArray[] = $file;
			}
		}
	}
	
	if (!$outArray) $outArray = array();
	return $outArray;
	
}

function getNextUnifiedFile($current, $sensorID) {
	
	$array = getUnifiedFileArray($sensorID);
	
	foreach ($array as $file) {

		if ($next == 1) {
			$nextFile = $file;
			break;
		}
		
		if ($current == $file) {
			$next = 1;
		}
		
	}
	
	if (!$nextFile) $nextFile = $current;
	
	return $nextFile;
}

function loadSidMsgMap($sensorID) {
	global $root_path;
	
	$tmpData = @file("$root_path/conf/unified/default.sid-msg.map");
	
	foreach ($tmpData as $line) {

		$tmp = explode(" || ", $line);
		
		$sidOut[$tmp[0]] = $line;
		
	}
	
	return $sidOut;
	
}

?>